# バッチ設計書 4-eng/build.sh

## 概要

本ドキュメントは、Roslynプロジェクトのメインビルドスクリプト（Bash版）「eng/build.sh」の設計仕様を記載する。

### 本バッチの処理概要

eng/build.shは、Unix環境（Linux/macOS）においてRoslynプロジェクトのビルドプロセス全体を制御するBashスクリプトである。リストア、ビルド、パック、テストの各フェーズを統合的に管理する。

**業務上の目的・背景**：Roslynコンパイラのクロスプラットフォーム開発を支援し、Linux/macOS環境での開発・CI/CDを可能にする。eng/build.ps1のBash版として、Windows以外の環境でも同等のビルド機能を提供する。ソースビルドやプロダクトビルドモードにも対応し、.NET全体のビルドインフラストラクチャとの統合を実現する。

**バッチの実行タイミング**：開発者による手動実行（build.sh経由または直接）、CI/CDパイプラインでの自動実行。Unix環境での開発時やクロスプラットフォームビルドの検証時に使用される。

**主要な処理内容**：
1. コマンドライン引数の解析（--configuration, --restore, --build, --test等）
2. Arcade共通ツール（tools.sh）の読み込みと初期化
3. ブートストラップコンパイラの構築（--bootstrapオプション時）
4. MSBuildを使用したソリューションのビルド（BuildSolution関数）
5. .NET Coreおよびモノランタイムでのテスト実行
6. dotnetツールの復元

**前後の処理との関連**：build.shから呼び出される。common/tools.shに依存し、Arcadeビルドインフラストラクチャを使用する。テスト実行時はRunTests.dllを使用する。

**影響範囲**：ソリューション全体のビルド成果物（artifacts/binディレクトリ）、NuGetパッケージ、テスト結果等に影響を与える。

## バッチ種別

ビルド処理（リストア・コンパイル・テスト・パッケージング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix環境 | Linux または macOS で実行可能 |
| Bash | Bashシェルが利用可能であること |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| 実行権限 | スクリプトに実行権限が付与されていること |

### 実行可否判定

- 引数なしで実行すると使用方法を表示して終了
- 不正な引数が指定された場合はエラー終了
- `set -u`により未定義変数の使用はエラー
- `set -e`によりサブコマンドの失敗で即座に終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --configuration | string | No | Debug | ビルド構成（Debug/Release） |
| --verbosity | string | No | minimal | MSBuildの詳細度 |
| --binaryLog | switch | No | false | バイナリログ出力 |
| --restore | switch | No | false | パッケージリストア実行 |
| --build | switch | No | false | ビルド実行 |
| --rebuild | switch | No | false | リビルド実行 |
| --pack | switch | No | false | パッケージ作成 |
| --publish | switch | No | false | 成果物公開 |
| --sign | switch | No | false | 署名実行 |
| --testCoreClr | switch | No | false | .NET Coreテスト実行 |
| --testMono | switch | No | false | Monoテスト実行 |
| --testCompilerOnly | switch | No | false | コンパイラテストのみ |
| --testIOperation | switch | No | false | IOperation検証付きテスト |
| --testRuntimeAsync | switch | No | false | RuntimeAsync検証テスト |
| --ci | switch | No | false | CI環境フラグ |
| --bootstrap | switch | No | false | ブートストラップコンパイラ使用 |
| --runAnalyzers | switch | No | false | アナライザ実行 |
| --skipDocumentation | switch | No | false | ドキュメント生成スキップ |
| --warnAsError | switch | No | false | 警告をエラーとして扱う |
| --sourceBuild | switch | No | false | ソースビルドモード |
| --productBuild | switch | No | false | プロダクトビルドモード |
| --solution | string | No | Compilers.slnf | ビルド対象ソリューション |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Compilers.slnf | Solution Filter | デフォルトビルド対象 |
| ソースコード | C#/VB | コンパイル対象のソースファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | DLL | コンパイル済みバイナリ |
| artifacts/packages | NuGet | 生成されたNuGetパッケージ |
| artifacts/log | binlog | ビルドログ |
| artifacts/Bootstrap | 各種 | ブートストラップコンパイラ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Build.binlog |
| 出力先 | artifacts/log |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ whileループでオプションを処理
2. Arcade共通ツール読み込み
   └─ common/tools.shをsource
3. .NET CLI初期化
   └─ InitializeDotNetCli関数
4. dotnetツール復元（--restore時）
   └─ dotnet tool restore
5. ブートストラップビルド（--bootstrap時）
   └─ MakeBootstrapBuild関数
6. ソリューションビルド（--build等）
   └─ BuildSolution関数でMSBuild実行
7. テスト実行（--testCoreClr時）
   └─ RunTests.dll実行
8. 正常終了
   └─ ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[build.sh開始] --> B[引数解析]
    B --> C{引数なし?}
    C -->|Yes| D[使用方法表示]
    D --> E[終了]
    C -->|No| F[tools.sh読み込み]
    F --> G[InitializeDotNetCli]
    G --> H{--restore?}
    H -->|Yes| I[dotnet tool restore]
    H -->|No| J{--bootstrap?}
    I --> J
    J -->|Yes| K[MakeBootstrapBuild]
    J -->|No| L{ビルド系オプション?}
    K --> L
    L -->|Yes| M[BuildSolution]
    L -->|No| N{--testCoreClr?}
    M --> N
    N -->|Yes| O[RunTests.dll実行]
    N -->|No| P[正常終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正な引数が指定された場合 | 使用方法を確認し正しい引数を指定 |
| 非0 | ビルドエラー | コンパイルエラー | エラーメッセージに従い修正 |
| 非0 | テストエラー | テスト失敗 | テスト結果を確認し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. 標準出力/標準エラー出力を確認
3. artifacts/log配下のバイナリログを確認
4. エラー内容に応じてソースコードまたは環境を修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コンパイラプロジェクト群 |
| 目標処理時間 | 環境依存（通常5-20分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

- node_reuseオプションでMSBuildノード再利用を制御
- 同一ディレクトリでの複数ビルド同時実行は非推奨
- Mac/LinuxではNuGetのファイルディスクリプタ上限を6500に設定

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 常時 | ビルド進捗 |
| バイナリログ | --binaryLog時 | MSBuild詳細ログ |
| コンパイラログ | ビルド時 | VBCSCompilerログ |
| テストログ | テスト時 | テスト結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDパイプライン |
| ビルド時間 | 環境依存 | CI/CDパイプライン |

## 備考

- デフォルトソリューションはCompilers.slnf（Windows版のRoslyn.slnxとは異なる）
- ソースビルドモードではdotnetコマンドが利用できない場合がある
- Monoテストの実行にはmonoコマンドが必要
- NuGetのファイルディスクリプタ上限問題の回避策としてulimitを設定
- --testIOperationを指定すると自動的に--testCoreClrも有効になる
