# バッチ設計書 40-eng_common_init-tools-native.ps1

## 概要

本ドキュメントは、ネイティブツール初期化を行うPowerShellスクリプト `eng/common/init-tools-native.ps1` の設計仕様を定義するものです。

### 本バッチの処理概要

このスクリプトは、global.jsonファイルで定義されたネイティブビルドツール（CMake等）を初期化・インストールするためのエントリーポイントです。dotnet/arcadeフレームワークを使用するリポジトリにおいて、ネイティブコード（C/C++等）のビルドに必要なツールチェーンを自動的にセットアップします。

**業務上の目的・背景**：.NETプロジェクトの一部には、ネイティブコード（P/Invokeで呼び出すネイティブライブラリ等）が含まれることがあります。これらをビルドするにはCMakeなどのネイティブビルドツールが必要です。このスクリプトは、global.jsonの"native-tools"セクションで定義されたツールを自動的にダウンロード・インストールし、ビルド環境を準備します。

**バッチの実行タイミング**：ビルドプロセスの初期段階（tools.ps1のInitializeNativeTools関数から呼び出し）、またはrestoreフェーズで実行されます。

**主要な処理内容**：
1. global.jsonの読み込みと"native-tools"セクションの解析
2. PathPromotion有効時: マシンにインストール済みのツールをPATHに追加
3. PathPromotion無効時: 各ツールのインストーラースクリプト実行
4. ツールの検証とPATHへの追加
5. Azure Pipelines変数の設定

**前後の処理との関連**：pipeline-logging-functions.ps1およびnative/CommonLibrary.psm1をインポートします。各ツール固有のインストールはnative/install-tool.ps1に委譲されます。

**影響範囲**：ネイティブツールインストールディレクトリ、環境変数PATH

## バッチ種別

ネイティブツール初期化 / インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時（restoreフェーズ） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | ビルドスクリプト/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | Windows PowerShell または PowerShell Core |
| global.json | リポジトリルートにglobal.jsonが存在すること |
| native-toolsセクション | global.jsonにnative-tools定義があること |

### 実行可否判定

global.jsonにnative-toolsセクションが存在する場合のみ実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -BaseUri | string | No | https://netcorenativeassets.blob.core.windows.net/resource-packages/external | ツールアーカイブのダウンロード元URL |
| -InstallDirectory | string | No | 自動決定 | ツールインストール先ディレクトリ |
| -Clean | switch | No | false | クリーンアップのみ実行 |
| -Force | switch | No | false | クリーン後にインストール |
| -DownloadRetries | int | No | 5 | ダウンロードリトライ回数 |
| -RetryWaitTimeInSeconds | int | No | 30 | リトライ待機時間（秒） |
| -GlobalJsonFile | string | No | 自動決定 | global.jsonファイルパス |
| -PathPromotion | switch | No | false | マシン上のツールをPATHに追加するモード |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | native-toolsセクション定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| インストールディレクトリ/bin | ディレクトリ | インストールされたツール |
| 戻り値 | string | インストールディレクトリのパス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ツール依存 |
| 出力先 | $InstallDirectory/bin |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. GlobalJsonFileパスの決定
   └─ 未指定時は$PSScriptRoot\..\..を基準に設定
2. StrictModeとエラーハンドリング設定
3. 依存スクリプトのインポート
   └─ pipeline-logging-functions.ps1
   └─ native/CommonLibrary.psm1
4. インストールディレクトリの決定
   └─ 未指定時はCommonLibrary\Get-NativeInstallDirectoryを使用
5. global.jsonの読み込み
6. native-toolsセクションの解析
7. PathPromotionモード判定
   ├─ 有効時: arcade-toolsディレクトリからツールを検索してPATHに追加
   └─ 無効時: 各ツールをinstall-tool.ps1経由でインストール
8. インストール結果の検証
9. PATHへの追加（Azure Pipelines変数設定）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GlobalJsonFileパス決定]
    B --> C[StrictMode設定]
    C --> D[依存スクリプトインポート]
    D --> E[インストールディレクトリ決定]
    E --> F[global.json読み込み]
    F --> G{native-tools存在?}
    G -->|No| H[終了 exit 0]
    G -->|Yes| I{PathPromotion?}
    I -->|Yes| J{arcade-tools存在?}
    J -->|Yes| K[ツールごとにPATH追加]
    J -->|No| L[エラー警告出力]
    L --> H
    K --> M[InstalledTools返却]
    I -->|No| N[ツールごとにinstall-tool.ps1実行]
    N --> O{インストール成功?}
    O -->|Yes| P[次のツールへ]
    O -->|No| Q{AbortOnFailure?}
    Q -->|Yes| R[エラー終了]
    Q -->|No| S[警告出力]
    S --> P
    P --> N
    N --> T{Clean?}
    T -->|Yes| U[終了 exit 0]
    T -->|No| V{InstallBin存在?}
    V -->|Yes| W[PATH追加・変数設定]
    W --> X[InstallBin返却]
    V -->|No| Y[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | NativeToolsBootstrap | ツールインストール失敗 | ネットワーク確認、手動インストール |
| 1 | NativeToolsBootstrap | arcade-toolsディレクトリ未検出（PathPromotion時） | イメージの確認 |
| 1 | NativeToolsBootstrap | インストールディレクトリ未作成 | ディスク容量・権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（デフォルト） |
| リトライ間隔 | 30秒（デフォルト） |
| リトライ対象エラー | ダウンロードエラー |

### 障害時対応

1. ネットワーク接続を確認
2. BaseUriの有効性を確認
3. global.jsonのnative-tools定義を確認
4. 手動でツールをインストール

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | native-toolsで定義されたツール数 |
| 目標処理時間 | ツール数・ネットワーク速度に依存 |
| メモリ使用量上限 | システム依存 |

## 排他制御

特になし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 処理開始時 | "Processing $GlobalJsonFile" |
| 進捗ログ | ツール追加時 | "Adding $ToolName to the path..." |
| 進捗ログ | インストール完了時 | "Native tools are available from..." |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError |
| Azure変数 | PATH追加時 | "##vso[task.prependpath]..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |

## 備考

- PathPromotionモード: CIビルドマシンにプリインストールされたツールを使用する場合に有効
- arcade-toolsディレクトリ: C:\arcade-tools（Windows）にツールがプリインストールされている場合に使用
- binpath.txt: 各ツールのインストールディレクトリにあり、PATHに追加すべきディレクトリを指定
- DoNotAbortNativeToolsInstallationOnFailure変数で、インストール失敗時の動作を制御可能
- DoNotDisplayNativeToolsInstallationWarnings変数で、警告表示を抑制可能
- CommonLibrary.psm1モジュールとinstall-tool.ps1に主要なインストールロジックを委譲
