# バッチ設計書 41-init-tools-native.sh

## 概要

本ドキュメントは、ネイティブツール初期化スクリプト（Bash版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Roslynプロジェクトのビルドに必要なネイティブツール（CMake等）をUnix/Linux環境で初期化・インストールするためのシェルスクリプトである。

**業務上の目的・背景**：Roslynのビルドプロセスでは、.NETコンパイラに加えてCMake等のネイティブビルドツールが必要となる場合がある。特にクロスプラットフォームビルドやネイティブコード生成を行う際に、これらのツールが適切にインストールされていることが前提条件となる。本スクリプトはglobal.jsonの「native-tools」セクションに定義されたツールを自動的に検出し、必要なバージョンをダウンロード・インストールすることで、開発者やCIパイプラインがビルド環境を手動でセットアップする手間を省き、一貫したビルド環境を保証する。

**バッチの実行タイミング**：ビルド実行前の準備段階として実行される。CI/CDパイプラインの初期化フェーズで呼び出されることが多い。手動でのビルド環境セットアップ時にも使用される。

**主要な処理内容**：
1. global.jsonファイルから「native-tools」セクションを解析し、必要なツールとバージョンを抽出
2. 各ツールに対応するインストールスクリプト（install-{ツール名}.sh）を検索
3. 指定されたバージョンのツールをAzure Blobストレージからダウンロード
4. インストールディレクトリにツールを配置
5. Azure Pipelinesの環境変数（PATH）を更新してツールを利用可能にする

**前後の処理との関連**：本スクリプトはeng/common/tools.shのInitializeNativeTools関数から呼び出される。ビルドスクリプト（eng/build.sh）の実行前に、必要なネイティブツールが利用可能な状態を整える前提条件として機能する。

**影響範囲**：ローカルのインストールディレクトリ（デフォルト：$HOME/.netcoreeng/native）にネイティブツールがインストールされる。Azure Pipelines環境では、PATH環境変数が更新されて後続のタスクでツールが利用可能になる。

## バッチ種別

ツール管理 / 環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CI/build.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| global.jsonの存在 | リポジトリルートにglobal.jsonファイルが存在し、native-toolsセクションが定義されていること |
| Bashシェル環境 | Bash互換のシェル環境が利用可能であること |
| ネットワーク接続 | Azure Blobストレージ（netcorenativeassets.blob.core.windows.net）へのアクセスが可能であること |
| 書き込み権限 | インストールディレクトリへの書き込み権限があること |

### 実行可否判定

global.jsonにnative-toolsセクションが存在しない場合、スクリプトは「No native tools defined in global.json」とメッセージを出力して正常終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --baseuri | string | No | https://netcorenativeassets.blob.core.windows.net/resource-packages/external | ツールダウンロード元のベースURI |
| --installdirectory | string | No | $HOME/.netcoreeng/native | ツールのインストール先ディレクトリ |
| --clean | switch | No | false | インストールせずにクリーンアップのみ実行 |
| --force | switch | No | false | 既存ツールを削除して再インストール |
| --donotabortonfailure | switch | No | false | 失敗時にスクリプトを中断しない |
| --donotdisplaywarnings | switch | No | false | 警告メッセージを表示しない |
| --downloadretries | int | No | 5 | ダウンロード再試行回数 |
| --retrywaittimeseconds | int | No | 30 | 再試行待機時間（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | native-toolsセクションからツール名とバージョンを取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| インストールディレクトリ/bin | バイナリ | インストールされたネイティブツールの実行ファイル |
| 標準出力 | テキスト | 処理状況のログメッセージ |
| Azure Pipelines変数 | 環境変数 | ##vso[task.prependpath]コマンドでPATH更新 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ツール固有（cmake等） |
| 出力先 | {インストールディレクトリ}/bin |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ コマンドライン引数を解析し、各種設定を初期化
2. 共通ライブラリの読み込み
   └─ pipeline-logging-functions.shとnative/common-library.shをソース
3. global.json解析
   └─ ReadGlobalJsonNativeTools関数でnative-toolsセクションを解析
4. ネイティブツールの列挙
   └─ 解析結果からツール名とバージョンのペアを取得
5. 各ツールのインストール
   └─ install-{ツール名}.shスクリプトを呼び出し
6. 結果確認
   └─ インストールディレクトリの存在確認とPATH更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[共通ライブラリ読み込み]
    C --> D[global.json解析]
    D --> E{native-tools<br/>セクション存在?}
    E -->|なし| F[メッセージ出力して終了]
    E -->|あり| G[ツール一覧取得]
    G --> H{次のツールあり?}
    H -->|あり| I[インストールスクリプト検索]
    I --> J{スクリプト<br/>存在?}
    J -->|あり| K[インストール実行]
    J -->|なし| L[エラー処理]
    K --> M{成功?}
    M -->|はい| H
    M -->|いいえ| L
    L --> N{中断<br/>設定?}
    N -->|中断| O[エラー終了]
    N -->|継続| H
    H -->|なし| P[PATH更新]
    P --> Q[正常終了]
    F --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 実行失敗 | インストールスクリプトが存在しない | 対応するインストールスクリプトを作成するか、--donotabortonfailureで継続 |
| 1 | 実行失敗 | インストールスクリプトの実行エラー | ネットワーク接続確認、ダウンロードリトライ設定の調整 |
| 1 | インストール失敗 | ツールインストール後にbinディレクトリが存在しない | インストールディレクトリの権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（--downloadretriesで設定可能） |
| リトライ間隔 | 30秒（--retrywaittimesecondsで設定可能） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

失敗時は--donotabortonfailureオプションを使用して継続実行するか、ネットワーク接続とAzure Blobストレージへのアクセスを確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜5ツール程度 |
| 目標処理時間 | ネットワーク状況依存（通常1〜5分） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定していないが、インストールディレクトリへの並行書き込みは避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ツールインストール開始時 | インストールコマンドの内容 |
| 進捗ログ | インストール中 | 各インストールスクリプトからの出力 |
| 終了ログ | 全ツールインストール完了時 | ツールのインストール先パス |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによるAzure Pipelinesエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | Azure Pipelines |
| エラー件数 | 1件以上 | Azure Pipelines（##vso[task.logissue]） |

## 備考

- jqコマンドが利用可能な場合はjqを使用してJSONを解析し、利用不可の場合はBashの正規表現でフォールバック解析を行う
- PowerShell版（init-tools-native.ps1）とペアで提供されており、Windows環境ではPowerShell版を使用する
