# バッチ設計書 42-msbuild.ps1

## 概要

本ドキュメントは、MSBuildラッパースクリプト（PowerShell版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、MSBuildを適切な設定で実行するためのPowerShellラッパースクリプトである。tools.ps1で定義されたMSBuild関数を呼び出し、一貫したビルド設定でMSBuildを実行する。

**業務上の目的・背景**：Roslynプロジェクトのビルドでは、MSBuildに対して様々な設定（verbosity、warnAsError、nodeReuse等）を一貫して適用する必要がある。開発者やCIパイプラインが直接MSBuildを呼び出すと設定の不整合が生じる可能性があるため、本スクリプトを介することで統一されたビルド環境を提供する。特にCI環境ではnodeReuseを無効化する必要があり、本スクリプトがその制御を自動的に行う。

**バッチの実行タイミング**：ビルド時に直接呼び出されるか、他のビルドスクリプト（build.ps1等）から内部的に使用される。CI/CDパイプラインのビルドステップで頻繁に使用される。

**主要な処理内容**：
1. コマンドライン引数（verbosity、warnAsError、nodeReuse等）を解析
2. CI環境の場合、nodeReuseを自動的に無効化
3. tools.ps1の共通ユーティリティを読み込み
4. MSBuild関数を呼び出して追加引数を渡す
5. エラー発生時は適切なテレメトリエラーを出力して終了

**前後の処理との関連**：本スクリプトはtools.ps1に依存しており、MSBuild関数やInitializeBuildTool等の共通関数を使用する。ビルドスクリプト（build.ps1）やSDKタスクスクリプト（sdk-task.ps1）から呼び出されることがある。

**影響範囲**：MSBuildを通じてプロジェクトファイル（.csproj、.proj等）をビルドし、artifacts/bin、artifacts/objディレクトリにビルド成果物を生成する。ビルドログはartifacts/logディレクトリに出力される。

## バッチ種別

ビルド / MSBuild実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CI/他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | PowerShell 5.1以降またはPowerShell Coreが利用可能であること |
| tools.ps1の存在 | 同ディレクトリにtools.ps1が存在すること |
| .NET SDK/VS | global.jsonで指定されたdotnet SDKまたはVisual Studioがインストールされていること |

### 実行可否判定

引数の検証は行わず、渡された引数をそのままMSBuild関数に転送する。MSBuild関数内でビルドツールの初期化とエラー処理を行う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -verbosity | string | No | minimal | MSBuildの詳細度レベル（q/m/n/d/diag） |
| -warnAsError | bool | No | $true | 警告をエラーとして扱うかどうか |
| -nodeReuse | bool | No | $true | MSBuildノードを再利用するかどうか |
| -ci | switch | No | $false | CI環境フラグ（設定時nodeReuseを無効化） |
| -prepareMachine | switch | No | $false | マシン準備モード（終了時にプロセスを停止） |
| -excludePrereleaseVS | switch | No | $false | プレリリース版VSを除外するかどうか |
| -msbuildEngine | string | No | $null | 使用するMSBuildエンジン（dotnet/vs） |
| extraArgs | string[] | No | 空 | MSBuildに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| プロジェクトファイル | .csproj/.proj | ビルド対象のプロジェクトファイル（extraArgsで指定） |
| global.json | JSON | dotnetバージョンやVS要件の取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | バイナリ | ビルド成果物（アセンブリ等） |
| artifacts/log | ログファイル | バイナリログ（.binlog） |
| 標準出力 | テキスト | ビルド進捗とサマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | プロジェクト名に基づく |
| 出力先 | artifacts/bin/{Configuration}/{TargetFramework} |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ PowerShellパラメータバインディングで引数を取得
2. CI環境判定
   └─ -ciフラグがある場合、nodeReuseを$falseに設定
3. tools.ps1読み込み
   └─ 共通ユーティリティ関数をドットソース
4. MSBuild実行
   └─ MSBuild関数に追加引数を渡して実行
5. 結果処理
   └─ 成功時は終了コード0、失敗時はエラー出力して終了コード1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{CI環境?}
    C -->|はい| D[nodeReuse = false]
    C -->|いいえ| E[nodeReuse維持]
    D --> F[tools.ps1読み込み]
    E --> F
    F --> G[MSBuild関数呼び出し]
    G --> H{成功?}
    H -->|はい| I[ExitWithExitCode 0]
    H -->|いいえ| J[エラーログ出力]
    J --> K[ExitWithExitCode 1]
    I --> L[バッチ終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ビルドエラー | MSBuildがエラー終了 | ビルドエラーメッセージを確認して修正 |
| 1 | ツール初期化失敗 | dotnet SDKまたはVSが見つからない | global.jsonの設定確認、SDK/VSインストール |
| 1 | スクリプトエラー | PowerShellスクリプト実行エラー | スタックトレースを確認して原因調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（MSBuild自体にリトライ機能なし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

catchブロックでスタックトレースを出力し、Write-PipelineTelemetryErrorでAzure Pipelinesにエラーを報告する。その後ExitWithExitCode 1で終了する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト数に依存 |
| 目標処理時間 | プロジェクト規模に依存 |
| メモリ使用量上限 | MSBuildの制限に依存 |

## 排他制御

CI環境ではnodeReuse=falseにより、MSBuildノードの共有を無効化する。これにより並列ビルド時の競合を防止する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | MSBuild開始時 | ビルドコマンドの内容 |
| 進捗ログ | ビルド中 | verbosityに応じた詳細度でビルド進捗 |
| 終了ログ | ビルド完了時 | サマリー（/clp:Summary） |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError経由でのエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |
| ビルドエラー | 1件以上 | Azure Pipelines（Build category） |

## 備考

- Bash版（msbuild.sh）とペアで提供されており、Unix環境ではBash版を使用する
- MSBuild関数はtools.ps1で定義されており、pipelinesLog有効時はArcadeLoggerを自動的に追加する
- CI環境（-ci）では警告をエラーとして扱う設定が推奨される
