# バッチ設計書 43-msbuild.sh

## 概要

本ドキュメントは、MSBuildラッパースクリプト（Bash版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Unix/Linux環境でMSBuildを適切な設定で実行するためのBashラッパースクリプトである。tools.shで定義されたMSBuild関数を呼び出し、dotnet msbuildコマンドを一貫したビルド設定で実行する。

**業務上の目的・背景**：Roslynプロジェクトはクロスプラットフォームでビルド可能であり、Unix/Linux環境ではdotnet CLIを通じてMSBuildを実行する必要がある。本スクリプトはPowerShell版（msbuild.ps1）と同等の機能をBash環境で提供し、開発者やCIパイプラインが一貫したビルド設定でプロジェクトをビルドできるようにする。CI環境ではnodeReuseを自動的に無効化し、ビルドの安定性を確保する。

**バッチの実行タイミング**：Unix/Linux環境でのビルド時に直接呼び出されるか、他のビルドスクリプト（build.sh等）から内部的に使用される。macOSやLinuxのCI/CDパイプラインで頻繁に使用される。

**主要な処理内容**：
1. コマンドライン引数（--verbosity、--warnaserror、--nodereuse等）を解析
2. CI環境の場合（--ci）、nodeReuseを自動的に無効化
3. tools.shの共通ユーティリティを読み込み
4. MSBuild関数を呼び出して追加引数を渡す
5. ExitWithExitCode 0で正常終了

**前後の処理との関連**：本スクリプトはtools.shに依存しており、MSBuild関数やInitializeBuildTool等の共通関数を使用する。ビルドスクリプト（build.sh）やSDKタスクスクリプト（sdk-task.sh）から呼び出されることがある。

**影響範囲**：dotnet msbuildを通じてプロジェクトファイル（.csproj、.proj等）をビルドし、artifacts/bin、artifacts/objディレクトリにビルド成果物を生成する。ビルドログはartifacts/logディレクトリに出力される。

## バッチ種別

ビルド / MSBuild実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CI/他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル環境 | Bash互換のシェル環境が利用可能であること |
| tools.shの存在 | 同ディレクトリにtools.shが存在すること |
| .NET SDK | global.jsonで指定されたdotnet SDKがインストールされていること |

### 実行可否判定

引数の検証は行わず、渡された引数をそのままMSBuild関数に転送する。MSBuild関数内でビルドツールの初期化とエラー処理を行う。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --verbosity | string | No | minimal | MSBuildの詳細度レベル（q/m/n/d/diag） |
| --warnaserror | bool | No | true | 警告をエラーとして扱うかどうか |
| --nodereuse | bool | No | true | MSBuildノードを再利用するかどうか |
| --ci | switch | No | false | CI環境フラグ（設定時nodeReuseを無効化） |
| --preparemachine | switch | No | false | マシン準備モード（終了時にプロセスを停止） |
| その他 | string | No | 空 | MSBuildに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| プロジェクトファイル | .csproj/.proj | ビルド対象のプロジェクトファイル（追加引数で指定） |
| global.json | JSON | dotnetバージョンの取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | バイナリ | ビルド成果物（アセンブリ等） |
| artifacts/log | ログファイル | バイナリログ（.binlog） |
| 標準出力 | テキスト | ビルド進捗とサマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | プロジェクト名に基づく |
| 出力先 | artifacts/bin/{Configuration}/{TargetFramework} |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. シンボリックリンク解決
   └─ スクリプトパスのシンボリックリンクを解決
2. 変数初期化
   └─ verbosity、warn_as_error、node_reuseのデフォルト値設定
3. 引数解析
   └─ whileループでコマンドライン引数を解析
4. tools.sh読み込み
   └─ 共通ユーティリティ関数をソース
5. CI環境判定
   └─ ci=trueの場合、node_reuseをfalseに設定
6. MSBuild実行
   └─ MSBuild関数に追加引数を渡して実行
7. 終了
   └─ ExitWithExitCode 0で正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[シンボリックリンク解決]
    B --> C[変数初期化]
    C --> D[引数解析ループ]
    D --> E[tools.sh読み込み]
    E --> F{CI環境?}
    F -->|はい| G[node_reuse = false]
    F -->|いいえ| H[node_reuse維持]
    G --> I[MSBuild関数呼び出し]
    H --> I
    I --> J[ExitWithExitCode 0]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルドエラー | MSBuildがエラー終了 | ビルドエラーメッセージを確認して修正 |
| 非0 | ツール初期化失敗 | dotnet SDKが見つからない | global.jsonの設定確認、SDKインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

MSBuild関数内でエラーが発生した場合、エラーメッセージを出力して終了コードを返す。CI環境ではWrite-PipelineSetResultでAzure Pipelinesにエラーを報告する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクト数に依存 |
| 目標処理時間 | プロジェクト規模に依存 |
| メモリ使用量上限 | MSBuildの制限に依存 |

## 排他制御

CI環境ではnode_reuse=falseにより、MSBuildノードの共有を無効化する。これにより並列ビルド時の競合を防止する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | MSBuild開始時 | ビルドコマンドの内容 |
| 進捗ログ | ビルド中 | verbosityに応じた詳細度でビルド進捗 |
| 終了ログ | ビルド完了時 | サマリー（/clp:Summary） |
| エラーログ | エラー発生時 | MSBuildからのエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |
| ビルドエラー | 1件以上 | Azure Pipelines |

## 備考

- PowerShell版（msbuild.ps1）とペアで提供されており、Windows環境ではPowerShell版を使用する
- スクリプトパスのシンボリックリンクを解決してから処理を開始する
- 引数は大文字小文字を区別せずに解析される（toLowerで変換）
- 認識されない引数はextra_argsに追加され、MSBuildに渡される
