# バッチ設計書 44-sdk-task.ps1

## 概要

本ドキュメントは、Arcade SDKタスク実行スクリプト（PowerShell版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、dotnet/arcadeのSDKタスクを実行するためのPowerShellスクリプトである。Arcade SDKパッケージに含まれるSdkTasksディレクトリ内のプロジェクトファイル（.proj）を指定して実行する。

**業務上の目的・背景**：dotnet/arcadeは.NETプロジェクト共通のビルドインフラストラクチャを提供しており、その中にはPublishやSign等の共通タスクが含まれている。これらのタスクはSdkTasksディレクトリにプロジェクトファイルとして定義されており、本スクリプトを通じて統一的に実行できる。CI/CDパイプラインで成果物の公開や署名を行う際に使用される。

**バッチの実行タイミング**：ビルド後の公開処理、署名処理、その他Arcade SDKが提供するタスクを実行する際に呼び出される。CI/CDパイプラインの後処理ステップで頻繁に使用される。

**主要な処理内容**：
1. コマンドライン引数（-task、-configuration、-restore等）を解析
2. ヘルプ表示の要求があれば使用方法を出力
3. -taskパラメータが指定されていることを確認
4. 指定されたタスクに対応するプロジェクトファイルを取得（GetSdkTaskProject）
5. -restore指定時はRestoreターゲットを実行
6. Executeターゲットを実行してタスクを完了

**前後の処理との関連**：本スクリプトはtools.ps1に依存しており、InitializeToolset、MSBuild、GetSdkTaskProject等の共通関数を使用する。ビルド完了後に公開や署名などの後処理として呼び出されることが多い。

**影響範囲**：タスクによって異なるが、パッケージの公開（NuGetフィードへのアップロード）、署名（コード署名）、その他のビルド後処理を実行する。

## バッチ種別

SDK管理 / タスク実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド後処理時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CI/他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | PowerShell 5.1以降またはPowerShell Coreが利用可能であること |
| tools.ps1の存在 | 同ディレクトリにtools.ps1が存在すること |
| Arcade SDKの復元 | Microsoft.DotNet.Arcade.Sdkが復元済みであること |
| .NET SDK | global.jsonで指定されたdotnet SDKがインストールされていること |

### 実行可否判定

-taskパラメータが必須。指定されていない場合はエラーメッセージを出力して終了する。指定されたタスクに対応するプロジェクトファイルが存在しない場合もエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -configuration | string | No | Debug | ビルド構成（Debug/Release等） |
| -task | string | Yes | - | 実行するArcade SDKタスク名 |
| -verbosity | string | No | minimal | MSBuildの詳細度レベル |
| -msbuildEngine | string | No | $null | 使用するMSBuildエンジン（dotnet/vs） |
| -restore | switch | No | $false | 依存関係を復元するかどうか |
| -prepareMachine | switch | No | $false | マシン準備モード |
| -excludeCIBinaryLog | switch | No | $false | バイナリログを無効化（-noblエイリアス） |
| -noWarnAsError | switch | No | $false | 警告をエラーとして扱わない |
| -help | switch | No | $false | ヘルプを表示 |
| -runtimeSourceFeed | string | No | '' | ランタイム取得元のフィードURL |
| -runtimeSourceFeedKey | string | No | '' | ランタイムフィードの認証キー |
| properties | string[] | No | 空 | MSBuildに渡す追加プロパティ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SdkTasks/{task}.proj | MSBuildプロジェクト | Arcade SDKのタスク定義ファイル |
| global.json | JSON | SDKバージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/log | ログファイル | タスク実行ログ（.binlog） |
| 標準出力 | テキスト | タスク実行進捗 |
| タスク依存 | 可変 | タスクによって異なる（公開、署名等） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {task}.binlog / {task}.{ターゲット}.binlog |
| 出力先 | artifacts/log/{Configuration} |
| 文字コード | N/A（バイナリログ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ PowerShellパラメータバインディングで引数を取得
2. 変数設定
   └─ ci=$true、binaryLog、warnAsErrorの設定
3. tools.ps1読み込み
   └─ 共通ユーティリティ関数をドットソース
4. ヘルプ判定
   └─ -helpまたは/?が指定されていればPrint-Usage実行して終了
5. タスク検証
   └─ -taskが空の場合はエラー終了
6. MSBuildエンジン設定
   └─ -msbuildEngine=vsの場合、xcopy-msbuildを初期化
7. タスクプロジェクト取得
   └─ GetSdkTaskProjectでプロジェクトパスを取得
8. プロジェクト存在確認
   └─ プロジェクトファイルが存在しない場合はエラー終了
9. Restore実行（オプション）
   └─ -restore指定時はBuild 'Restore'を実行
10. Execute実行
    └─ Build 'Execute'でタスクを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[変数設定]
    C --> D[tools.ps1読み込み]
    D --> E{ヘルプ要求?}
    E -->|はい| F[Print-Usage]
    F --> G[exit 0]
    E -->|いいえ| H{-task指定?}
    H -->|いいえ| I[エラー: -task必須]
    I --> J[ExitWithExitCode 1]
    H -->|はい| K{msbuildEngine=vs?}
    K -->|はい| L[xcopy-msbuild初期化]
    K -->|いいえ| M[タスクプロジェクト取得]
    L --> M
    M --> N{プロジェクト存在?}
    N -->|いいえ| O[エラー: Unknown task]
    O --> J
    N -->|はい| P{-restore?}
    P -->|はい| Q[Build 'Restore']
    P -->|いいえ| R[Build 'Execute']
    Q --> R
    R --> S[ExitWithExitCode 0]
    S --> T[バッチ終了]
    G --> T
    J --> T
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない（タスク内容によってはNuGetフィード等への書き込みあり）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 必須パラメータ不足 | -taskパラメータが指定されていない | -taskパラメータを指定する |
| 1 | 不明なタスク | 指定されたタスクのプロジェクトファイルが存在しない | タスク名を確認、Arcade SDKバージョン確認 |
| 1 | MSBuildエラー | タスク実行中にビルドエラー発生 | エラーメッセージを確認して修正 |
| 1 | xcopy-msbuild初期化失敗 | VS用MSBuildのダウンロード/初期化失敗 | ネットワーク接続確認、パッケージバージョン確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

catchブロックでスタックトレースを出力し、Write-PipelineTelemetryErrorでAzure Pipelinesにエラーを報告する。その後ExitWithExitCode 1で終了する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | タスクによって異なる |
| 目標処理時間 | タスクによって異なる |
| メモリ使用量上限 | MSBuildの制限に依存 |

## 排他制御

特になし。ただしPublishタスク等は同時実行を避けるべき。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名と設定 |
| 進捗ログ | タスク実行中 | verbosityに応じた詳細度 |
| 終了ログ | タスク完了時 | サマリー |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError経由でのエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |
| タスクエラー | 1件以上 | Azure Pipelines（Build category） |

## 備考

- Bash版（sdk-task.sh）とペアで提供されており、Unix環境ではBash版を使用する
- ciフラグは常にtrueに設定される（スクリプト内で固定）
- -msbuildEngine=vsの場合、xcopy-msbuildを使用してVisual Studio MSBuildをダウンロード・使用する
- バイナリログのファイル名はターゲットによって異なる（Execute時は{task}.binlog、Restore時は{task}.Restore.binlog）
