# バッチ設計書 45-sdk-task.sh

## 概要

本ドキュメントは、Arcade SDKタスク実行スクリプト（Bash版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Unix/Linux環境でdotnet/arcadeのSDKタスクを実行するためのBashスクリプトである。Arcade SDKパッケージに含まれるSdkTasksディレクトリ内のプロジェクトファイル（.proj）を指定して実行する。

**業務上の目的・背景**：dotnet/arcadeは.NETプロジェクト共通のビルドインフラストラクチャを提供しており、その中にはPublishやSign等の共通タスクが含まれている。Unix/Linux環境のCI/CDパイプラインでこれらのタスクを実行する際に、本スクリプトが使用される。PowerShell版（sdk-task.ps1）と同等の機能をBash環境で提供する。

**バッチの実行タイミング**：ビルド後の公開処理、署名処理、その他Arcade SDKが提供するタスクを実行する際に呼び出される。macOSやLinuxのCI/CDパイプラインで頻繁に使用される。

**主要な処理内容**：
1. コマンドライン引数（--task、--restore、--verbosity等）を解析
2. ヘルプ表示の要求があれば使用方法を出力
3. --taskパラメータが指定されていることを確認
4. tools.shの共通ユーティリティを読み込み、InitializeToolsetを実行
5. GetSdkTaskProjectで指定されたタスクに対応するプロジェクトファイルを取得
6. --restore指定時はRestoreターゲットを実行
7. Executeターゲットを実行してタスクを完了

**前後の処理との関連**：本スクリプトはtools.shに依存しており、InitializeToolset、MSBuild、GetSdkTaskProject等の共通関数を使用する。ビルド完了後に公開や署名などの後処理として呼び出されることが多い。

**影響範囲**：タスクによって異なるが、パッケージの公開（NuGetフィードへのアップロード）、署名（コード署名）、その他のビルド後処理を実行する。

## バッチ種別

SDK管理 / タスク実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド後処理時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CI/他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル環境 | Bash互換のシェル環境が利用可能であること |
| tools.shの存在 | 同ディレクトリにtools.shが存在すること |
| Arcade SDKの復元 | Microsoft.DotNet.Arcade.Sdkが復元済みであること |
| .NET SDK | global.jsonで指定されたdotnet SDKがインストールされていること |

### 実行可否判定

--taskパラメータが必須。指定されていない場合はエラーメッセージを出力して終了する。指定されたタスクに対応するプロジェクトファイルが存在しない場合もエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --task | string | Yes | - | 実行するArcade SDKタスク名 |
| --restore | switch | No | false | 依存関係を復元するかどうか |
| --verbosity | string | No | minimal | MSBuildの詳細度レベル |
| --excludecibinarylog / --nobl | switch | No | false | バイナリログを無効化 |
| --noWarnAsError | switch | No | false | 警告をエラーとして扱わない |
| --help | switch | No | false | ヘルプを表示 |
| その他 | string | No | 空 | MSBuildに渡す追加プロパティ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SdkTasks/{task}.proj | MSBuildプロジェクト | Arcade SDKのタスク定義ファイル |
| global.json | JSON | SDKバージョン情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/log | ログファイル | タスク実行ログ（.binlog） |
| 標準出力 | テキスト | タスク実行進捗 |
| タスク依存 | 可変 | タスクによって異なる（公開、署名等） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {task}.binlog / {task}.{ターゲット}.binlog |
| 出力先 | artifacts/log/{Configuration} |
| 文字コード | N/A（バイナリログ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. show_usage関数定義
   └─ ヘルプ表示用関数を定義
2. シンボリックリンク解決
   └─ スクリプトパスのシンボリックリンクを解決
3. Build関数定義
   └─ MSBuildターゲット実行用関数を定義
4. 変数初期化
   └─ binary_log、configuration、verbosity等のデフォルト値設定
5. 引数解析
   └─ whileループでコマンドライン引数を解析
6. CI環境設定
   └─ ci=trueを設定
7. ヘルプ判定
   └─ --helpが指定されていればshow_usage実行して終了
8. tools.sh読み込み
   └─ 共通ユーティリティ関数をソースし、InitializeToolsetを実行
9. タスク検証
   └─ --taskが空の場合はエラー終了
10. タスクプロジェクト取得
    └─ GetSdkTaskProjectでプロジェクトパスを取得
11. プロジェクト存在確認
    └─ プロジェクトファイルが存在しない場合はエラー終了
12. Restore実行（オプション）
    └─ --restore指定時はBuild 'Restore'を実行
13. Execute実行
    └─ Build 'Execute'でタスクを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[関数定義]
    B --> C[シンボリックリンク解決]
    C --> D[変数初期化]
    D --> E[引数解析]
    E --> F[ci=true設定]
    F --> G{--help?}
    G -->|はい| H[show_usage]
    H --> I[exit 0]
    G -->|いいえ| J[tools.sh読み込み]
    J --> K[InitializeToolset]
    K --> L{--task指定?}
    L -->|いいえ| M[エラー: -task必須]
    M --> N[ExitWithExitCode 1]
    L -->|はい| O[GetSdkTaskProject]
    O --> P{プロジェクト存在?}
    P -->|いいえ| Q[エラー: Unknown task]
    Q --> N
    P -->|はい| R{--restore?}
    R -->|はい| S[Build 'Restore']
    R -->|いいえ| T[Build 'Execute']
    S --> T
    T --> U[ExitWithExitCode 0]
    U --> V[バッチ終了]
    I --> V
    N --> V
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない（タスク内容によってはNuGetフィード等への書き込みあり）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 必須パラメータ不足 | --taskパラメータが指定されていない | --taskパラメータを指定する |
| 1 | 不明なタスク | 指定されたタスクのプロジェクトファイルが存在しない | タスク名を確認、Arcade SDKバージョン確認 |
| 非0 | MSBuildエラー | タスク実行中にビルドエラー発生 | エラーメッセージを確認して修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Write-PipelineTelemetryErrorでAzure Pipelinesにエラーを報告し、ExitWithExitCode 1で終了する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | タスクによって異なる |
| 目標処理時間 | タスクによって異なる |
| メモリ使用量上限 | MSBuildの制限に依存 |

## 排他制御

特になし。ただしPublishタスク等は同時実行を避けるべき。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | タスク開始時 | タスク名と設定 |
| 進捗ログ | タスク実行中 | verbosityに応じた詳細度 |
| 終了ログ | タスク完了時 | サマリー |
| エラーログ | エラー発生時 | Write-PipelineTelemetryError経由でのエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelines |
| タスクエラー | 1件以上 | Azure Pipelines |

## 備考

- PowerShell版（sdk-task.ps1）とペアで提供されており、Windows環境ではPowerShell版を使用する
- ciフラグは常にtrueに設定される（スクリプト内で固定）
- 引数は大文字小文字を区別せずに解析される（toLowerで変換）
- InitializeToolsetが呼び出されることで、Arcade SDKが自動的に復元される
- --noWarnAsErrorは大文字小文字を区別する（他の引数と異なる）
