# バッチ設計書 47-darc-init.sh

## 概要

本ドキュメントは、Darc CLI初期化スクリプト（Bash版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Unix/Linux環境でdotnet/arcadeのDarc（Dependency Automation for Roslyn and Compiler）CLIツールをインストールするためのBashスクリプトである。DarcはMaestro（.NETの依存関係管理サービス）と連携するためのコマンドラインツールである。

**業務上の目的・背景**：dotnet/arcadeエコシステムでは、リポジトリ間の依存関係を自動的に管理するためにMaestroサービスを使用している。Darcはそのクライアントツールであり、サブスクリプションの管理、依存関係の更新、バージョンの同期などを行う。macOSやLinuxの開発者やCIパイプラインがMaestroと連携する際に、本スクリプトでDarcツールをインストールする。

**バッチの実行タイミング**：Maestroとの連携が必要な作業を行う前に実行される。CI/CDパイプラインでの依存関係更新処理や、開発者がローカルでDarcを使用する際にインストール目的で実行される。

**主要な処理内容**：
1. コマンドライン引数（--darcversion、--verbosity、--toolpath等）を解析
2. dotnet CLIを初期化（InitializeDotNetCli）
3. 既存のDarcインストールがあればアンインストール
4. バージョン指定がなければcurlでMaestro APIから最新バージョンを取得
5. Azure DevOps NuGetフィードからDarcパッケージをインストール

**前後の処理との関連**：本スクリプトはtools.shに依存しており、InitializeDotNetCli等の共通関数を使用する。インストール後はdarcコマンドがグローバルツールとして利用可能になり、Maestroとの連携処理で使用される。

**影響範囲**：グローバルdotnetツール（~/.dotnet/tools）またはtoolpathで指定されたディレクトリにDarcツールがインストールされる。

## バッチ種別

ツール管理 / 依存関係管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Darc使用前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動/CI/他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル環境 | Bash互換のシェル環境が利用可能であること |
| tools.shの存在 | 同ディレクトリにtools.shが存在すること |
| .NET SDK | global.jsonで指定されたdotnet SDKがインストールされていること |
| curl | curlコマンドが利用可能であること（バージョン取得用） |
| ネットワーク接続 | Maestro API（maestro.dot.net）およびAzure DevOpsフィードへのアクセスが可能であること |

### 実行可否判定

特に前提条件のチェックは行わない。dotnet CLIが利用できない場合はInitializeDotNetCliでインストールされる。不明な引数が渡された場合はエラーメッセージを出力して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --darcversion | string | No | '' | インストールするDarcのバージョン（未指定時はMaestro APIから取得） |
| --versionendpoint | string | No | https://maestro.dot.net/api/assets/darc-version?api-version=2020-02-20 | Darcバージョン取得用APIエンドポイント |
| --verbosity | string | No | minimal | dotnet toolコマンドの詳細度 |
| --toolpath | string | No | 未設定 | ツールのインストール先パス（未指定時はグローバルインストール） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Maestro API | REST API | Darcの推奨バージョンを取得（curl使用） |
| Azure DevOps NuGet Feed | NuGet | Darcパッケージの取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/.dotnet/tools または toolpath | 実行ファイル | Darc CLIツール |
| 標準出力 | テキスト | インストール状況のログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | darc |
| 出力先 | ~/.dotnet/tools または --toolpath引数で指定したパス |
| 文字コード | N/A（バイナリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 変数初期化
   └─ darcVersion、versionEndpoint、verbosityのデフォルト値設定
2. 引数解析
   └─ whileループでコマンドライン引数を解析
3. シンボリックリンク解決
   └─ スクリプトパスのシンボリックリンクを解決
4. tools.sh読み込み
   └─ 共通ユーティリティ関数をソース
5. バージョン取得
   └─ darcVersion未指定時はcurlでMaestro APIから取得
6. InstallDarcCli関数呼び出し
   └─ メイン処理開始
7. dotnet CLI初期化
   └─ InitializeDotNetCliでdotnetパスを取得
8. 既存インストール確認
   └─ dotnet tool listで既存のDarcを確認
9. 既存インストールのアンインストール
   └─ 既存があればdotnet tool uninstallで削除
10. Darcインストール
    └─ dotnet tool installでインストール実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C[引数解析]
    C --> D{不明な引数?}
    D -->|はい| E[エラー出力して終了]
    D -->|いいえ| F[シンボリックリンク解決]
    F --> G[tools.sh読み込み]
    G --> H{バージョン指定?}
    H -->|いいえ| I[curlでバージョン取得]
    H -->|はい| J[指定バージョン使用]
    I --> K[InstallDarcCli呼び出し]
    J --> K
    K --> L[dotnet CLI初期化]
    L --> M{toolpath指定?}
    M -->|いいえ| N[dotnet tool list -g]
    M -->|はい| O[dotnet tool list --tool-path]
    N --> P{darc既存?}
    O --> P
    P -->|はい| Q[dotnet tool uninstall]
    P -->|いいえ| R[dotnet tool install]
    Q --> R
    R --> S[正常終了]
    S --> T[バッチ終了]
    E --> T
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 不明な引数 | 認識できない引数が渡された | 正しい引数を指定する |
| 非0 | API接続失敗 | Maestro APIへのcurl失敗 | ネットワーク接続確認、--darcversionで明示的にバージョン指定 |
| 非0 | パッケージ取得失敗 | Azure DevOpsフィードへの接続失敗 | ネットワーク接続確認 |
| 非0 | インストール失敗 | dotnet tool installの失敗 | エラーメッセージ確認、権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

エラーメッセージを出力して終了。明確なエラーハンドリング（try-catch相当）は実装されていない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1（単一ツールのインストール） |
| 目標処理時間 | 1分以内（ネットワーク状況依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定していないが、同一toolpathへの並行インストールは避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | インストール開始時 | "Installing Darc CLI version {version}..." |
| 進捗ログ | コマンド実行時 | 実行されるdotnet toolコマンドの出力 |
| 終了ログ | インストール完了時 | dotnet tool installの出力 |
| エラーログ | 不明引数時 | "Invalid argument: {arg}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 標準エラー出力 |

## 備考

- PowerShell版（darc-init.ps1）とペアで提供されており、Windows環境ではPowerShell版を使用する
- パッケージ名は「microsoft.dotnet.darc」
- NuGetフィードは「https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-eng/nuget/v3/index.json」
- 初めてdotnetツールをインストールする場合、コマンドシェルの再起動が必要になる場合がある
- 引数は大文字小文字を区別せずに解析される（toLowerで変換）
- tools.shのGetDarc関数からも呼び出される
