# バッチ設計書 49-generate-sbom-prep.sh

## 概要

本ドキュメントは、SBOM（Software Bill of Materials）生成準備スクリプト（Bash版）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Unix/Linux環境でSBOM生成のための準備処理を行うBashスクリプトである。SBOMを格納するディレクトリを作成し、Azure Pipelinesで使用するアーティファクト名を設定する。

**業務上の目的・背景**：SBOMはソフトウェアに含まれるコンポーネントのリストであり、セキュリティやコンプライアンスの観点から重要な成果物である。Azure Pipelinesの1ESテンプレートと連携してSBOMを生成する際、テンプレートによる上書きを避けるためにサブディレクトリを作成する必要がある。本スクリプトはUnix/Linux環境でその準備処理を担当する。

**バッチの実行タイミング**：CI/CDパイプラインでビルド成果物の公開前、SBOM生成ステップの前に実行される。macOSやLinuxのAzure Pipelinesビルドパイプラインで使用される。

**主要な処理内容**：
1. ステージ名とジョブ名からアーティファクト名を生成
2. アーティファクト名から特殊文字を除去してセーフな名前に変換
3. マニフェストディレクトリ配下にSBOM用サブディレクトリを作成
4. 環境変数ARTIFACT_NAMEをエクスポート
5. Azure Pipelines変数を設定

**前後の処理との関連**：本スクリプトは1ESテンプレートのSBOM生成ステップと連携する。作成されたディレクトリにSBOMマニフェストが生成され、パイプラインアーティファクトとしてアップロードされる。

**影響範囲**：指定されたマニフェストディレクトリ配下にサブディレクトリが作成される。環境変数ARTIFACT_NAMEが設定される。

## バッチ種別

SBOM / ビルド成果物管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（パイプライン実行時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | Azure Pipelinesタスク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル環境 | Bash互換のシェル環境が利用可能であること |
| Azure Pipelines環境 | SYSTEM_STAGENAME、AGENT_JOBNAME環境変数が設定されていること |
| マニフェストディレクトリ | 第1引数で指定されたパスが有効であること |

### 実行可否判定

第1引数（マニフェストディレクトリパス）は必須。ディレクトリが既に存在する場合はエラーメッセージを出力する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | - | SBOMマニフェストを配置するベースディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 SYSTEM_STAGENAME | string | Azure Pipelinesのステージ名 |
| 環境変数 AGENT_JOBNAME | string | Azure Pipelinesのジョブ名 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {manifest_dir}/{safe_artifact_name} | ディレクトリ | SBOM格納用ディレクトリ |
| 環境変数 ARTIFACT_NAME | 環境変数 | セーフなアーティファクト名（export） |
| Azure Pipelines変数 ARTIFACT_NAME | 環境変数 | ##vso出力で設定 |
| 標準出力 | テキスト | 処理状況のログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | {ステージ名}_{ジョブ名}_SBOM（特殊文字は_に置換） |
| 出力先 | 第1引数で指定されたディレクトリ配下 |
| 文字コード | N/A（ディレクトリ） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. シンボリックリンク解決
   └─ スクリプトパスのシンボリックリンクを解決
2. pipeline-logging-functions.sh読み込み
   └─ ログ出力関数をソース
3. アーティファクト名生成
   └─ SYSTEM_STAGENAME + "_" + AGENT_JOBNAME + "_SBOM"
4. セーフ名変換
   └─ 特殊文字（"/:<>\\|?@*$ ）を_に置換
5. マニフェストディレクトリ取得
   └─ 第1引数から取得
6. SBOMディレクトリパス構築
   └─ manifest_dir + "/" + safe_artifact_name
7. ディレクトリ作成
   └─ ディレクトリ不存在確認後、mkdir -p実行
8. 変数エクスポート
   └─ export ARTIFACT_NAMEと##vso出力
9. 終了
   └─ exit 0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[シンボリックリンク解決]
    B --> C[pipeline-logging-functions.sh読み込み]
    C --> D[アーティファクト名生成]
    D --> E[特殊文字を_に置換]
    E --> F[SBOMディレクトリパス構築]
    F --> G{ディレクトリ存在?}
    G -->|いいえ| H[mkdir -p]
    H --> I[成功ログ出力]
    G -->|はい| J[エラーログ出力]
    I --> K[変換前後の名前出力]
    J --> K
    K --> L[export ARTIFACT_NAME]
    L --> M[##vso変数設定]
    M --> N[exit 0]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ作成失敗 | 既にSBOMディレクトリが存在 | 既存ディレクトリを確認または削除 |
| - | パス不正 | 第1引数が無効 | 正しいパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ディレクトリが既に存在する場合、Write-PipelineTelemetryErrorでエラーを報告するが、スクリプトは終了コード0で完了する（ARTIFACT_NAME変数は設定される）。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1（単一ディレクトリ作成） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

特になし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 変換ログ | 名前変換時 | "Artifact name before : {元の名前}", "Artifact name after : {変換後の名前}" |
| 成功ログ | ディレクトリ作成成功時 | "Sbom directory created. {path}" |
| エラーログ | ディレクトリ存在時 | Write-PipelineTelemetryError "Unable to create sbom folder." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー | 1件以上 | Azure Pipelines（Build category） |

## 備考

- PowerShell版（generate-sbom-prep.ps1）とペアで提供されており、Windows環境ではPowerShell版を使用する
- 1ESテンプレートとの互換性のため、指定されたマニフェストディレクトリ直下ではなくサブディレクトリを作成する
- 特殊文字の置換対象：`"/:<>\\|?@*$ `（スペースを含む。PowerShell版と若干異なる）
- Bash版ではexportでARTIFACT_NAMEを環境変数としても設定する
- スクリプトは常にexit 0で終了する
