# バッチ設計書 5-eng/cibuild.sh

## 概要

本ドキュメントは、RoslynプロジェクトのCI（継続的インテグレーション）ビルド実行スクリプト「eng/cibuild.sh」の設計仕様を記載する。

### 本バッチの処理概要

eng/cibuild.shは、CI環境でのRoslynプロジェクトのビルドを実行するためのラッパースクリプトである。CI環境に最適化されたオプションセットでeng/build.shを呼び出す。

**業務上の目的・背景**：CI/CDパイプライン（Azure DevOps等）において、Roslynプロジェクトの自動ビルドを実行するための標準化されたエントリーポイントを提供する。CIビルドに必要な全てのフェーズ（リストア、ビルド、ブートストラップ、パック、公開）を一括で実行し、ビルドの再現性と信頼性を確保する。

**バッチの実行タイミング**：CI/CDパイプラインでの自動実行。コードのプッシュ、プルリクエスト作成、スケジュール実行など、CIトリガーに応じて実行される。

**主要な処理内容**：
1. 現在のコミット情報をログ出力（git show）
2. eng/build.shを以下のオプション付きで呼び出し：
   - --ci: CI環境フラグ
   - --prepareMachine: マシン準備処理
   - --restore: パッケージリストア
   - --build: ビルド実行
   - --bootstrap: ブートストラップコンパイラ使用
   - --pack: パッケージ作成
   - --publish: 成果物公開
   - --binaryLog: バイナリログ出力
3. 追加のコマンドライン引数を転送

**前後の処理との関連**：CI/CDパイプラインから直接呼び出される。eng/build.shの全ての機能を継承し、CI用の設定を追加する。

**影響範囲**：ソリューション全体のビルド成果物、NuGetパッケージ、ブートストラップコンパイラ、ビルドログ等に影響を与える。

## バッチ種別

CIビルド処理（リストア・ビルド・パッケージング・公開）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガーに応じて |
| 実行時刻 | 自動（イベント発生時） |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/CDパイプライン（プッシュ、PR、スケジュール等） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix環境 | Linux または macOS で実行可能 |
| Bash | Bashシェルが利用可能であること |
| Git | コミット情報表示のためgitが必要 |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| 実行権限 | スクリプトに実行権限が付与されていること |

### 実行可否判定

eng/build.shの実行可否判定に準ずる。追加の判定ロジックはない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string | No | なし | eng/build.shに転送される追加パラメータ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソリューション | slnf/slnx | ビルド対象（eng/build.shのデフォルト） |
| ソースコード | C#/VB | コンパイル対象のソースファイル群 |
| Gitリポジトリ | .git | コミット情報の取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/bin | DLL | コンパイル済みバイナリ |
| artifacts/packages | NuGet | 生成されたNuGetパッケージ |
| artifacts/log | binlog | バイナリログ |
| artifacts/Bootstrap | 各種 | ブートストラップコンパイラ |
| artifacts/publish | 各種 | 公開用成果物 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Build.binlog |
| 出力先 | artifacts/log |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパス解決
   └─ シンボリックリンクを解決してscriptrootを取得
2. コミット情報出力
   └─ git show --no-patch --pretty=raw HEADを実行
3. eng/build.sh呼び出し
   └─ CI用オプションセットと追加引数を渡す
4. ビルド結果を標準出力に表示
   └─ 終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[cibuild.sh開始] --> B[シンボリックリンク解決]
    B --> C[scriptrootディレクトリ特定]
    C --> D[git show でコミット情報出力]
    D --> E[eng/build.sh呼び出し]
    E --> F{CI用オプション付与}
    F --> G[--ci --prepareMachine]
    G --> H[--restore --build]
    H --> I[--bootstrap --pack]
    I --> J[--publish --binaryLog]
    J --> K[追加引数を転送]
    K --> L[ビルド実行]
    L --> M[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | gitエラー | git showの失敗 | Gitリポジトリを確認 |
| 非0 | ビルドエラー | コンパイルエラー | エラーメッセージに従い修正 |
| 非0 | パッケージエラー | パッケージ作成失敗 | 依存関係を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし（CI/CD側で制御） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. CI/CDパイプラインのログを確認
2. artifacts/log配下のバイナリログを確認
3. git showの出力でビルド対象コミットを確認
4. エラー内容に応じてソースコードまたは環境を修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ソリューション全体 |
| 目標処理時間 | 環境依存（通常20-40分） |
| メモリ使用量上限 | 環境依存（CI環境の制限による） |

## 排他制御

CI/CD環境での排他制御はパイプライン側で管理される。同一エージェントでの複数ビルド同時実行は避けるべき。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 開始時 | ビルド対象コミット情報 |
| 標準出力 | ビルド中 | MSBuildの進捗 |
| バイナリログ | 常時 | 詳細なビルドログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDパイプライン通知 |
| ビルド時間 | 環境依存 | CI/CDパイプライン監視 |

## 備考

- 本スクリプトはCI環境専用のエントリーポイント
- --ciオプションによりCI固有の動作（プレビューSDK有効化等）が有効になる
- --prepareMachineによりマシン状態のクリーンアップが行われる
- --bootstrapにより自己ビルドコンパイラの検証が行われる
- --binaryLogは常に有効でデバッグ情報を保持
- 開発者のローカルビルドにはbuild.shを使用すること
