# バッチ設計書 50-sdl.ps1

## 概要

本ドキュメントは、SDL（Security Development Lifecycle）共通スクリプトの設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Microsoft Guardianセキュリティツールをインストールするための共通関数を提供するPowerShellスクリプトである。SDLツールはセキュリティスキャンや脆弱性検出を行うためのツールセットである。

**業務上の目的・背景**：Microsoftのセキュリティ開発ライフサイクル（SDL）では、ビルド成果物に対するセキュリティスキャンが要求される。Guardianはそのためのツールスイートであり、本スクリプトはGuardian CLIをNuGetからインストールする機能を提供する。CI/CDパイプラインでのセキュリティスキャン実行前に、このスクリプトでツールをセットアップする。

**バッチの実行タイミング**：SDLセキュリティスキャンを実行する前に、他のSDLスクリプト（run-sdl.ps1、execute-all-sdl-tools.ps1等）から呼び出される。CI/CDパイプラインのセキュリティ検証ステップで使用される。

**主要な処理内容**：
1. Install-Gdn関数を定義
2. NuGetを使用してMicrosoft.Guardian.CliパッケージをインストールPath引数で指定されたディレクトリにインストール
3. オプションでバージョンを指定可能
4. インストールされたguardian.cmdのパスを返却

**前後の処理との関連**：本スクリプトはtools.ps1に依存しており、共通関数を使用する。Install-Gdn関数は他のSDLスクリプト（run-sdl.ps1等）から呼び出されてGuardianツールをセットアップする。

**影響範囲**：指定されたPathディレクトリにMicrosoft.Guardian.Cliパッケージがインストールされる。

## バッチ種別

SDL / セキュリティツール管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SDLスキャン前） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 他のSDLスクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | PowerShell 5.1以降またはPowerShell Coreが利用可能であること |
| tools.ps1の存在 | ../tools.ps1が存在すること |
| NuGet CLI | nugetコマンドが利用可能であること |
| ネットワーク接続 | セキュリティツールNuGetフィード（securitytools.pkgs.visualstudio.com）へのアクセスが可能であること |

### 実行可否判定

-Path引数は必須。インストール後にguardian.cmdが見つからない場合はエラーを報告する。

## 入力仕様

### 入力パラメータ（Install-Gdn関数）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -Path | string | Yes | - | Guardianパッケージのインストール先ディレクトリ |
| -Version | string | No | 未指定（最新版） | インストールするGuardianのバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet Feed | NuGet | Microsoft.Guardian.Cliパッケージの取得元 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {Path}/Microsoft.Guardian.Cli.{Version} | ディレクトリ | Guardianパッケージ |
| 戻り値 | string | guardian.cmdのフルパス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | guardian.cmd |
| 出力先 | {Path}/Microsoft.Guardian.Cli.{Version}/tools/ |
| 文字コード | N/A |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Install-Gdn関数定義
   └─ パラメータ（Path、Version）を定義
2. 変数初期化
   └─ ErrorActionPreference、StrictMode、ci=$true設定
3. tools.ps1読み込み
   └─ 共通ユーティリティ関数をドットソース
4. NuGetコマンド構築
   └─ install Microsoft.Guardian.Cli、OutputDirectory、NonInteractive、NoCache
5. バージョン指定
   └─ Versionが指定されていれば-Versionオプション追加
6. NuGet実行
   └─ Start-Processでnugetを実行
7. guardian.cmd検索
   └─ Get-ChildItemで再帰的に検索
8. 結果返却
   └─ 見つかればパスを返却、見つからなければエラー
```

### フローチャート

```mermaid
flowchart TD
    A[Install-Gdn呼び出し] --> B[変数初期化]
    B --> C[tools.ps1読み込み]
    C --> D[NuGet引数リスト構築]
    D --> E{Version指定?}
    E -->|はい| F[-Version追加]
    E -->|いいえ| G[Start-Process nuget]
    F --> G
    G --> H[guardian.cmd検索]
    H --> I{見つかった?}
    I -->|はい| J[パスを返却]
    I -->|いいえ| K[Write-PipelineTelemetryError]
    J --> L[関数終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | インストール失敗 | guardian.cmdが見つからない | ネットワーク接続確認、NuGetフィードへのアクセス確認 |
| - | NuGet失敗 | NuGetコマンドの実行失敗 | NuGet CLIのインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

guardian.cmdが見つからない場合、Write-PipelineTelemetryErrorでエラーを報告（Sdlカテゴリ）。戻り値は$nullまたは空となる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1（単一パッケージインストール） |
| 目標処理時間 | ネットワーク状況依存（通常1〜3分） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定していないが、同一Pathへの並行インストールは避けるべきである。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | NuGet実行時 | NuGetの出力（Verboseモード） |
| エラーログ | インストール失敗時 | Write-PipelineTelemetryError "Failure installing Guardian" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー | 1件以上 | Azure Pipelines（Sdl category） |

## 備考

- 本スクリプトはInstall-Gdn関数のみを定義し、直接実行はしない
- NuGetフィードは「https://securitytools.pkgs.visualstudio.com/_packaging/Guardian/nuget/v3/index.json」
- ciフラグは関数内で$trueに設定される
- disableConfigureToolsetImportを$trueに設定してtools.ps1の自動設定インポートを無効化
- Start-Processは-NoNewWindow -Waitオプションで同期実行
- guardian.cmdは再帰的に検索され、最初に見つかったものが返される
