# バッチ設計書 51-run-sdl.ps1

## 概要

本ドキュメントは、Microsoft Guardian CLIを使用してSDL（Security Development Lifecycle）セキュリティツールを実行するPowerShellスクリプト `eng/common/sdl/run-sdl.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、事前に構成されたGuardian設定ファイルを使用してSDLセキュリティスキャンを実行し、コードベースの脆弱性や潜在的なセキュリティ問題を検出します。

**業務上の目的・背景**：ソフトウェア開発において、セキュリティは最優先事項の一つです。本バッチは、Microsoft SDL（Security Development Lifecycle）の一環として、コードやビルド成果物に対してセキュリティスキャンを自動的に実行することで、脆弱性を早期に発見し、セキュリティリスクを低減します。Guardian CLIはMicrosoftが提供するセキュリティツールのオーケストレーターであり、複数のセキュリティツールを統合的に管理・実行します。

**バッチの実行タイミング**：CIパイプラインの一部として、ビルドおよびテスト完了後に実行されます。通常は `execute-all-sdl-tools.ps1` から呼び出されます。

**主要な処理内容**：
1. tools.ps1の読み込みによる共通ユーティリティの初期化
2. Guardian CLIの有効性検証
3. .gdnフォルダ内の設定ファイル（*.gdnconfig）の検出
4. Guardian CLIの`run`コマンドによるセキュリティスキャンの実行
5. ベースライン更新オプションに基づく結果処理

**前後の処理との関連**：本スクリプトは `init-sdl.ps1`（SDL初期化）および `configure-sdl-tool.ps1`（ツール設定）の後に実行されます。`execute-all-sdl-tools.ps1` がこれらのスクリプトをオーケストレーションします。

**影響範囲**：ソースコードディレクトリおよびビルド成果物ディレクトリに対してセキュリティスキャンを実行し、検出結果を.gdnフォルダに出力します。ビルドの成否判定やTSA（Test Security Analysis）への結果公開に影響します。

## バッチ種別

セキュリティスキャン / SDL検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | execute-all-sdl-tools.ps1からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | Guardian CLIが指定されたパスに存在すること |
| .gdnフォルダ | init-sdl.ps1により初期化された.gdnフォルダが存在すること |
| 設定ファイル | configure-sdl-tool.ps1により生成された*.gdnconfigファイルが存在すること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |

### 実行可否判定

Guardian CLIのパスが有効かどうかを`Test-Path`で検証し、無効な場合は即座にエラー終了します。設定ファイルが存在しない場合でも実行は継続されますが、スキャン結果は空になります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianCliLocation | string | Yes | - | Guardian CLI実行ファイルのフルパス |
| WorkingDirectory | string | Yes | - | スキャン対象の作業ディレクトリ |
| GdnFolder | string | Yes | - | .gdnフォルダのパス |
| UpdateBaseline | string | Yes | - | ベースラインを更新するかどうか |
| GuardianLoggerLevel | string | No | 'Standard' | ログ出力レベル（Trace/Verbose/Standard/Warning/Error） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.gdnconfig | GDNConfig | .gdn/rディレクトリ内のGuardian設定ファイル |
| mainbaseline | Baseline | Guardian ベースライン設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .gdnフォルダ | Guardian Results | セキュリティスキャン結果 |
| 標準出力 | Text | 実行ログおよびスキャン結果サマリー |
| パイプラインログ | Telemetry | エラー発生時のテレメトリ情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Guardian管理のスキャン結果ファイル |
| 出力先 | .gdnフォルダ内 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
2. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
3. 設定ファイルパスの構築
   └─ $GdnFolder/r ディレクトリパスを生成
4. Guardian CLIパスの検証
   └─ Test-Pathで存在確認、無効ならエラー終了
5. 設定ファイルの検出
   └─ *.gdnconfigファイルを再帰的に検索
6. 検出ファイルの表示
   └─ 発見した設定ファイル一覧をログ出力
7. Guardian CLIのrun実行
   └─ 全設定ファイルを指定してセキュリティスキャン実行
8. 終了処理
   └─ 正常終了またはエラーハンドリング
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[設定パス構築]
    C --> D{Guardian CLI存在確認}
    D -->|存在しない| E[エラー出力]
    E --> F[終了コード1で終了]
    D -->|存在する| G[*.gdnconfig検索]
    G --> H[設定ファイル一覧表示]
    H --> I[Guardian run実行]
    I --> J{実行成功?}
    J -->|成功| K[正常終了]
    J -->|失敗| L[エラーハンドリング]
    L --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Guardian CLI無効 | 指定パスにGuardian CLIが存在しない | 正しいGuardianCliLocationを指定 |
| 1 | スキャン失敗 | Guardian runコマンドが非ゼロ終了 | スキャン結果を確認し、検出問題を修正 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認し問題を特定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログでスタックトレースを確認
2. Guardian CLIのパスが正しいか確認
3. .gdnフォルダと設定ファイルが正しく生成されているか確認
4. init-sdl.ps1およびconfigure-sdl-tool.ps1が正常に完了しているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コードベースサイズに依存 |
| 目標処理時間 | 設定されたツールおよびスキャン対象により異なる |
| メモリ使用量上限 | Guardian CLIの内部設定に依存 |

## 排他制御

同一作業ディレクトリに対して複数のGuardian実行を同時に行うことは推奨されません。CIパイプラインでは通常、シーケンシャルに実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 設定ファイル一覧 | スキャン前 | 検出された*.gdnconfigファイルのパス |
| Guardian実行ログ | スキャン中 | Guardian CLIの詳細ログ（レベルに依存） |
| エラーログ | エラー発生時 | スタックトレースとエラーメッセージ |
| テレメトリ | エラー発生時 | パイプラインテレメトリエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |
| セキュリティ検出 | 設定による | TSA（有効な場合） |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- GuardianLoggerLevelは'Trace'、'Verbose'、'Standard'、'Warning'、'Error'から選択可能です
- ベースライン機能により、既知の問題を除外してスキャン結果を管理できます
- 詳細なGuardian設定については、Azure DevOps Security Integration Wikiを参照してください
