# バッチ設計書 52-init-sdl.ps1

## 概要

本ドキュメントは、Microsoft Guardian CLIを初期化し、SDLセキュリティスキャン環境を準備するPowerShellスクリプト `eng/common/sdl/init-sdl.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、Guardian CLIの初期化コマンドを実行し、.gdnフォルダとベースライン設定を作成することで、SDLセキュリティスキャンの実行環境を準備します。

**業務上の目的・背景**：SDLセキュリティスキャンを実行するためには、Guardian CLIの作業環境を事前に初期化する必要があります。本バッチは、リポジトリごとに必要な.gdnフォルダ構造を作成し、セキュリティスキャン結果のベースラインを設定することで、継続的なセキュリティ監視を可能にします。ベースライン機能により、既知の問題と新規発見の問題を区別でき、効率的なセキュリティレビューが可能になります。

**バッチの実行タイミング**：CIパイプラインにおいて、SDLセキュリティスキャン（run-sdl.ps1）の前に実行されます。通常は `execute-all-sdl-tools.ps1` から呼び出されます。

**主要な処理内容**：
1. tools.ps1の読み込みによる共通ユーティリティの初期化
2. Azure DevOpsアクセストークンを使用した認証情報の構築
3. Guardian CLIのinitコマンドによる作業環境の初期化
4. mainbaselineという名前のベースラインの作成

**前後の処理との関連**：本スクリプトはSDLスキャン処理の最初に実行され、後続の `configure-sdl-tool.ps1`（ツール設定）および `run-sdl.ps1`（スキャン実行）の前提条件となります。

**影響範囲**：作業ディレクトリに.gdnフォルダを作成し、Guardian CLIの設定とベースライン情報を格納します。Azure DevOpsリポジトリsdl-tool-cfgとの連携を想定しています。

## バッチ種別

初期化処理 / SDL環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中（スキャン前） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | execute-all-sdl-tools.ps1からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | Guardian CLIが指定されたパスに存在すること |
| Azure DevOpsアクセストークン | dncengプロジェクトへのアクセス権限を持つPATが提供されること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |
| 作業ディレクトリ | 有効な書き込み可能なディレクトリが指定されること |

### 実行可否判定

Guardian CLIの初期化が必要な場合に実行されます。既存の.gdnフォルダがある場合でも、新たな初期化を実行します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianCliLocation | string | Yes | - | Guardian CLI実行ファイルのフルパス |
| Repository | string | Yes | - | リポジトリ名（例：dotnet/roslyn） |
| BranchName | string | No | 'master' | ブランチ名またはGDN設定バージョン |
| WorkingDirectory | string | Yes | - | 作業ディレクトリのパス |
| AzureDevOpsAccessToken | string | Yes | - | Azure DevOps PAT |
| GuardianLoggerLevel | string | No | 'Standard' | ログ出力レベル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| sdl-tool-cfg リポジトリ | Git/ZIP | Azure DevOps dnceng/internalプロジェクトのGDN設定リポジトリ（参照用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .gdnフォルダ | Directory | Guardian作業フォルダ |
| mainbaseline | Baseline | ベースライン設定ファイル |
| 標準出力 | Text | 実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | .gdnフォルダ内の各種設定ファイル |
| 出力先 | $WorkingDirectory/.gdn |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
2. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
3. プログレス表示の無効化
   └─ ProgressPreference='SilentlyContinue'でパフォーマンス向上
4. 認証情報の構築
   └─ Azure DevOps PATをBase64エンコード
5. URIの構築
   └─ sdl-tool-cfgリポジトリへのアクセスURI生成
6. Guardian CLI initの実行
   └─ 作業ディレクトリの初期化
7. ベースライン作成
   └─ mainbaselineという名前でベースラインを作成
8. 終了処理
   └─ 正常終了またはエラーハンドリング
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[認証情報構築]
    C --> D[Guardian init実行]
    D --> E{init成功?}
    E -->|失敗| F[エラー出力]
    F --> G[終了コード付きで終了]
    E -->|成功| H[Guardian baseline実行]
    H --> I{baseline成功?}
    I -->|失敗| F
    I -->|成功| J[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| LASTEXITCODE | Guardian init失敗 | Guardian initコマンドが非ゼロ終了 | Guardian CLIとパラメータを確認 |
| LASTEXITCODE | Baseline作成失敗 | Guardian baselineコマンドが非ゼロ終了 | 初期化状態を確認 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログでスタックトレースを確認
2. Guardian CLIのパスが正しいか確認
3. Azure DevOpsアクセストークンが有効か確認
4. 作業ディレクトリへの書き込み権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の初期化処理 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | Guardian CLIの内部設定に依存 |

## 排他制御

同一作業ディレクトリに対して複数の初期化処理を同時に実行することは推奨されません。CIパイプラインでは通常、シーケンシャルに実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 初期化ログ | init実行時 | Guardian CLI initコマンドとパラメータ |
| ベースラインログ | baseline実行時 | Guardian CLI baselineコマンドとパラメータ |
| エラーログ | エラー発生時 | スタックトレースとエラーメッセージ |
| テレメトリ | エラー発生時 | パイプラインテレメトリエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- Azure DevOps dnceng/internalプロジェクトのsdl-tool-cfgリポジトリに格納された設定を参照可能です
- ProgressPreferenceを'SilentlyContinue'に設定することで、PowerShellのプログレスバー表示を無効化し、パフォーマンスを向上させています
- コード内にsdl-tool-cfgからの設定ダウンロード用URIが構築されていますが、現在の実装ではinit/baselineコマンドのみ実行されています
