# バッチ設計書 53-execute-all-sdl-tools.ps1

## 概要

本ドキュメントは、全てのSDL（Security Development Lifecycle）セキュリティツールを一括実行するオーケストレーションスクリプト `eng/common/sdl/execute-all-sdl-tools.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、SDLセキュリティスキャンの全プロセス（初期化、ツール設定、スキャン実行、結果公開）をオーケストレーションし、複数のセキュリティツール（CredScan、PoliCheck、CodeQL、Binskim等）を統合的に実行します。

**業務上の目的・背景**：大規模なソフトウェアプロジェクトでは、複数のセキュリティツールを組み合わせて包括的なセキュリティ検証を行う必要があります。本バッチは、Guardian CLIをベースとしたSDLセキュリティスキャンの全工程を自動化することで、CIパイプラインに統合されたセキュリティ検証を実現します。TSA（Test Security Analysis）への自動バグ登録機能により、発見されたセキュリティ問題を効率的に追跡・管理できます。

**バッチの実行タイミング**：CIパイプラインの一部として、ビルドおよびテスト完了後に実行されます。通常は専用のSDL検証ステージで実行されます。

**主要な処理内容**：
1. Guardian CLI環境の初期化（init-sdl.ps1呼び出し）
2. TSAオンボーディング（初回のみ、TsaOnboard=trueの場合）
3. ソースコード向けツールの設定（SourceToolsList）
4. ビルド成果物向けツールの設定（ArtifactToolsList）
5. カスタムツールの設定（CustomToolsList）
6. 全ツールの一括実行（run-sdl.ps1呼び出し）
7. TSAへの結果公開（TsaPublish=trueの場合）
8. 失敗時のビルドブレーク（BreakOnFailure=trueの場合）

**前後の処理との関連**：本スクリプトは `init-sdl.ps1`、`configure-sdl-tool.ps1`、`run-sdl.ps1` を内部で呼び出すメインのエントリポイントです。CIパイプラインから直接呼び出されることを想定しています。

**影響範囲**：ソースコードディレクトリ、ビルド成果物ディレクトリに対してセキュリティスキャンを実行します。TSA連携時はAzure DevOpsにバグが自動登録されます。

## バッチ種別

セキュリティスキャン / SDL検証オーケストレーション

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中（ビルド・テスト後） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | Azure DevOpsパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | GuardianPackageName+NugetPackageDirectory または GuardianCliLocation が指定されること |
| Azure DevOpsアクセストークン | dncengプロジェクトへのアクセス権限を持つPATが提供されること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |
| ソースディレクトリ | BUILD_SOURCESDIRECTORYまたは明示的指定 |
| 成果物ディレクトリ | BUILD_ARTIFACTSSTAGINGDIRECTORYまたは明示的指定 |

### 実行可否判定

Guardian CLIパスの有効性を検証し、無効な場合はエラー終了します。TSA関連操作は必要なパラメータが全て指定されている場合のみ実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianPackageName | string | Cond | - | Guardian CLIパッケージ名 |
| NugetPackageDirectory | string | Cond | - | NuGetパッケージディレクトリ |
| GuardianCliLocation | string | Cond | - | Guardian CLI直接パス |
| Repository | string | No | $env:BUILD_REPOSITORY_NAME | リポジトリ名 |
| BranchName | string | No | $env:BUILD_SOURCEBRANCH | ブランチ名 |
| SourceDirectory | string | No | $env:BUILD_SOURCESDIRECTORY | ソースコードディレクトリ |
| ArtifactsDirectory | string | No | artifacts配下 | 成果物ディレクトリ |
| AzureDevOpsAccessToken | string | Yes | - | Azure DevOps PAT |
| SourceToolsList | object[] | No | - | ソース向けツールリスト |
| ArtifactToolsList | object[] | No | - | 成果物向けツールリスト |
| CustomToolsList | object[] | No | - | カスタムツールリスト |
| TsaPublish | bool | No | $False | TSA公開有無 |
| TsaBranchName | string | No | $env:BUILD_SOURCEBRANCH | TSAブランチ名 |
| TsaRepositoryName | string | No | 自動生成 | TSAリポジトリ名 |
| BuildNumber | string | No | $env:BUILD_BUILDNUMBER | ビルド番号 |
| UpdateBaseline | bool | No | $False | ベースライン更新有無 |
| TsaOnboard | bool | No | $False | TSAオンボード有無 |
| TsaInstanceUrl | string | Cond | - | TSAインスタンスURL |
| TsaCodebaseName | string | Cond | - | TSAコードベース名 |
| TsaProjectName | string | Cond | - | TSAプロジェクト名 |
| TsaNotificationEmail | string | Cond | - | TSA通知メール |
| TsaCodebaseAdmin | string | Cond | - | TSAコードベース管理者 |
| TsaBugAreaPath | string | Cond | - | TSAバグエリアパス |
| TsaIterationPath | string | Cond | - | TSAイテレーションパス |
| GuardianLoggerLevel | string | No | 'Standard' | ログレベル |
| CrScanAdditionalRunConfigParams | string[] | No | - | CredScan追加パラメータ |
| PoliCheckAdditionalRunConfigParams | string[] | No | - | PoliCheck追加パラメータ |
| CodeQLAdditionalRunConfigParams | string[] | No | - | CodeQL追加パラメータ |
| BinskimAdditionalRunConfigParams | string[] | No | - | Binskim追加パラメータ |
| BreakOnFailure | bool | No | $False | 失敗時ビルドブレーク |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | Directory | スキャン対象のソースコードディレクトリ |
| ビルド成果物 | Directory | スキャン対象の成果物ディレクトリ |
| 環境変数 | String | Azure DevOpsビルド環境変数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .gdnフォルダ | Directory | Guardian作業フォルダとスキャン結果 |
| TSA | Bug | セキュリティ問題のバグ登録（有効時） |
| 標準出力 | Text | 実行ログ |
| パイプラインログ | Telemetry | エラー情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Guardian管理のスキャン結果ファイル |
| 出力先 | .gdnフォルダ内 |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
2. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
3. リポジトリ名の正規化
   └─ org/repo形式への変換
4. Guardian CLIパスの解決
   └─ パッケージ名から、または直接指定から
5. Guardian CLIの検証
   └─ Test-Pathで存在確認
6. SDL初期化（init-sdl.ps1）
   └─ .gdnフォルダとベースラインの作成
7. TSAオンボーディング（オプション）
   └─ TsaOnboard=trueの場合のみ
8. ツール設定
   └─ ArtifactToolsList、SourceToolsList、CustomToolsListの順に設定
9. スキャン実行（run-sdl.ps1）
   └─ 全設定済みツールの一括実行
10. TSA公開（オプション）
    └─ TsaPublish=trueの場合のみ
11. ビルドブレーク判定（オプション）
    └─ BreakOnFailure=trueの場合のみ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[リポジトリ名正規化]
    C --> D[Guardian CLIパス解決]
    D --> E{CLI存在確認}
    E -->|存在しない| F[エラー終了]
    E -->|存在する| G[init-sdl.ps1実行]
    G --> H{TsaOnboard?}
    H -->|Yes| I[TSAオンボーディング]
    H -->|No| J[ツール設定]
    I --> J
    J --> K[ArtifactToolsList設定]
    K --> L[SourceToolsList設定]
    L --> M[CustomToolsList設定]
    M --> N[run-sdl.ps1実行]
    N --> O{TsaPublish?}
    O -->|Yes| P[TSA公開]
    O -->|No| Q{BreakOnFailure?}
    P --> Q
    Q -->|Yes| R[guardian break実行]
    Q -->|No| S[正常終了]
    R --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接使用しませんが、TSA連携時はAzure DevOpsにバグを登録します。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| TSA公開 | Azure DevOps Work Items | INSERT | セキュリティバグの登録 |

### テーブル別操作詳細

該当なし（外部サービス連携）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Guardian CLI無効 | 指定パスにGuardian CLIが存在しない | 正しいパスを指定 |
| LASTEXITCODE | TSAオンボード失敗 | TSAオンボーディングコマンドが非ゼロ終了 | TSA設定を確認 |
| LASTEXITCODE | TSA公開失敗 | TSA公開コマンドが非ゼロ終了 | TSA設定を確認 |
| 1 | TSAパラメータ不足 | TSA操作に必要なパラメータが不足 | 必要なパラメータを指定 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログでスタックトレースを確認
2. Guardian CLIのパスが正しいか確認
3. Azure DevOpsアクセストークンが有効か確認
4. TSA関連パラメータが正しく設定されているか確認
5. 各サブスクリプト（init-sdl.ps1、configure-sdl-tool.ps1、run-sdl.ps1）のログを個別確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作・API呼び出し） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 設定されたツール数に依存 |
| 目標処理時間 | コードベースサイズとツール数により数分〜数時間 |
| メモリ使用量上限 | Guardian CLIおよび各ツールの設定に依存 |

## 排他制御

同一作業ディレクトリに対して複数のSDL実行を同時に行うことは推奨されません。CIパイプラインでは通常、専用のジョブで実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各フェーズ開始時 | 実行コマンドとパラメータ |
| 進捗ログ | 処理中 | 各ツールの設定・実行状況 |
| 終了ログ | 各フェーズ終了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | スタックトレースとエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |
| セキュリティ検出 | 設定による | TSA（有効な場合） |
| 実行時間 | パイプラインタイムアウト | Azure DevOps |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- TSA（Test Security Analysis）はMicrosoftの自動バグ登録フレームワークです
- 対応セキュリティツール：CredScan、PoliCheck、CodeQL（Semmle）、Binskim等
- ツールリストは配列形式で指定し、各要素はツール名の文字列またはName/Scenario/Argsを持つハッシュテーブルです
- BreakOnFailure=trueの場合、セキュリティ問題が検出されるとビルドが失敗します
