# バッチ設計書 54-configure-sdl-tool.ps1

## 概要

本ドキュメントは、Guardian CLIを使用してSDLセキュリティツールの設定ファイルを生成するPowerShellスクリプト `eng/common/sdl/configure-sdl-tool.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、指定されたセキュリティツールリストに基づいてGuardian設定ファイル（*.gdnconfig）を生成し、各ツール固有のパラメータを適用します。

**業務上の目的・背景**：SDLセキュリティスキャンでは、複数のセキュリティツール（CredScan、PoliCheck、CodeQL、Binskim等）を統合的に実行する必要があります。各ツールは異なる設定パラメータを持ち、スキャン対象ディレクトリや出力形式などを個別に指定する必要があります。本バッチは、Guardian CLIの`configure`コマンドを使用して、これらのツール固有の設定ファイルを自動生成することで、一貫した設定管理と再現性のあるセキュリティスキャンを実現します。

**バッチの実行タイミング**：CIパイプラインにおいて、SDL初期化（init-sdl.ps1）の後、スキャン実行（run-sdl.ps1）の前に実行されます。通常は `execute-all-sdl-tools.ps1` から呼び出されます。

**主要な処理内容**：
1. tools.ps1の読み込みによる共通ユーティリティの初期化
2. ツールリストの正規化（文字列形式からハッシュテーブル形式への変換）
3. Guardian CLIパスの検証
4. 各ツールに対する設定ファイルの生成
5. ツール固有のデフォルト引数の適用（CredScan、PoliCheck、CodeQL、Binskim）

**前後の処理との関連**：本スクリプトは `init-sdl.ps1`（SDL初期化）の後に実行され、後続の `run-sdl.ps1`（スキャン実行）で使用される設定ファイルを生成します。

**影響範囲**：.gdn/rディレクトリに各ツールの設定ファイル（*.gdnconfig）を出力します。

## バッチ種別

設定生成 / SDLツール構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中（スキャン前） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | execute-all-sdl-tools.ps1からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | Guardian CLIが指定されたパスに存在すること |
| .gdnフォルダ | init-sdl.ps1により初期化された.gdnフォルダが存在すること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |

### 実行可否判定

Guardian CLIのパスが有効かどうかを`Test-Path`で検証し、無効な場合は即座にエラー終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianCliLocation | string | Yes | - | Guardian CLI実行ファイルのフルパス |
| WorkingDirectory | string | Yes | - | 作業ディレクトリ |
| TargetDirectory | string | No | - | スキャン対象ディレクトリ |
| GdnFolder | string | Yes | - | .gdnフォルダのパス |
| ToolsList | object[] | Yes | - | 設定するツールのリスト |
| GuardianLoggerLevel | string | No | 'Standard' | ログ出力レベル |
| CrScanAdditionalRunConfigParams | string[] | No | - | CredScan追加パラメータ |
| PoliCheckAdditionalRunConfigParams | string[] | No | - | PoliCheck追加パラメータ |
| CodeQLAdditionalRunConfigParams | string[] | No | - | CodeQL追加パラメータ |
| BinskimAdditionalRunConfigParams | string[] | No | - | Binskim追加パラメータ |

### ToolsListの形式

ToolsListパラメータは以下の形式で指定します：

- **文字列形式**：`"credscan"` - ツール名のみ指定（Name="credscan"に変換）
- **ハッシュテーブル形式**：
  - `Name`（必須）：Guardianが認識するツール名
  - `Scenario`（任意）：設定エントリのシナリオ固有名（同名ツールの複数設定時に使用）
  - `Args`（任意）：Guardian設定引数の配列（例：`@("Target > C:\temp")`）

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ツールリスト | object[] | 設定対象のセキュリティツール情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| *.gdnconfig | GDNConfig | .gdn/rディレクトリ内のツール設定ファイル |
| 標準出力 | Text | 実行ログおよび設定ファイル情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {ToolName}[-{Scenario}]-configure.gdnconfig |
| 出力先 | $GdnFolder/r |
| 文字コード | UTF-8（Guardian管理） |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
2. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
3. ツールリストの正規化
   └─ 文字列 → ハッシュテーブル変換、Scenario/Args初期化
4. ツールリストのログ出力
   └─ 設定対象ツール一覧を表示
5. 設定パスの構築
   └─ $GdnFolder/r ディレクトリパスを生成
6. Guardian CLIパスの検証
   └─ Test-Pathで存在確認、無効ならエラー終了
7. 各ツールに対するループ処理
   ├─ ツール設定名の構築（Name + Scenario）
   ├─ ツール固有デフォルト引数の追加
   │   ├─ credscan: TargetDirectory, OutputType追加
   │   ├─ policheck: Target追加
   │   ├─ semmle/codeql: SourceCodeDirectory追加
   │   └─ binskim: Target（除外パターン付き）追加
   ├─ Guardian configureコマンドの実行
   └─ 設定ファイルパスのログ出力
8. 終了処理
   └─ 正常終了またはエラーハンドリング
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[ツールリスト正規化]
    C --> D[ツールリスト表示]
    D --> E[設定パス構築]
    E --> F{Guardian CLI存在確認}
    F -->|存在しない| G[エラー終了]
    F -->|存在する| H[ツールループ開始]
    H --> I[ツール設定名構築]
    I --> J{ツール種別判定}
    J -->|credscan| K1[CredScan引数追加]
    J -->|policheck| K2[PoliCheck引数追加]
    J -->|semmle/codeql| K3[CodeQL引数追加]
    J -->|binskim| K4[Binskim引数追加]
    J -->|その他| L[Guardian configure実行]
    K1 --> L
    K2 --> L
    K3 --> L
    K4 --> L
    L --> M{次のツール?}
    M -->|あり| I
    M -->|なし| N[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Guardian CLI無効 | 指定パスにGuardian CLIが存在しない | 正しいGuardianCliLocationを指定 |
| Sdl | 設定失敗 | Guardian configureコマンドが非ゼロ終了 | ツール名とパラメータを確認 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログでスタックトレースを確認
2. Guardian CLIのパスが正しいか確認
3. ToolsListの形式が正しいか確認
4. TargetDirectoryが存在するか確認
5. .gdnフォルダが正しく初期化されているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 設定するツール数（通常1〜10程度） |
| 目標処理時間 | ツールあたり数秒 |
| メモリ使用量上限 | Guardian CLIの内部設定に依存 |

## 排他制御

同一.gdnフォルダに対して複数の設定処理を同時に実行することは推奨されません。CIパイプラインでは通常、シーケンシャルに実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ツールリスト | 処理開始時 | 設定対象ツールの一覧 |
| 設定開始ログ | 各ツール処理開始時 | "=== Configuring {toolConfigName}..." |
| 設定完了ログ | 各ツール処理完了時 | 生成された設定ファイルのパス |
| エラーログ | エラー発生時 | スタックトレースとエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- 対応セキュリティツールとそのデフォルト引数：
  - **CredScan**：TargetDirectory、OutputType=pre
  - **PoliCheck**：Target
  - **CodeQL/Semmle**：SourceCodeDirectory
  - **Binskim**：Target（*.pdb除外パターン付き）
- Binskimは`_.pdb`ファイルでクラッシュする問題（GitHub issue #924）があるため、除外パターンが自動追加されます
- Guardian configureコマンドの詳細は Azure DevOps Security Integration Wiki を参照してください
