# バッチ設計書 55-extract-artifact-packages.ps1

## 概要

本ドキュメントは、SDLセキュリティ検査のためにNuGetパッケージ（.nupkg）から関連ファイルを展開するPowerShellスクリプト `eng/common/sdl/extract-artifact-packages.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、指定されたディレクトリ内のNuGetパッケージ（.nupkgファイル）を並列処理で展開し、セキュリティスキャン対象となるDLL、EXE、PDBファイルを抽出します。

**業務上の目的・背景**：SDLセキュリティスキャン（特にBinskimによるバイナリ解析）では、NuGetパッケージ内のバイナリファイルを直接検査する必要があります。しかし、NuGetパッケージはZIP形式でアーカイブされているため、スキャン前に内容を展開する必要があります。本バッチは、この展開処理を自動化し、関連する拡張子（.dll、.exe、.pdb）のファイルのみを効率的に抽出することで、スキャン対象を最適化します。

**バッチの実行タイミング**：CIパイプラインにおいて、SDLセキュリティスキャンの前処理として実行されます。ビルド成果物のパッケージングが完了した後に実行されます。

**主要な処理内容**：
1. tools.ps1の読み込みによる共通ユーティリティの初期化
2. 入力パスの存在確認
3. .nupkgファイルの検索
4. 各パッケージに対する並列ジョブの起動
5. ZIPとして.nupkgを開き、関連拡張子のファイルを抽出
6. 全ジョブの完了待機

**前後の処理との関連**：本スクリプトはSDLセキュリティスキャン（execute-all-sdl-tools.ps1）の前処理として使用されます。展開されたファイルはBinskimなどのバイナリ解析ツールの対象となります。

**影響範囲**：指定された展開先ディレクトリに、パッケージIDごとのサブディレクトリを作成し、抽出されたファイルを配置します。

## バッチ種別

データ展開 / SDL前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中（スキャン前） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力パス | NuGetパッケージが格納されたディレクトリが存在すること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |
| System.IO.Compression.FileSystem | .NET圧縮ライブラリが利用可能であること |

### 実行可否判定

入力パスが存在しない場合、警告を出力して正常終了（終了コード0）します。これにより、パッケージが存在しない環境でもパイプラインが継続できます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | - | NuGetパッケージが格納されたディレクトリのフルパス |
| ExtractPath | string | Yes | - | 展開先ディレクトリのフルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.nupkg | NuGetパッケージ | 展開対象のNuGetパッケージファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $ExtractPath/{PackageId}/ | Directory | パッケージごとの展開先ディレクトリ |
| *.dll | Binary | 展開されたDLLファイル |
| *.exe | Binary | 展開された実行ファイル |
| *.pdb | Binary | 展開されたデバッグシンボルファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | パッケージ内のオリジナルファイル名を保持 |
| 出力先 | $ExtractPath/{PackageId}/{OriginalPath}/ |
| 文字コード | バイナリファイルのため該当なし |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
2. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
3. 入力パス存在確認
   └─ 存在しない場合は警告出力して終了（終了コード0）
4. .nupkgファイルの検索
   └─ $InputPath\*.nupkg をGet-ChildItemで列挙
5. 並列ジョブの起動
   └─ 各パッケージに対してStart-Jobで並列処理
6. 展開処理（各ジョブ内）
   ├─ パッケージパスの存在確認
   ├─ 抽出対象拡張子の定義（.dll、.exe、.pdb）
   ├─ 展開先ディレクトリの作成
   ├─ ZipFileとしてパッケージを開く
   ├─ 対象拡張子のエントリをフィルタリング
   └─ ファイルの展開
7. ジョブ完了待機
   └─ Wait-Job + Receive-Jobで全ジョブの完了を待機
8. 実行時間の測定・出力
   └─ Measure-Commandで処理時間を計測
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C{入力パス存在確認}
    C -->|存在しない| D[警告出力]
    D --> E[終了コード0で終了]
    C -->|存在する| F[.nupkg検索]
    F --> G[並列ジョブ起動]
    G --> H[各パッケージ処理]
    H --> I[ZIPとして開く]
    I --> J[対象拡張子フィルタ]
    J --> K[ファイル展開]
    K --> L{次のエントリ?}
    L -->|あり| J
    L -->|なし| M[ジョブ完了]
    M --> N[全ジョブ待機]
    N --> O[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | 入力パス不存在 | InputPathが存在しない | 警告のみ、処理継続 |
| 1 | パッケージ不存在 | 個別パッケージファイルが存在しない | パッケージパスを確認 |
| 1 | 展開失敗 | ZIP展開でエラー発生 | パッケージの破損を確認 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログで失敗したパッケージを特定
2. パッケージファイルが破損していないか確認
3. 展開先ディレクトリへの書き込み権限を確認
4. ディスク容量が十分かを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百パッケージ |
| 目標処理時間 | パッケージ数とサイズに依存 |
| メモリ使用量上限 | 並列ジョブ数に依存 |

## 排他制御

同一出力ディレクトリに対して複数の展開処理を同時に実行することは推奨されません。並列ジョブは異なるパッケージIDのサブディレクトリに出力するため、内部的な競合は発生しません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | 入力パス不存在時 | "Input Path does not exist: {path}" |
| 進捗ログ | 各パッケージ展開開始時 | "Extracting {PackageName}..." |
| 処理時間 | 処理完了時 | Measure-Commandによる実行時間 |
| エラーログ | エラー発生時 | エラーメッセージとテレメトリ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |
| 処理時間 | パイプラインタイムアウト | Azure DevOps |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- 抽出対象拡張子は.dll、.exe、.pdbの3種類に限定されています
- 並列処理にはPowerShellのStart-Job/Wait-Jobを使用しています
- $using:変数を使用して親スコープの変数をジョブ内で参照しています
- ZIPファイルの処理にはSystem.IO.Compression.FileSystem名前空間を使用しています
- 展開先のディレクトリ構造はパッケージ内のパス構造を保持します
