# バッチ設計書 56-extract-artifact-archives.ps1

## 概要

本ドキュメントは、SDLセキュリティ検査のためにアーカイブファイル（tar.gz、zip）を展開するPowerShellスクリプト `eng/common/sdl/extract-artifact-archives.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、指定されたディレクトリ内のアーカイブファイル（.tar.gzおよび.zip）を並列処理で展開し、SDLセキュリティスキャンの対象となるファイルを抽出します。

**業務上の目的・背景**：CIビルドプロセスでは、ビルド成果物がtar.gzやzip形式でアーカイブされることがあります。特にクロスプラットフォームビルド（Linux/macOS向け）ではtar.gz形式が一般的です。SDLセキュリティスキャンを実行するためには、これらのアーカイブを展開してバイナリファイルにアクセスする必要があります。本バッチは、Windows 10/Windows Server 2019以降で標準搭載されている`tar`ユーティリティを使用して、これらのアーカイブを効率的に展開します。

**バッチの実行タイミング**：CIパイプラインにおいて、SDLセキュリティスキャンの前処理として実行されます。ビルド成果物のアーカイブが完了した後に実行されます。

**主要な処理内容**：
1. tools.ps1の読み込みによる共通ユーティリティの初期化
2. .tar.gzおよび.zipファイルの検索
3. 各アーカイブに対する並列ジョブの起動
4. tarコマンドによるアーカイブの展開
5. 全ジョブの完了待機

**前後の処理との関連**：本スクリプトはSDLセキュリティスキャン（execute-all-sdl-tools.ps1）の前処理として使用されます。extract-artifact-packages.ps1と併用して、全ての成果物を展開することができます。

**影響範囲**：指定された展開先ディレクトリに、アーカイブ名.extractedというサブディレクトリを作成し、展開されたファイルを配置します。

## バッチ種別

データ展開 / SDL前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中（スキャン前） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力パス | アーカイブファイルが格納されたディレクトリが存在すること |
| tarコマンド | Windows 10/2019以降の標準tarユーティリティが利用可能であること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |

### 実行可否判定

対象となるアーカイブファイル（.tar.gz、.zip）が存在しない場合でも、エラーなく処理を完了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | - | アーカイブファイルが格納されたディレクトリのフルパス |
| ExtractPath | string | Yes | - | 展開先ディレクトリのフルパス（InputPathと同一でも可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.tar.gz | TAR+GZIP | 非Windows向けビルド成果物のアーカイブ |
| *.zip | ZIP | Windows向けビルド成果物のアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $ExtractPath/{ArchiveName}.extracted/ | Directory | アーカイブごとの展開先ディレクトリ |
| 展開されたファイル群 | Various | アーカイブ内の全ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | アーカイブ内のオリジナルファイル名を保持 |
| 出力先 | $ExtractPath/{ArchiveName}.extracted/ |
| 文字コード | ファイル種別による |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
2. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
3. アーカイブファイルの検索
   ├─ $InputPath/*.tar.gz をGet-ChildItemで列挙
   └─ $InputPath/*.zip をGet-ChildItemで列挙
4. 並列ジョブの起動
   └─ 各アーカイブに対してStart-Jobで並列処理
5. 展開処理（各ジョブ内）
   ├─ 展開先ディレクトリの作成（.extracted サフィックス）
   ├─ tar -xf コマンドの実行
   ├─ 標準エラーを標準出力にリダイレクト（2>&1）
   └─ 終了コードのチェックとエラーハンドリング
6. ジョブ完了待機
   └─ Receive-Job -Waitで全ジョブの完了を待機
7. 実行時間の測定・出力
   └─ Measure-Commandで処理時間を計測
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[*.tar.gz検索]
    C --> D[*.zip検索]
    D --> E[アーカイブリスト作成]
    E --> F{アーカイブあり?}
    F -->|なし| G[正常終了]
    F -->|あり| H[並列ジョブ起動]
    H --> I[展開先ディレクトリ作成]
    I --> J[tar -xf実行]
    J --> K{終了コードチェック}
    K -->|成功| L[ジョブ完了]
    K -->|失敗| M[例外スロー]
    M --> N[エラー出力]
    L --> O{次のジョブ?}
    O -->|あり| I
    O -->|なし| P[全ジョブ待機]
    P --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| LASTEXITCODE | 展開失敗 | tarコマンドが非ゼロ終了 | アーカイブの破損を確認 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログで失敗したアーカイブを特定（例外メッセージに含まれる）
2. アーカイブファイルが破損していないか確認
3. 展開先ディレクトリへの書き込み権限を確認
4. tarコマンドが利用可能か確認（Windows 10/2019以降）
5. ディスク容量が十分かを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数個〜数十個のアーカイブ |
| 目標処理時間 | アーカイブ数とサイズに依存 |
| メモリ使用量上限 | 並列ジョブ数とアーカイブサイズに依存 |

## 排他制御

同一出力ディレクトリに対して複数の展開処理を同時に実行することは推奨されません。並列ジョブは異なるアーカイブ名のサブディレクトリに出力するため、内部的な競合は発生しません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各アーカイブ展開開始時 | "Extracting '{file}' to '{extractDir}'..." |
| 完了ログ | 各アーカイブ展開完了時 | "Extracted to {extractDir}" |
| 処理時間 | 処理完了時 | Measure-Commandによる実行時間 |
| エラーログ | エラー発生時 | エラーメッセージ、アーカイブパス、終了コード、tarコマンド出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |
| 処理時間 | パイプラインタイムアウト | Azure DevOps |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- Windows 10/Windows Server 2019以降で標準搭載されているtarユーティリティを使用します
- tarユーティリティはtar.gzとzipの両方をサポートしています
- 並列処理にはPowerShellのStart-Jobを使用しています
- ジョブ内でのエラーはcatchでキャッチできないため、標準エラーを標準出力にリダイレクト（2>&1）して出力を取得し、LASTEXITCODEで終了コードを確認しています
- 展開先ディレクトリ名には".extracted"サフィックスが付与されます
- extract-artifact-packages.ps1（NuGetパッケージ展開）とは異なり、全ファイルを展開します（拡張子フィルタなし）
