# バッチ設計書 57-trim-assets-version.ps1

## 概要

本ドキュメントは、SDLセキュリティ検査のためにNuGetアセットファイル名からバージョン情報を削除するPowerShellスクリプト `eng/common/sdl/trim-assets-version.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、Microsoft.DotNet.VersionTools.Cliツールを使用して、NuGetアセットファイル名に含まれるバージョン情報を削除（トリム）します。

**業務上の目的・背景**：SDLセキュリティスキャン（特にバイナリ解析）では、異なるバージョン番号を持つ同一のアセットが重複してスキャンされることがあります。これにより、スキャン時間の増加や結果の重複が発生します。本バッチは、ファイル名からバージョン情報を削除することで、SDL検査の効率化と結果の一貫性を向上させます。また、ベースラインとの比較においても、バージョン番号の差異による誤検出を防ぐことができます。

**バッチの実行タイミング**：CIパイプラインにおいて、SDLセキュリティスキャンの前処理として実行されます。アーカイブやパッケージの展開後、スキャン実行前に実行されます。

**主要な処理内容**：
1. 入力パスの存在確認
2. tools.ps1の読み込みによる共通ユーティリティの初期化
3. .NET CLIの初期化
4. Microsoft.DotNet.VersionTools.Cliツールのインストール
5. trim-assets-versionコマンドの実行

**前後の処理との関連**：本スクリプトは成果物展開（extract-artifact-packages.ps1、extract-artifact-archives.ps1）の後、SDLセキュリティスキャン（execute-all-sdl-tools.ps1）の前に実行されます。

**影響範囲**：指定されたディレクトリ内のNuGetアセットファイル名が変更されます。元のファイルは上書きまたはリネームされます。

## バッチ種別

データ整形 / SDL前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | CIビルドプロセス中（スキャン前） |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力パス | トリム対象のディレクトリが存在すること |
| .NET SDK | InitializeDotNetCliで初期化可能であること |
| NuGetフィード | dotnet-engフィードへのアクセスが可能であること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |

### 実行可否判定

入力パスが存在しない場合、エラーメッセージを出力して終了コード1で終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | - | トリム対象のディレクトリのフルパス |
| Recursive | bool | No | $true | 再帰的に処理するかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGetアセットファイル | Various | バージョン情報を含むファイル名のファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 元のディレクトリ | Various | バージョン情報が削除されたファイル名のファイル群 |
| 標準出力 | Text | 実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | バージョン番号が削除されたファイル名 |
| 出力先 | 元のディレクトリ（インプレース処理） |
| 文字コード | ファイル内容は変更されない |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. 入力パス存在確認
   └─ 存在しない場合は終了コード1で終了
2. スクリプト初期化
   └─ ErrorActionPreference='Stop'、StrictMode設定
3. tools.ps1の読み込み
   └─ CI環境変数の設定と共通関数のインポート
4. .NET CLIの初期化
   └─ InitializeDotNetCli関数で.NET SDKを準備
5. Arcade SDKバージョンの取得
   └─ Read-ArcadeSdkVersion関数でバージョン取得
6. VersionTools CLIのインストール
   └─ dotnet tool installコマンドでローカルツールとしてインストール
7. ツールインストール確認
   └─ dotnet tool listでインストールを確認
8. trim-assets-versionの実行
   └─ VersionTools CLIのtrim-assets-versionコマンドを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{入力パス存在確認}
    B -->|存在しない| C[エラー出力]
    C --> D[終了コード1で終了]
    B -->|存在する| E[tools.ps1読み込み]
    E --> F[.NET CLI初期化]
    F --> G[Arcade SDKバージョン取得]
    G --> H[VersionTools CLIインストール]
    H --> I{インストール確認}
    I -->|失敗| J[エラー出力]
    J --> D
    I -->|成功| K[trim-assets-version実行]
    K --> L{実行成功?}
    L -->|失敗| M[エラーハンドリング]
    M --> D
    L -->|成功| N[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力パス不存在 | InputPathが存在しない | 正しいパスを指定 |
| 1 | ツールインストール失敗 | dotnet tool installが失敗 | NuGetフィードへのアクセスを確認 |
| Sdl | 実行失敗 | trim-assets-versionが非ゼロ終了 | 入力ファイルの形式を確認 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログで失敗原因を特定
2. 入力パスが存在し、アクセス可能か確認
3. .NET SDKが正しく初期化されているか確認
4. dotnet-engフィードへのネットワークアクセスを確認
5. Microsoft.DotNet.VersionTools.Cliのバージョンが利用可能か確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイル数に依存 |
| 目標処理時間 | ファイル数とサイズに依存 |
| メモリ使用量上限 | VersionTools CLIの内部設定に依存 |

## 排他制御

同一ディレクトリに対して複数のトリム処理を同時に実行することは推奨されません。ファイル名の変更中に競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | 入力パス不存在時 | "Input Path '{path}' does not exist" |
| 進捗ログ | ツールインストール時 | "Installing the package '{CliToolName}' with a version of '{version}' ..." |
| 確認ログ | インストール確認時 | ツールリスト出力 |
| エラーログ | エラー発生時 | エラーメッセージとテレメトリ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- 使用するツール：Microsoft.DotNet.VersionTools.Cli
- NuGetフィード：https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-eng/nuget/v3/index.json
- ツールはローカルツール（--local）としてインストールされます
- --create-manifest-if-neededオプションにより、マニフェストファイルが存在しない場合は自動作成されます
- Arcade SDKバージョンと同じバージョンのVersionTools CLIがインストールされます
- Recursiveパラメータのデフォルト値はtrueで、サブディレクトリも再帰的に処理されます
