# バッチ設計書 58-vmr-sync.ps1

## 概要

本ドキュメントは、現在のリポジトリをローカルのVMR（Virtual Monolithic Repository）に同期するためのPowerShellスクリプト `eng/common/vmr-sync.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、Darcツールを使用して現在のリポジトリのコードをdotnet/dotnet VMRに同期し、ローカルでのSource-Build検証やテストを可能にします。

**業務上の目的・背景**：.NETエコシステムでは、複数の個別リポジトリ（dotnet/runtime、dotnet/roslyn等）のコードが最終的にVMR（Virtual Monolithic Repository、dotnet/dotnetリポジトリ）に統合されます。開発者が自分の変更がVMRに統合された際の影響を事前に確認するためには、ローカル環境でVMRへの同期をシミュレートする必要があります。本バッチは、この同期プロセスを自動化し、Source-Build検証や統合テストを容易にします。

**バッチの実行タイミング**：開発者がローカルで手動実行、またはCIパイプラインでSource-Build検証時に実行されます。

**主要な処理内容**：
1. 一時ディレクトリの準備
2. VMRリポジトリ（dotnet/dotnet）のクローンまたは更新
3. VMRの作業ツリーの状態確認
4. .NET SDKとDarcツールの初期化
5. Darcのvmr forwardflowコマンドによる同期実行

**前後の処理との関連**：本スクリプトは独立して実行可能ですが、同期後はVMRディレクトリでSource-Buildテストやその他の検証を実行することを想定しています。

**影響範囲**：指定されたVMRディレクトリに現在のリポジトリのコードが同期されます。VMRの既存の変更がある場合は警告を出力します。

## バッチ種別

リポジトリ同期 / Source-Build準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行 / CI実行時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 開発者手動実行 / CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Git | gitコマンドが利用可能であること |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |
| インターネット接続 | GitHubおよび必要に応じてAzure DevOpsへのアクセスが可能であること |

### 実行可否判定

一時ディレクトリ（tmpDir）が必須パラメータです。VMRディレクトリに未コミットの変更がある場合はエラー終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| tmpDir | string | Yes | - | 一時フォルダのパス（リポジトリクローン用） |
| vmrBranch | string | No | - | VMRのブランチ名（チェックアウト対象） |
| remote | string | No | - | 追加リモート（フォークからの同期用） |
| azdevPat | string | No | - | Azure DevOps PAT（プライベートリポジトリ用） |
| vmrDir | string | No | $tmpDir/dotnet | VMRディレクトリのパス |
| ci | switch | No | - | CI環境での実行を示すフラグ |
| debugOutput | switch | No | - | デバッグログを有効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 現在のリポジトリ | Git | 同期元のソースコードリポジトリ |
| dotnet/dotnet | Git | VMRリポジトリ（同期先） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VMRディレクトリ | Git Repository | 同期されたVMRリポジトリ |
| 標準出力 | Text | 実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | VMRリポジトリ内の各種ファイル |
| 出力先 | $vmrDir |
| 文字コード | 各ファイルによる |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. パラメータ検証
   └─ tmpDirの必須チェック
2. 入力の正規化
   └─ vmrDirのデフォルト値設定（$tmpDir/dotnet）
3. 一時ディレクトリの作成
   └─ 存在しない場合は作成
4. VMRリポジトリの準備
   ├─ 存在しない場合：GitHub からクローン
   │   └─ vmrBranch指定時はブランチ作成・切り替え
   └─ 存在する場合：
       ├─ 未コミット変更のチェック（あればエラー）
       └─ vmrBranch指定時はチェックアウト・プル
5. .NET SDK/Darcの初期化
   ├─ InitializeDotNetCliで.NET SDKを準備
   └─ Get-DarcでDarcツールを取得
6. VMR同期の実行
   └─ darc vmr forwardflowコマンドの実行
7. 結果確認
   └─ 成功/失敗メッセージの出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{tmpDir指定あり?}
    B -->|なし| C[エラー終了]
    B -->|あり| D[入力正規化]
    D --> E{tmpDir存在?}
    E -->|なし| F[ディレクトリ作成]
    E -->|あり| G{vmrDir存在?}
    F --> G
    G -->|なし| H[VMRクローン]
    H --> I{vmrBranch指定?}
    I -->|あり| J[ブランチ作成]
    I -->|なし| K[.NET/Darc初期化]
    J --> K
    G -->|あり| L{未コミット変更?}
    L -->|あり| M[エラー終了]
    L -->|なし| N{vmrBranch指定?}
    N -->|あり| O[チェックアウト・プル]
    N -->|なし| K
    O --> K
    K --> P[darc vmr forwardflow実行]
    P --> Q{同期成功?}
    Q -->|成功| R[成功メッセージ]
    Q -->|失敗| S[失敗メッセージ・ガイダンス]
    R --> T[正常終了]
    S --> U[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータ不足 | tmpDirが指定されていない | -tmpDirパラメータを指定 |
| 1 | 未コミット変更 | VMRに未コミットの変更がある | 変更をコミットまたはスタッシュ |
| 1 | 同期失敗 | darc vmr forwardflowが失敗 | ログを確認し、パッチファイルを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. 未コミット変更がある場合は、`git stash`または`git commit`で解決
3. 同期失敗の場合は、ログに含まれるパッチファイルのパスを確認
4. パッチの競合を解決し、ローカルでコミット後に再実行
5. debugOutputフラグを有効にして詳細ログを取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（Git操作） |
| コミットタイミング | Darcツールが自動コミット |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リポジトリの同期 |
| 目標処理時間 | リポジトリサイズとネットワーク速度に依存（数分〜数十分） |
| メモリ使用量上限 | Gitおよび.NET SDKの要件に依存 |

## 排他制御

同一VMRディレクトリに対して複数の同期処理を同時に実行することは推奨されません。Git操作の競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各フェーズ開始時 | "Cloning 'dotnet/dotnet'..."、"Preparing..."等 |
| コマンドログ | Darc実行時 | 実行コマンドとパラメータ |
| 成功ログ | 同期成功時 | "Synchronization succeeded" |
| 失敗ログ | 同期失敗時 | 失敗理由とリカバリガイダンス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 手動確認 / CIパイプライン |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- VMR（Virtual Monolithic Repository）はdotnet/dotnetリポジトリを指します
- DarcはMicrosoftの.NETリポジトリ間依存関係管理ツールです
- verbosityレベルは'verbose'（デフォルト）または'debug'（debugOutput指定時）
- 同期失敗時のガイダンス：
  - VMRディレクトリは最後の状態のまま残されます
  - 再実行でリセットされます
  - パッチファイルの競合を手動で解決後、ローカルコミットして再実行してください
- ciスイッチはDarcコマンドに--ciフラグを渡します
- azdevPatはプライベートリポジトリへのアクセスに必要です
