# バッチ設計書 59-vmr-sync.sh

## 概要

本ドキュメントは、現在のリポジトリをローカルのVMR（Virtual Monolithic Repository）に同期するためのBashスクリプト `eng/common/vmr-sync.sh` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、Darcツールを使用して現在のリポジトリのコードをdotnet/dotnet VMRに同期し、Unix/Linux/macOS環境でのローカルSource-Build検証やテストを可能にします。

**業務上の目的・背景**：.NETエコシステムでは、複数の個別リポジトリ（dotnet/runtime、dotnet/roslyn等）のコードが最終的にVMR（Virtual Monolithic Repository、dotnet/dotnetリポジトリ）に統合されます。Unix系環境の開発者が自分の変更がVMRに統合された際の影響を事前に確認するためには、ローカル環境でVMRへの同期をシミュレートする必要があります。本バッチは、vmr-sync.ps1のBash版として、Unix/Linux/macOS環境での同期プロセスを自動化します。

**バッチの実行タイミング**：開発者がローカルで手動実行、またはCIパイプライン（Linux/macOSエージェント）でSource-Build検証時に実行されます。

**主要な処理内容**：
1. コマンドライン引数の解析
2. 一時ディレクトリの準備
3. VMRリポジトリ（dotnet/dotnet）のクローンまたは更新
4. VMRの作業ツリーの状態確認
5. .NET SDKとDarcツールの初期化
6. Darcのvmr forwardflowコマンドによる同期実行

**前後の処理との関連**：本スクリプトは独立して実行可能ですが、同期後はVMRディレクトリでSource-Buildテストやその他の検証を実行することを想定しています。vmr-sync.ps1と同等の機能をBashで提供します。

**影響範囲**：指定されたVMRディレクトリに現在のリポジトリのコードが同期されます。VMRの既存の変更がある場合は警告を出力します。

## バッチ種別

リポジトリ同期 / Source-Build準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行 / CI実行時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 開発者手動実行 / CIパイプライン（Linux/macOS） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash | Bash シェルが利用可能であること |
| Git | gitコマンドが利用可能であること |
| tools.sh | Arcade共通ツールユーティリティが利用可能であること |
| インターネット接続 | GitHubおよび必要に応じてAzure DevOpsへのアクセスが可能であること |

### 実行可否判定

一時ディレクトリ（--tmp-dir）が必須パラメータです。VMRディレクトリに未コミットの変更がある場合はエラー終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -t, --tmp, --tmp-dir | string | Yes | - | 一時フォルダのパス（リポジトリクローン用） |
| -b, --branch, --vmr-branch | string | No | - | VMRのブランチ名（チェックアウト対象） |
| --remote | string | No | - | 追加リモート（name:URI形式、フォークからの同期用） |
| --azdev-pat | string | No | - | Azure DevOps PAT（プライベートリポジトリ用） |
| -v, --vmr, --vmr-dir | string | No | $tmp_dir/dotnet | VMRディレクトリのパス |
| --ci | flag | No | - | CI環境での実行を示すフラグ |
| -d, --debug | flag | No | - | デバッグログを有効化 |
| -h, --help | flag | No | - | ヘルプを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 現在のリポジトリ | Git | 同期元のソースコードリポジトリ |
| dotnet/dotnet | Git | VMRリポジトリ（同期先） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VMRディレクトリ | Git Repository | 同期されたVMRリポジトリ |
| 標準出力 | Text | 実行ログ（色付き出力対応） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | VMRリポジトリ内の各種ファイル |
| 出力先 | $vmr_dir |
| 文字コード | 各ファイルによる |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. シンボリックリンクの解決
   └─ スクリプトの実際のパスを取得
2. ヘルプ関数の定義
   └─ コメントからヘルプテキストを抽出
3. 色付き出力関数の定義
   └─ fail（赤）、highlight（シアン）関数
4. コマンドライン引数の解析
   └─ while/caseによるオプション解析
5. パラメータ検証
   └─ tmp_dirの必須チェック
6. 入力の正規化
   └─ vmr_dirのデフォルト値設定
7. 一時ディレクトリの作成
   └─ 存在しない場合は作成
8. デバッグモード設定
   └─ debug時はset -x有効化
9. VMRリポジトリの準備
   ├─ 存在しない場合：GitHubからクローン
   └─ 存在する場合：未コミット変更チェック
10. .NET SDK/Darcの初期化
    └─ tools.shを読み込み、InitializeDotNetCli、GetDarc実行
11. VMR同期の実行
    └─ darc vmr forwardflowコマンドの実行
12. 結果確認
    └─ 成功/失敗メッセージの出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[シンボリックリンク解決]
    B --> C[引数解析]
    C --> D{tmp_dir指定あり?}
    D -->|なし| E[エラー終了]
    D -->|あり| F[入力正規化]
    F --> G{tmp_dir存在?}
    G -->|なし| H[ディレクトリ作成]
    G -->|あり| I{vmr_dir存在?}
    H --> I
    I -->|なし| J[VMRクローン]
    J --> K{vmr_branch指定?}
    K -->|あり| L[ブランチ作成]
    K -->|なし| M[.NET/Darc初期化]
    L --> M
    I -->|あり| N{未コミット変更?}
    N -->|あり| O[エラー終了]
    N -->|なし| P{vmr_branch指定?}
    P -->|あり| Q[チェックアウト・プル]
    P -->|なし| M
    Q --> M
    M --> R[DOTNET_ROOT設定]
    R --> S[darc vmr forwardflow実行]
    S --> T{同期成功?}
    T -->|成功| U[成功メッセージ]
    T -->|失敗| V[失敗メッセージ]
    U --> W[正常終了]
    V --> X[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータ不足 | tmp_dirが指定されていない | --tmp-dirパラメータを指定 |
| 1 | 無効な引数 | 不明なコマンドライン引数 | ヘルプを参照（-h） |
| 1 | 未コミット変更 | VMRに未コミットの変更がある | 変更をコミットまたはスタッシュ |
| 非ゼロ | 同期失敗 | darc vmr forwardflowが失敗 | ログを確認し、パッチファイルを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. 未コミット変更がある場合は、`git stash`または`git commit`で解決
3. 同期失敗の場合は、--debugフラグで詳細ログを取得
4. パッチの競合を解決し、ローカルでコミット後に再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（Git操作） |
| コミットタイミング | Darcツールが自動コミット |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リポジトリの同期 |
| 目標処理時間 | リポジトリサイズとネットワーク速度に依存（数分〜数十分） |
| メモリ使用量上限 | Gitおよび.NET SDKの要件に依存 |

## 排他制御

同一VMRディレクトリに対して複数の同期処理を同時に実行することは推奨されません。Git操作の競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各フェーズ開始時 | "Cloning 'dotnet/dotnet'..."、"Preparing..."等（シアン色） |
| コマンドログ | Darc実行時 | 実行コマンドとパラメータ |
| 成功ログ | 同期成功時 | "Synchronization succeeded"（シアン色） |
| 失敗ログ | 同期失敗時 | 失敗理由とリカバリガイダンス（赤色） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | 手動確認 / CIパイプライン |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- vmr-sync.ps1のBash版であり、同等の機能をUnix/Linux/macOS環境で提供します
- VMR（Virtual Monolithic Repository）はdotnet/dotnetリポジトリを指します
- DarcはMicrosoftの.NETリポジトリ間依存関係管理ツールです
- verbosityレベルは'verbose'（デフォルト）または'debug'（--debug指定時）
- --remoteオプションはname:URI形式で指定（例：'runtime:https://github.com/yourfork/runtime'）
- 色付き出力はtputコマンドで実装（対応端末のみ）
- set -eによりコマンド失敗時に即座に終了します
- DOTNET_ROOT環境変数が.dotnetディレクトリに設定されます
- ヘルプはスクリプト内のコメント（### で始まる行）から自動生成されます
