# バッチ設計書 6-eng/make-bootstrap.ps1

## 概要

本ドキュメントは、Roslynプロジェクトのブートストラップコンパイラビルドスクリプト「eng/make-bootstrap.ps1」の設計仕様を記載する。

### 本バッチの処理概要

eng/make-bootstrap.ps1は、Roslynコンパイラの「ブートストラップビルド」を実行するためのPowerShellスクリプトである。ブートストラップとは、コンパイラ自身をビルドするために使用するコンパイラを構築するプロセスを指す。

**業務上の目的・背景**：コンパイラ開発において、自己検証（セルフホスティング）は重要な品質保証手段である。新しいコンパイラで自分自身をビルドし、その結果が正しく動作することを確認することで、コンパイラの正当性を検証できる。本スクリプトは、この検証プロセスに必要なブートストラップコンパイラを生成する。

**バッチの実行タイミング**：eng/build.ps1から--bootstrapオプション指定時に自動呼び出し、テスト検証（test-build-correctness.ps1、test-determinism.ps1）実行時、開発者による手動実行。

**主要な処理内容**：
1. 出力先ディレクトリの検証と準備（既存の場合は-forceで削除）
2. Microsoft.Net.Compilers.Toolsetパッケージのビルド（dotnet build）
3. NuGetパッケージ（.nupkg）の作成
4. パッケージの解凍と配置
5. ビルド成果物のクリーンアップ
6. MSBuildビルドサーバーのシャットダウン

**前後の処理との関連**：eng/build.ps1やtest-*.ps1スクリプトから呼び出される。生成されたブートストラップコンパイラは、後続のビルドで-bootstrapDirオプションを通じて使用される。

**影響範囲**：artifacts/bootstrapディレクトリにブートストラップコンパイラが生成される。このコンパイラは以降のビルドで使用され、ビルド結果の正当性検証に影響を与える。

## バッチ種別

ビルド処理（コンパイラセルフホスティング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ブートストラップビルド要求時） |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / eng/build.ps1からの自動呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境でのみ実行可能 |
| PowerShell | PowerShellが利用可能であること |
| .NET SDK | dotnetコマンドが利用可能であること |

### 実行可否判定

- 出力先ディレクトリが既に存在する場合、-forceオプションがないとエラー終了
- -forceオプション指定時は既存ディレクトリを削除して続行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -output | string | No | artifacts/bootstrap/local | 出力先ディレクトリ |
| -toolset | string | No | Default | ツールセット種別（Default/Framework） |
| -configuration | string | No | Release | ビルド構成 |
| -force | switch | No | false | 既存出力を強制削除 |
| -ci | switch | No | false | CI環境フラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Microsoft.Net.Compilers.Toolset.Package.csproj | csproj | ツールセットパッケージプロジェクト |
| ソースコード | C#/VB | コンパイラソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {output}/ | Directory | ブートストラップコンパイラ一式 |
| {output}/*.nupkg | NuGet | コンパイラツールセットパッケージ |
| artifacts/log/bootstrap-*.binlog | binlog | ビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Microsoft.Net.Compilers.Toolset.*.nupkg |
| 出力先 | 指定された出力ディレクトリ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. build-utils.ps1読み込み
   └─ 共通ユーティリティ関数の読み込み
2. 出力先ディレクトリ検証
   └─ 存在チェック、-force時は削除
3. ツールセットプロジェクトパス決定
   └─ Default: AnyCpu、Framework: Framework
4. dotnet buildによるパッケージビルド
   └─ /t:Pack、BOOTSTRAP定数定義
5. NuGetパッケージ解凍
   └─ Unzip関数でnupkgを展開
6. クリーンアップ処理
   └─ dotnet build --no-restore /t:Clean
7. ビルドサーバーシャットダウン
   └─ dotnet build-server shutdown
8. 正常終了
   └─ ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[make-bootstrap.ps1開始] --> B[build-utils.ps1読み込み]
    B --> C{出力先存在?}
    C -->|Yes| D{-force?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[既存ディレクトリ削除]
    C -->|No| G[ツールセットパス決定]
    F --> G
    G --> H{toolset種別}
    H -->|Default| I[AnyCpuプロジェクト]
    H -->|Framework| J[Frameworkプロジェクト]
    I --> K[dotnet build /t:Pack]
    J --> K
    K --> L[nupkgファイル検索]
    L --> M[Unzipで展開]
    M --> N[dotnet build /t:Clean]
    N --> O[build-server shutdown]
    O --> P[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 出力先存在エラー | 出力先が存在し-forceなし | -forceを指定するか出力先を変更 |
| 1 | toolsetエラー | 不正なtoolset値 | Default/Frameworkを指定 |
| 1 | ビルドエラー | dotnet build失敗 | エラーメッセージに従い修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. artifacts/log/bootstrap-*.binlogを確認
3. 出力先ディレクトリの状態を確認
4. エラー内容に応じて対処

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コンパイラツールセット1パッケージ |
| 目標処理時間 | 環境依存（通常3-10分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

- MSBuildノード再利用を無効化（/nodeReuse:false）
- ビルド完了後にビルドサーバーをシャットダウン
- 同一出力先への複数同時実行は不可

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 常時 | 進捗メッセージ |
| バイナリログ | ビルド時 | MSBuild詳細ログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 呼び出し元スクリプト |

## 備考

- ブートストラップビルドはRelease構成がデフォルト（品質検証目的）
- BOOTSTRAP定数が定義され、一部のコードパスが変更される
- DotNetUseShippingVersions=trueでバージョン管理
- NgenOptimization=false、PublishWindowsPdb=falseで最適化を省略
- CI環境ではContinuousIntegrationBuild=trueが設定される
- ビルド後のクリーンアップで中間ファイルを削除
