# バッチ設計書 60-internal-feed-operations.ps1

## 概要

本ドキュメントは、内部NuGetフィードへのアクセスを設定し、Arcade SDKのリストアを行うPowerShellスクリプト `eng/common/internal-feed-operations.ps1` の設計仕様を定義します。

### 本バッチの処理概要

このバッチは、Azure DevOpsの内部フィード（darc-int-*）に対する認証を設定し、またはArcade SDKをインストール・リストアすることで、内部ビルドでのパッケージ依存関係解決を可能にします。

**業務上の目的・背景**：.NETプロジェクトの内部ビルドでは、公開NuGetフィードに加えて、Azure DevOpsの内部フィード（darc-int-*という名前パターン）からパッケージを取得する必要があります。これらの内部フィードには認証が必要であり、CIビルドエージェントで正しく認証を設定する必要があります。本バッチは、Microsoft CredProvider（認証プラグイン）のインストールと、VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数の設定を自動化することで、内部フィードからのパッケージリストアを可能にします。

**バッチの実行タイミング**：CIパイプラインにおいて、内部フィードからのパッケージリストアが必要な場合に実行されます。

**主要な処理内容**：
1. Operation='setup'の場合：
   - Microsoft CredProviderプラグインのダウンロードとインストール
   - NuGet.configからdarc-int-*フィードの抽出
   - VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数の設定
2. Operation='install-restore'の場合：
   - .NET SDKの一時インストール
   - Arcade SDKのリストア

**前後の処理との関連**：本スクリプトは通常、ビルド処理の前段階で実行され、後続のdotnet restoreコマンドが内部フィードからパッケージを取得できるようにします。

**影響範囲**：Azure DevOps環境変数（VSS_NUGET_EXTERNAL_FEED_ENDPOINTS、NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLED）を設定します。また、CredProviderプラグインをユーザープロファイルにインストールします。

## バッチ種別

認証設定 / パッケージ管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | ビルド前処理時 |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Operation | 'setup'または'install-restore'が指定されること |
| NuGet.config | リポジトリルートにNuGet.configが存在すること（setup時） |
| tools.ps1 | Arcade共通ツールユーティリティが利用可能であること |
| インターネット接続 | GitHubおよびAzure DevOpsへのアクセスが可能であること |

### 実行可否判定

Operationパラメータに応じて処理が分岐します。不明なOperationが指定された場合はエラー終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| Operation | string | Yes | - | 実行する操作（'setup' or 'install-restore'） |
| AuthToken | string | Cond | - | Azure DevOps認証トークン（setup時必須） |
| CommitSha | string | No | - | コミットSHA（未使用） |
| RepoName | string | No | - | リポジトリ名（未使用） |
| IsFeedPrivate | switch | No | - | プライベートフィードフラグ（未使用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | darc-int-*フィード設定を含むNuGet設定ファイル |
| installcredprovider.ps1 | Script | Microsoft CredProviderインストールスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 環境変数 | String | VSS_NUGET_EXTERNAL_FEED_ENDPOINTSなど |
| CredProviderプラグイン | Binary | %USERPROFILE%\.nuget\plugins\netcoreにインストール |
| 標準出力 | Text | 実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CredProviderプラグインファイル群 |
| 出力先 | %USERPROFILE%\.nuget\plugins\netcore |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス（setup操作）

```
1. スクリプト初期化
   └─ tools.ps1の読み込み
2. CredProviderインストール
   ├─ installcredprovider.ps1をGitHubからダウンロード
   ├─ プラグインのインストール実行
   └─ インストール確認
3. NuGet.configの解析
   └─ darc-int-*パターンのフィードURLを抽出
4. 認証エンドポイントの構築
   └─ 各フィードURLとAuthTokenをJSON形式で構築
5. 環境変数の設定
   ├─ VSS_NUGET_EXTERNAL_FEED_ENDPOINTS
   └─ NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLED=False
```

### 処理シーケンス（install-restore操作）

```
1. スクリプト初期化
   └─ tools.ps1の読み込み
2. 一時.NET SDKのインストール
   └─ dotnetTempDir配下にSDK 2.1.507をインストール
3. Arcade SDKリストア
   ├─ 一時プロジェクトファイル(restore.proj)を作成
   └─ dotnet restoreを実行
4. クリーンアップ
   └─ 一時ファイルとディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C{Operation?}
    C -->|setup| D[CredProviderダウンロード]
    D --> E[プラグインインストール]
    E --> F{インストール成功?}
    F -->|失敗| G[エラー終了]
    F -->|成功| H[NuGet.config解析]
    H --> I{darc-int-*フィードあり?}
    I -->|なし| J[完了ログ出力]
    I -->|あり| K[エンドポイントJSON構築]
    K --> L[環境変数設定]
    L --> M[正常終了]
    J --> M
    C -->|install-restore| N[.NET SDK一時インストール]
    N --> O[restore.proj作成]
    O --> P[dotnet restore実行]
    P --> Q[クリーンアップ]
    Q --> M
    C -->|その他| R[エラー出力]
    R --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 不明なOperation | 'setup'/'install-restore'以外の値 | 正しいOperation値を指定 |
| 1 | CredProviderインストール失敗 | プラグインディレクトリが作成されない | ネットワーク接続を確認 |
| 1 | NuGet.config不在 | リポジトリルートにNuGet.configがない | NuGet.configを作成 |
| 1 | 例外発生 | その他の予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログで失敗原因を特定
2. GitHubへのアクセス（CredProviderダウンロード用）を確認
3. NuGet.configの形式とdarc-int-*フィードの定義を確認
4. AuthTokenが有効か確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作・環境変数設定） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のセットアップ処理 |
| 目標処理時間 | 数十秒〜数分（ネットワーク速度依存） |
| メモリ使用量上限 | .NET SDKの要件に依存 |

## 排他制御

同一ビルドエージェントで複数のセットアップ処理を同時に実行することは推奨されません。CredProviderのインストールやファイル操作で競合が発生する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各フェーズ開始時 | "Setting up Cred Provider..."、"Installing plugin..."等 |
| 確認ログ | インストール完了時 | "CredProvider plugin was installed correctly!" |
| 情報ログ | フィードなし時 | "No internal endpoints found in NuGet.config" |
| エラーログ | エラー発生時 | スタックトレースとエラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非ゼロ | CIパイプライン |

## 備考

- 本スクリプトはArcade共通インフラストラクチャ（dotnet/arcade）の一部として提供されています
- CredProviderはMicrosoftが提供するNuGet認証プラグインで、Azure DevOpsフィードへの認証を自動化します
- VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数はCredProviderが認識する形式でエンドポイント情報を保持します
- NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLEDをFalseに設定することで、セッションキャッシュを無効化し、頻繁なエンドポイント更新に対応します
- install-restore操作はMSBuildのバグ（https://github.com/microsoft/msbuild/issues/4430）のワークアラウンドとして実装されています
- 使用される.NET SDKバージョン（2.1.507）は、Arcade SDKリストア時の互換性のために固定されています
- Azure Pipelinesのログコマンド（Write-LoggingCommand）を使用して環境変数を設定します
- darc-int-*パターンは、Darcツールによって自動生成される内部フィードの命名規則です
