# バッチ設計書 61-internal-feed-operations.sh

## 概要

本ドキュメントは、内部NuGetフィードへのパッケージ操作を行うBashスクリプト `eng/common/internal-feed-operations.sh` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Azure DevOps内部フィードからNuGetパッケージを認証付きでリストア・取得するための環境をセットアップする。Unix/Linux環境向けのBashスクリプトとして実装されており、CI/CDパイプラインにおいて内部パッケージへのアクセスを可能にする。

**業務上の目的・背景**：Roslynプロジェクトでは、プライベートな内部NuGetフィード（darc-int-*）を使用して、まだ公開されていないパッケージや内部ツールを共有している。この内部フィードへのアクセスには認証が必要であり、CIビルドエージェント上で適切な認証情報を設定する必要がある。本バッチは、この認証設定を自動化し、ビルドプロセスをシームレスに実行できるようにする。

**バッチの実行タイミング**：CIビルドの初期段階（パッケージリストア前）に実行される。内部ビルドとして識別されたビルドのみで呼び出される。

**主要な処理内容**：
1. Microsoft artifacts-credproviderプラグインのインストール（GitHubからダウンロード）
2. NuGet.configファイルからdarc-int-*パターンのフィードエンドポイントを抽出
3. VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数の設定（認証情報付き）
4. Azure SDKリストア用の一時的なdotnet SDKインストール（オプション）

**前後の処理との関連**：本バッチは、eng/common/tools.shに依存し、そのユーティリティ関数を使用する。後続のNuGetリストア処理（dotnet restore）が認証付きで内部フィードにアクセスできるようになる。

**影響範囲**：環境変数VSS_NUGET_EXTERNAL_FEED_ENDPOINTS、NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLEDが設定される。$HOME/.nuget/pluginsディレクトリにCredProviderプラグインがインストールされる。

## バッチ種別

認証・環境設定 / NuGetパッケージ認証プロバイダーセットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプラインからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 内部ビルドであること | darc-int-*フィードへのアクセスが必要な内部ビルドでのみ実行 |
| 認証トークンが利用可能 | Azure DevOpsへの認証用トークンが提供されていること |
| インターネット接続 | GitHubからCredProviderスクリプトをダウンロードするため |
| NuGet.configの存在 | リポジトリルートにNuGet.configファイルが存在すること |

### 実行可否判定

--operationパラメータで指定された操作種別に応じて処理を分岐：
- `setup`: CredProviderのセットアップと環境変数の設定
- `install-restore`: dotnet SDKのインストールとArcade SDKのリストア

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --operation | string | Yes | - | 実行する操作（setup / install-restore） |
| --authtoken | string | Yes（setupの場合） | - | Azure DevOps認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | darc-int-*フィードの定義を含む設定ファイル |
| installcredprovider.sh | Shell Script | GitHubからダウンロードされるCredProviderインストールスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $HOME/.nuget/plugins | ディレクトリ | CredProviderプラグインのインストール先 |
| Azure Pipeline変数 | 環境変数 | VSS_NUGET_EXTERNAL_FEED_ENDPOINTS |
| Azure Pipeline変数 | 環境変数 | NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLED |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CredProviderプラグインバイナリ |
| 出力先 | $HOME/.nuget/plugins |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --operation、--authtokenを取得
2. スクリプトルートの解決
   └─ シンボリックリンクを考慮したパス解決
3. tools.shの読み込み
   └─ 共通ユーティリティ関数の利用準備
4. 操作種別による分岐
   └─ setup または install-restore
5. [setupの場合] SetupCredProvider関数の実行
   └─ 5.1 installcredprovider.shのダウンロード
   └─ 5.2 プラグインのインストール
   └─ 5.3 インストール確認
   └─ 5.4 NuGet.configからエンドポイント抽出
   └─ 5.5 環境変数の設定
6. [install-restoreの場合] InstallDotNetSdkAndRestoreArcade関数の実行
   └─ 6.1 一時的なdotnet SDK（2.1.507）のインストール
   └─ 6.2 Arcade SDKのリストア
   └─ 6.3 一時ファイルのクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{operationの値}
    C -->|setup| D[SetupCredProvider]
    C -->|install-restore| E[InstallDotNetSdkAndRestoreArcade]
    C -->|その他| F[エラー出力]
    D --> D1[installcredprovider.shダウンロード]
    D1 --> D2[プラグインインストール]
    D2 --> D3{インストール成功?}
    D3 -->|Yes| D4[NuGet.config解析]
    D3 -->|No| F
    D4 --> D5[環境変数設定]
    D5 --> G[バッチ終了]
    E --> E1[dotnet SDK 2.1.507インストール]
    E1 --> E2[Arcade SDKリストア]
    E2 --> E3[一時ファイル削除]
    E3 --> G
    F --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | CredProviderインストール失敗 | $HOME/.nuget/pluginsディレクトリが作成されない | ネットワーク接続を確認し再実行 |
| 1 | NuGet.config不在 | リポジトリルートにNuGet.configが存在しない | NuGet.configを作成 |
| 1 | 不明な操作 | --operationに未知の値が指定された | setup または install-restore を指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ネットワーク接続を確認し、GitHubへのアクセスが可能か検証
2. 手動でinstallcredprovider.shをダウンロードして実行
3. 環境変数VSS_NUGET_EXTERNAL_FEED_ENDPOINTSを手動設定

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 特になし |

## 排他制御

同一エージェント上での並列実行は想定していない。CIパイプラインの順序制御により、パッケージリストア前に完了することが保証される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Setting up Cred Provider NuGet plugin in the agent..." |
| 進捗ログ | ダウンロード時 | "Getting 'installcredprovider.ps1' from..." |
| 進捗ログ | インストール時 | "Installing plugin..." |
| 成功ログ | インストール完了時 | "CredProvider plugin was installed correctly!" |
| エラーログ | 失敗時 | Write-PipelineTelemetryError経由でAzure Pipelinesに出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒 | Azure Pipelines |
| インストール失敗 | 発生時 | Azure Pipelines |

## 備考

- PowerShell版のeng/common/internal-feed-operations.ps1と同等の機能を持つ
- dotnet/arcadeフレームワークの共通スクリプト群の一部
- MSBuildの問題 https://github.com/microsoft/msbuild/issues/4430 のワークアラウンドを含む
