# バッチ設計書 62-retain-build.ps1

## 概要

本ドキュメントは、Azure DevOpsでビルドを永続保持対象に設定するPowerShellスクリプト `eng/common/retain-build.ps1` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Azure DevOps REST APIを使用して、指定されたビルドを永続保持（keepForever）対象に設定する。これにより、ビルド成果物が自動的に削除されることを防ぎ、重要なリリースビルドやマイルストーンビルドを恒久的に保存できる。

**業務上の目的・背景**：Azure DevOpsでは、ビルド成果物はデフォルトで一定期間経過後に自動削除される。しかし、リリースビルドや重要なマイルストーンビルドについては、法的要件、監査要件、または将来の参照のために永続的に保持する必要がある。本バッチは、このようなビルドに対して自動削除を無効化し、永続保持を設定する。

**バッチの実行タイミング**：CIパイプラインのポストビルドステージ、特にリリースビルドや重要なビルドが完了した際に実行される。手動でも実行可能。

**主要な処理内容**：
1. Azure DevOps認証ヘッダーの生成（Base64エンコード）
2. ビルドAPI（PATCH /builds/{buildId}）への更新リクエスト送信
3. keepForeverフラグをtrueに設定
4. 成功/失敗のステータス確認と報告

**前後の処理との関連**：ビルド完了後、成果物の公開（publish-using-darc.ps1など）と並行または後続で実行される。ビルドが保持されることで、後続のデバッグや調査が可能になる。

**影響範囲**：Azure DevOpsのビルド設定が変更される。ビルドの保持ポリシーが上書きされ、永続保持が設定される。ストレージ使用量に影響を与える可能性がある。

## バッチ種別

Azure DevOps管理 / ビルド保持設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（重要ビルド完了時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルドが完了していること | 対象のビルドIDが有効で、ビルドが存在すること |
| Azure DevOpsトークンが有効 | 十分な権限を持つPATトークンが提供されること |
| ネットワーク接続 | Azure DevOps APIへのアクセスが可能であること |

### 実行可否判定

パラメータとして必須項目（BuildId、azdoOrgUri、azdoProject、token）がすべて提供されている場合に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| buildId | int | Yes | - | 保持対象のビルドID |
| azdoOrgUri | string | Yes | - | Azure DevOps組織のURI（例：https://dev.azure.com/dnceng） |
| azdoProject | string | Yes | - | Azure DevOpsプロジェクト名 |
| token | string | Yes | - | Azure DevOps Personal Access Token |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドラインパラメータ | PowerShell引数 | 上記4つの必須パラメータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure DevOps | REST API | ビルド保持設定の更新 |
| コンソール | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. パラメータ受け取り
   └─ buildId, azdoOrgUri, azdoProject, token
2. Get-AzDOHeaders関数呼び出し
   └─ トークンをBase64エンコード
   └─ Authorization: Basicヘッダー生成
3. Update-BuildRetention関数呼び出し
   └─ 3.1 リクエストボディ作成（{"keepForever": "true"}）
   └─ 3.2 APIエンドポイントURL構築
   └─ 3.3 Invoke-RestMethodでPATCHリクエスト送信
   └─ 3.4 成功時：メッセージ出力
   └─ 3.5 失敗時：エラー出力してexit 1
4. 正常終了（exit 0）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ取得]
    B --> C[認証ヘッダー生成]
    C --> D[リクエストボディ作成]
    D --> E[API URI構築]
    E --> F[PATCH リクエスト送信]
    F --> G{成功?}
    G -->|Yes| H[成功メッセージ出力]
    G -->|No| I[エラー出力]
    H --> J[exit 0]
    I --> K[exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。Azure DevOpsの内部データストアがAPI経由で更新される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | API呼び出し失敗 | ネットワークエラー、認証エラー、不正なビルドID | トークンとビルドIDを確認して再実行 |
| 1 | 権限不足 | トークンにビルド更新権限がない | 適切な権限を持つトークンを使用 |
| 1 | ビルド不在 | 指定されたビルドIDが存在しない | 正しいビルドIDを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. Azure DevOpsポータルで手動でビルドの保持設定を変更
2. トークンの有効期限と権限を確認
3. ビルドIDが正しいことを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一API呼び出し |
| コミットタイミング | API呼び出し成功時（即座） |
| ロールバック条件 | API呼び出し失敗時（変更なし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 5秒以内 |
| メモリ使用量上限 | 特になし |

## 排他制御

単一ビルドに対する操作であり、並行して同一ビルドに対して実行された場合はAPI側で整合性が保たれる（最後のリクエストが優先）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | リクエスト送信前 | "Attempting to retain build using the following URI: {URI} ..." |
| 成功ログ | 成功時 | "Updated retention settings for build {buildId}." |
| エラーログ | 失敗時 | "Failed to update retention settings for build: {StatusDescription}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| API呼び出し失敗 | 発生時 | Azure Pipelines（exit 1による） |

## 備考

- Azure DevOps REST API バージョン6.0を使用
- dotnet/arcadeフレームワークの共通スクリプト群の一部
- ビルド保持は永続的であり、手動で解除しない限り削除されない
