# バッチ設計書 63-pipeline-logging-functions.ps1

## 概要

本ドキュメントは、Azure Pipelinesのログコマンド出力ユーティリティを提供するPowerShellスクリプト `eng/common/pipeline-logging-functions.ps1` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Azure Pipelinesで使用されるログコマンド（##vso[...]形式）を生成・出力するためのユーティリティ関数群を提供するライブラリスクリプトである。直接実行されるバッチではなく、他のスクリプトからドットソース（. source）で読み込まれて使用される。

**業務上の目的・背景**：Azure Pipelinesでは、ビルドログに特殊なコマンド（##vso[task.logissue]、##vso[task.setvariable]など）を出力することで、エラー/警告の報告、変数の設定、パスの追加などの操作を行う。本スクリプトは、これらのコマンドを正しいフォーマットで生成するユーティリティ関数を提供し、他のビルドスクリプトでの一貫したログ出力を可能にする。

**バッチの実行タイミング**：他のPowerShellスクリプト（tools.ps1など）からドットソースで読み込まれる。CIビルド実行時に間接的に使用される。

**主要な処理内容**：
1. Write-PipelineTelemetryError：テレメトリカテゴリ付きエラー出力
2. Write-PipelineTaskError：タスクエラー/警告の出力
3. Write-PipelineSetVariable：パイプライン変数の設定
4. Write-PipelinePrependPath：PATHへのディレクトリ追加
5. Write-PipelineSetResult：タスク結果の設定

**前後の処理との関連**：tools.ps1などのビルドスクリプトから読み込まれ、ビルドプロセス全体でログ出力に使用される。Azure Pipelinesエージェントがログを解析して適切なアクションを実行する。

**影響範囲**：Azure Pipelinesのビルドログ、パイプライン変数、ビルド結果ステータスに影響を与える。

## バッチ種別

ユーティリティライブラリ / ログ出力支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトからの呼び出し時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | ドットソースでの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| $ci変数の設定 | CI環境では$ci = $trueが設定されていること |
| Azure Pipelinesエージェント | ##vso[...]コマンドを解釈するエージェント上で実行されること |

### 実行可否判定

関数呼び出し時に$ci変数をチェック。CI環境（$ci = $true）の場合のみAzure Pipelines形式で出力。それ以外の場合は通常のWrite-Hostで出力。-Forceスイッチで強制的にパイプライン形式を使用可能。

## 入力仕様

### 入力パラメータ

#### Write-PipelineTelemetryError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| Category | string | Yes | - | テレメトリカテゴリ |
| Message | string | Yes | - | エラーメッセージ |
| Type | string | No | 'error' | メッセージタイプ（error/warning） |
| ErrCode | string | No | - | エラーコード |
| SourcePath | string | No | - | ソースファイルパス |
| LineNumber | string | No | - | 行番号 |
| ColumnNumber | string | No | - | 列番号 |
| Force | switch | No | - | 非CI環境でも強制出力 |

#### Write-PipelineSetVariable

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| Name | string | Yes | - | 変数名 |
| Value | string | No | - | 変数値 |
| Secret | switch | No | - | シークレット変数として設定 |
| IsMultiJobVariable | bool | No | $true | 複数ジョブ間で共有する出力変数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 関数パラメータ | PowerShell引数 | 呼び出し元からの引数 |
| $ci変数 | boolean | CI環境フラグ（グローバル変数） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（Write-Host） | テキスト | ##vso[...]形式のログコマンド |
| コンソール（非CI時） | テキスト | 色付きの通常メッセージ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 関数呼び出し
   └─ Write-PipelineTelemetryError / Write-PipelineTaskError / など
2. CI環境判定
   └─ $ci変数と-Forceスイッチをチェック
3. [CI環境の場合]
   └─ 3.1 Format-LoggingCommandDataでデータをエスケープ
   └─ 3.2 Format-LoggingCommandでコマンド文字列を構築
   └─ 3.3 Write-LoggingCommandで出力
4. [非CI環境の場合]
   └─ 4.1 色付きでWrite-Host出力（エラー：赤、警告：黄）
```

### フローチャート

```mermaid
flowchart TD
    A[関数呼び出し] --> B{$ci == true または -Force?}
    B -->|Yes| C[Format-LoggingCommandData]
    B -->|No| D{Type == error?}
    C --> E[Format-LoggingCommand]
    E --> F[Write-LoggingCommand]
    F --> G[##vso[...] 形式で出力]
    D -->|Yes| H[Write-Host -ForegroundColor Red]
    D -->|No| I{Type == warning?}
    I -->|Yes| J[Write-Host -ForegroundColor Yellow]
    I -->|No| K[Write-Host 通常出力]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パラメータ不足 | 必須パラメータが未指定 | 必須パラメータを指定 |
| - | 無効なType | error/warning以外のTypeを指定 | error または warning を指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（ライブラリ関数） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

ログ出力の失敗は通常致命的ではないが、エラーが発生した場合は呼び出し元スクリプトのエラーハンドリングに従う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 多数（ビルド中に頻繁に呼び出し） |
| 目標処理時間 | 1ミリ秒以下/呼び出し |
| メモリ使用量上限 | 最小限 |

## 排他制御

標準出力への書き込みのみであり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | Write-PipelineTaskError呼び出し時 | ##vso[task.logissue type=error;...]メッセージ |
| 警告ログ | Write-PipelineTaskError呼び出し時（Type=warning） | ##vso[task.logissue type=warning;...]メッセージ |
| 変数設定 | Write-PipelineSetVariable呼び出し時 | ##vso[task.setvariable variable=名前;...]値 |
| パス追加 | Write-PipelinePrependPath呼び出し時 | ##vso[task.prependpath]パス |
| 結果設定 | Write-PipelineSetResult呼び出し時 | ##vso[task.complete result=結果;]メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー出力 | 発生時 | Azure Pipelinesがビルドログで検知 |
| 警告出力 | 発生時 | Azure Pipelinesがビルドログで検知 |

## 備考

- ソースはMicrosoft azure-pipelines-task-libから取得・修正
- ##vso[...]コマンドの特殊文字エスケープ対応（;→%3B、\r→%0D、\n→%0A、]→%5D）
- 非CI環境でのローカル実行時は通常のWrite-Hostに自動フォールバック
- dotnet/arcadeフレームワークの共通スクリプト群の一部
