# バッチ設計書 64-pipeline-logging-functions.sh

## 概要

本ドキュメントは、Azure Pipelinesのログコマンド出力ユーティリティを提供するBashスクリプト `eng/common/pipeline-logging-functions.sh` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Azure Pipelinesで使用されるログコマンド（##vso[...]形式）を生成・出力するためのユーティリティ関数群を提供するライブラリスクリプトである。PowerShell版（pipeline-logging-functions.ps1）のBash/Shell版として、Unix/Linux環境で同等の機能を提供する。

**業務上の目的・背景**：Azure Pipelinesでは、ビルドログに特殊なコマンド（##vso[task.logissue]、##vso[task.setvariable]など）を出力することで、エラー/警告の報告、変数の設定、パスの追加などの操作を行う。本スクリプトは、Unix/Linux環境でのCIビルドにおいて、これらのコマンドを正しいフォーマットで生成するユーティリティ関数を提供する。

**バッチの実行タイミング**：他のBashスクリプト（tools.shなど）からsourceコマンドで読み込まれる。CIビルド実行時に間接的に使用される。

**主要な処理内容**：
1. Write-PipelineTelemetryError：テレメトリカテゴリ付きエラー出力
2. Write-PipelineTaskError：タスクエラー/警告の出力（詳細なソース位置情報付き）
3. Write-PipelineSetVariable：パイプライン変数の設定（シークレット対応）
4. Write-PipelinePrependPath：PATHへのディレクトリ追加
5. Write-PipelineSetResult：タスク結果の設定

**前後の処理との関連**：tools.shなどのビルドスクリプトから読み込まれ、ビルドプロセス全体でログ出力に使用される。PowerShell版と同等の機能を提供し、クロスプラットフォーム対応を実現。

**影響範囲**：Azure Pipelinesのビルドログ、パイプライン変数、PATH環境変数、ビルド結果ステータスに影響を与える。

## バッチ種別

ユーティリティライブラリ / ログ出力支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトからのsource時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | sourceコマンドでの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| $ci変数の設定 | CI環境では`ci=true`が設定されていること |
| Bash互換シェル | Bash互換のシェル環境で実行されること |
| Azure Pipelinesエージェント | ##vso[...]コマンドを解釈するエージェント上で実行されること |

### 実行可否判定

関数呼び出し時に$ci変数をチェック。CI環境（ci=true）の場合のみAzure Pipelines形式で出力。それ以外の場合は標準エラー出力（>&2）または標準出力に通常メッセージを出力。-forceオプションで強制的にパイプライン形式を使用可能。

## 入力仕様

### 入力パラメータ

#### Write-PipelineTelemetryError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -category / -c | string | Yes | - | テレメトリカテゴリ |
| -force / -f | switch | No | false | 非CI環境でも強制出力 |
| (残り引数) | string | Yes | - | エラーメッセージ |

#### Write-PipelineTaskError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -type / -t | string | No | 'error' | メッセージタイプ |
| -sourcepath / -s | string | No | - | ソースファイルパス |
| -linenumber / -ln | string | No | - | 行番号 |
| -columnnumber / -cn | string | No | - | 列番号 |
| -errcode / -e | string | No | - | エラーコード |
| -force / -f | switch | No | false | 非CI環境でも強制出力 |
| (残り引数) | string | Yes | - | エラーメッセージ |

#### Write-PipelineSetVariable

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -name / -n | string | Yes | - | 変数名 |
| -value / -v | string | No | - | 変数値 |
| -secret / -s | switch | No | false | シークレット変数として設定 |
| -as_output / -a | switch | No | false | 出力として返す |
| -is_multi_job_variable / -i | bool | No | true | 複数ジョブ間で共有 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 関数引数 | Bashオプション | 呼び出し元からの引数 |
| $ci変数 | string | CI環境フラグ（"true"/"false"） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（echo） | テキスト | ##vso[...]形式のログコマンド |
| 標準エラー出力（>&2） | テキスト | 非CI環境でのエラーメッセージ |
| PATH環境変数 | 環境変数 | Write-PipelinePrependPathで更新 |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 関数呼び出し
   └─ Write-PipelineTelemetryError / Write-PipelineTaskError / など
2. 引数解析
   └─ whileループで各オプションを処理
   └─ 大文字小文字を区別しない（tr "[:upper:]" "[:lower:]"）
3. CI環境判定
   └─ $ci変数と-forceオプションをチェック
4. [CI環境の場合]
   └─ 4.1 値のエスケープ処理（;→%3B、\r→%0D、\n→%0A、]→%5D）
   └─ 4.2 ##vso[...]形式のコマンド文字列を構築
   └─ 4.3 echoで出力
5. [非CI環境の場合]
   └─ 5.1 標準エラー出力にメッセージを出力
```

### フローチャート

```mermaid
flowchart TD
    A[関数呼び出し] --> B[引数解析]
    B --> C{$ci == true または -force?}
    C -->|Yes| D[値のエスケープ処理]
    D --> E[##vso[...] 文字列構築]
    E --> F[echo出力]
    C -->|No| G[echo メッセージ >&2]
    F --> H[終了]
    G --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パラメータ不足 | 必須パラメータが未指定 | 必須パラメータを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（ライブラリ関数） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

ログ出力の失敗は通常致命的ではない。呼び出し元スクリプトのエラーハンドリングに従う。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 多数（ビルド中に頻繁に呼び出し） |
| 目標処理時間 | 1ミリ秒以下/呼び出し |
| メモリ使用量上限 | 最小限 |

## 排他制御

標準出力/標準エラー出力への書き込みのみであり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | Write-PipelineTaskError呼び出し時 | ##vso[task.logissue type=error;...]メッセージ |
| 警告ログ | Write-PipelineTaskError呼び出し時（type=warning） | ##vso[task.logissue type=warning;...]メッセージ |
| 変数設定 | Write-PipelineSetVariable呼び出し時 | ##vso[task.setvariable variable=名前;isSecret=値;isOutput=値]値 |
| パス追加 | Write-PipelinePrependPath呼び出し時 | ##vso[task.prependpath]パス |
| 結果設定 | Write-PipelineSetResult呼び出し時 | ##vso[task.complete result=結果;]メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー出力 | 発生時 | Azure Pipelinesがビルドログで検知 |
| 警告出力 | 発生時 | Azure Pipelinesがビルドログで検知 |

## 備考

- PowerShell版（pipeline-logging-functions.ps1）と同等の機能をBashで提供
- Write-PipelinePrependPathはPATH環境変数を直接更新する（export PATH="$prepend_path:$PATH"）
- 引数名は大文字小文字を区別しない（--Type と --type は同じ）
- dotnet/arcadeフレームワークの共通スクリプト群の一部
