# バッチ設計書 65-nuget-validation.ps1

## 概要

本ドキュメントは、NuGetパッケージのメタデータ整合性を検証するPowerShellスクリプト `eng/common/post-build/nuget-validation.ps1` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、ビルドで生成されたNuGetパッケージ（.nupkg）のメタデータ情報が、Microsoftの公開基準に準拠しているかを検証する。nuget-verification.ps1を内部的に呼び出し、NuGet.VerifyMicrosoftPackageツールを使用した検証を実行する。

**業務上の目的・背景**：NuGetパッケージをnuget.orgなどの公開リポジトリに公開する前に、パッケージメタデータ（作者情報、ライセンス、著作権表示など）がMicrosoftのガイドラインに準拠していることを確認する必要がある。本バッチは、公開前のゲートキーパーとして機能し、不適切なパッケージの公開を防止する。

**バッチの実行タイミング**：CIパイプラインのポストビルドステージで実行される。ビルド成果物のパッケージ検証フェーズの一部として呼び出される。

**主要な処理内容**：
1. ツール共通設定の読み込み（tools.ps1）
2. パッケージディレクトリ内の全.nupkgファイルを対象に検証
3. nuget-verification.ps1の呼び出しによる実際の検証実行
4. 検証結果のエラー報告

**前後の処理との関連**：ビルド完了後、パッケージ署名前に実行される。検証に失敗した場合、後続の公開処理は実行されない。symbols-validation.ps1やsourcelink-validation.ps1と並行または連続して実行される。

**影響範囲**：パイプラインのビルドステータスに影響。検証失敗時はビルドが失敗となり、パッケージ公開がブロックされる。

## バッチ種別

検証処理 / NuGetパッケージ品質ゲート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプラインのポストビルドステージ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| NuGetパッケージの存在 | 検証対象の.nupkgファイルが指定パスに存在すること |
| ネットワーク接続 | NuGet.VerifyMicrosoftPackageツールのダウンロードのため |
| tools.ps1の存在 | 共通ツールスクリプトが利用可能であること |

### 実行可否判定

PackagesPathパラメータが指定され、対象ディレクトリにパッケージが存在する場合に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PackagesPath | string | Yes | - | 検証対象NuGetパッケージが格納されているディレクトリパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.nupkg | NuGetパッケージ | 検証対象のパッケージファイル群 |
| tools.ps1 | PowerShellスクリプト | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール | テキスト | 検証結果メッセージ |
| Azure Pipelines | テレメトリエラー | NuGetValidationカテゴリのエラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. パラメータ受け取り
   └─ PackagesPath
2. 環境変数設定
   └─ $ci = $true
   └─ $disableConfigureToolsetImport = $true
3. tools.ps1の読み込み
   └─ 共通ユーティリティ関数のインポート
4. nuget-verification.ps1の呼び出し
   └─ ${PackagesPath}\*.nupkgを引数として渡す
5. [成功時]
   └─ 正常終了
6. [失敗時]
   └─ 6.1 スタックトレースの出力
   └─ 6.2 Write-PipelineTelemetryErrorでエラー報告
   └─ 6.3 ExitWithExitCode 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ取得]
    B --> C[$ci = $true設定]
    C --> D[tools.ps1読み込み]
    D --> E[nuget-verification.ps1呼び出し]
    E --> F{成功?}
    F -->|Yes| G[正常終了]
    F -->|No| H[スタックトレース出力]
    H --> I[Write-PipelineTelemetryError]
    I --> J[ExitWithExitCode 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検証失敗 | パッケージメタデータがMicrosoftガイドラインに準拠していない | パッケージのnuspecを修正 |
| 1 | パッケージ不在 | 指定パスにパッケージが存在しない | パッケージパスを確認 |
| 1 | ツールダウンロード失敗 | ネットワークエラーでNuGet.VerifyMicrosoftPackageが取得できない | ネットワーク接続を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. 検証エラーの詳細を確認し、該当するnuspecファイルを修正
2. ローカルでパッケージを再作成して検証
3. 再ビルドを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ビルド毎に数十パッケージ |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 特になし |

## 排他制御

読み取り専用操作であり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 検証中 | 各パッケージの検証状況 |
| エラーログ | 検証失敗時 | スタックトレースとエラー詳細 |
| テレメトリ | 失敗時 | (NETCORE_ENGINEERING_TELEMETRY=NuGetValidation) エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 検証失敗 | 発生時 | Azure Pipelines（ビルド失敗） |

## 備考

- nuget-verification.ps1を内部的に呼び出す薄いラッパースクリプト
- NuGet.VerifyMicrosoftPackageツールを使用（https://github.com/NuGet/NuGetGallery/tree/master/src/VerifyMicrosoftPackage）
- dotnet/arcadeフレームワークの共通スクリプト群の一部
- $ci = $trueを強制設定し、常にCI環境として動作
