# バッチ設計書 66-nuget-verification.ps1

## 概要

本ドキュメントは、NuGetパッケージのメタデータを詳細検証するPowerShellスクリプト `eng/common/post-build/nuget-verification.ps1` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、NuGet.VerifyMicrosoftPackageツールをダウンロードし、指定されたNuGetパッケージのメタデータがMicrosoftの公開基準に準拠しているかを詳細に検証する。nuget.exeとNuGet.VerifyMicrosoftPackageの両方を自動的にダウンロード・管理する機能を含む。

**業務上の目的・背景**：MicrosoftがNuGet.orgに公開するパッケージは、特定のメタデータ要件（著者情報、ライセンス、プロジェクトURL、リポジトリ情報など）を満たす必要がある。本バッチは、NuGetGalleryプロジェクトが提供する公式検証ツールを使用して、これらの要件への準拠を自動的にチェックする。

**バッチの実行タイミング**：nuget-validation.ps1から呼び出されるか、直接実行される。CIパイプラインのポストビルドステージで使用される。

**主要な処理内容**：
1. nuget.exeのダウンロード（未存在の場合）
2. NuGet.VerifyMicrosoftPackageパッケージの取得
3. 最新バージョンの検証ツール特定
4. 指定されたパッケージに対する検証の実行
5. 検証結果の報告

**前後の処理との関連**：nuget-validation.ps1のバックエンド処理として機能する。パッケージ署名・公開前の品質ゲートの一部。

**影響範囲**：検証結果によりビルドステータスに影響。ツールのダウンロードにより一時ディレクトリにファイルが作成される。

## バッチ種別

検証処理 / NuGetパッケージメタデータ詳細検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | nuget-validation.ps1からの呼び出し / 直接実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| インターネット接続 | nuget.exeとNuGet.VerifyMicrosoftPackageのダウンロードのため |
| PowerShell実行環境 | Windows環境でPowerShellが利用可能であること |
| 書き込み権限 | ダウンロードディレクトリへの書き込みが可能であること |

### 実行可否判定

検証対象のパッケージファイルが引数として渡された場合に実行される。--helpオプションでヘルプ表示のみも可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NuGetExePath | string | No | - | nuget.exeのパス。未指定時は自動ダウンロード |
| PackageSource | string | No | https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-public/nuget/v3/index.json | 検証ツールのダウンロード元 |
| DownloadPath | string | No | %TEMP%\NuGet.VerifyMicrosoftPackage | ツールのダウンロード先 |
| args | string[] | No | - | 検証対象パッケージパス（ワイルドカード対応） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.nupkg | NuGetパッケージ | 検証対象のパッケージファイル |
| nuget.exe | 実行ファイル | NuGetクライアント（ダウンロードまたは指定） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール | テキスト | 検証結果メッセージ |
| 終了コード | 整数 | 0:成功、非0:失敗 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | nuget.exe、NuGet.VerifyMicrosoftPackage.* |
| 出力先 | %TEMP%\NuGet.VerifyMicrosoftPackage（デフォルト） |
| 文字コード | - |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. パラメータ解析
   └─ NuGetExePath、PackageSource、DownloadPath、args
2. ダウンロードディレクトリ作成
   └─ 存在しない場合は新規作成
3. nuget.exe準備
   └─ 3.1 NuGetExePathが指定されている場合はそれを使用
   └─ 3.2 未指定かつ未ダウンロードの場合はダウンロード
   └─ 3.3 ダウンロードURL: https://dist.nuget.org/win-x86-commandline/v4.9.4/nuget.exe
4. NuGet.VerifyMicrosoftPackageのインストール
   └─ 4.1 nuget installコマンドで最新プレリリース版を取得
   └─ 4.2 ダウンロードディレクトリに展開
5. 最新ツールの特定
   └─ 5.1 NuGet.VerifyMicrosoftPackage.*ディレクトリを検索
   └─ 5.2 LastWriteTimeでソートして最新を選択
6. 検証ツール実行
   └─ 6.1 tools\NuGet.VerifyMicrosoftPackage.exeを実行
   └─ 6.2 引数として渡されたパッケージを検証
7. 結果報告
   └─ 7.1 終了コード0の場合："The verify tool succeeded."
   └─ 7.2 終了コード非0の場合："The verify tool found some problems."
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ解析]
    B --> C[ダウンロードディレクトリ作成]
    C --> D{NuGetExePath指定?}
    D -->|Yes| E[指定パスを使用]
    D -->|No| F{nuget.exe存在?}
    F -->|Yes| E
    F -->|No| G[nuget.exeダウンロード]
    G --> E
    E --> H[NuGet.VerifyMicrosoftPackageインストール]
    H --> I{インストール成功?}
    I -->|No| J[エラー終了]
    I -->|Yes| K[最新ツール特定]
    K --> L[検証ツール実行]
    L --> M{終了コード == 0?}
    M -->|Yes| N[成功メッセージ]
    M -->|No| O[エラーメッセージ]
    N --> P[終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | nuget.exeダウンロード失敗 | ネットワークエラー | ネットワーク接続を確認 |
| 非0 | ツールフェッチ失敗 | nuget installが失敗 | パッケージソースを確認 |
| 非0 | 検証失敗 | パッケージメタデータが要件を満たさない | nuspecを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ネットワーク接続を確認
2. 手動でNuGet.VerifyMicrosoftPackageをインストールして実行
3. パッケージのnuspecを確認して修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十パッケージ/実行 |
| 目標処理時間 | 5分以内（初回ダウンロード含む） |
| メモリ使用量上限 | 特になし |

## 排他制御

同時実行時にダウンロードディレクトリへの書き込み競合が発生する可能性がある。ただし、通常はビルドごとに独立したディレクトリを使用するため問題にならない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Using download path: {path}" |
| 進捗ログ | ダウンロード時 | "Downloading nuget.exe from {url}..." |
| 進捗ログ | インストール時 | "Downloading the latest version of {packageId}..." |
| 進捗ログ | 検証開始時 | "Executing the verify tool..." |
| 成功ログ | 成功時 | "The verify tool succeeded." |
| エラーログ | 失敗時 | "The verify tool found some problems." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 検証失敗 | 発生時 | 呼び出し元スクリプト経由 |

## 備考

- NuGetGalleryプロジェクトから移植されたスクリプト（https://github.com/NuGet/NuGetGallery/blob/3e25ad135146676bcab0050a516939d9958bfa5d/src/VerifyMicrosoftPackage/verify.ps1）
- nuget.exe v4.9.4を使用
- プレリリース版のNuGet.VerifyMicrosoftPackageを取得
- 視覚的な区切り線（====...）を使用してログの可読性を向上
- dotnet/arcadeフレームワークの共通スクリプト群の一部
