# バッチ設計書 69-check-channel-consistency.ps1

## 概要

本ドキュメントは、Maestroのデフォルトチャネル設定とYAMLパイプライン設定の整合性を検証するPowerShellスクリプト `eng/common/post-build/check-channel-consistency.ps1` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Maestro（dotnet/arcadeのビルド公開オーケストレーター）がビルドを公開するよう指示したチャネルが、YAMLパイプライン設定で定義されているチャネルと一致しているかを検証する。不整合がある場合、パッケージ公開が正しく行われない可能性があるため、事前に検出してエラーを報告する。

**業務上の目的・背景**：dotnet/arcadeのビルドシステムでは、ビルド成果物の公開先チャネル（安定版、プレビュー版、内部版など）をMaestroが管理する。パイプラインのYAML設定とMaestroの設定が同期していないと、意図しないチャネルへの公開や公開漏れが発生する。本バッチは、この設定の不整合を検出する品質ゲートとして機能する。

**バッチの実行タイミング**：CIパイプラインのポストビルドステージで、パッケージ公開処理前に実行される。

**主要な処理内容**：
1. PromoteToChannelsパラメータから公開対象チャネルIDを抽出
2. AvailableChannelIdsパラメータで定義されたチャネルと比較
3. 未定義チャネルの検出とエラー報告
4. 整合性確認結果の報告

**前後の処理との関連**：publish-using-darc.ps1やその他の公開処理の前に実行される。整合性エラーがある場合、後続の公開処理は実行されない。

**影響範囲**：パイプラインのビルドステータスに影響。整合性エラーが検出された場合、ビルドが失敗する。

## バッチ種別

検証処理 / チャネル設定整合性チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプラインのポストビルドステージ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Maestro設定 | ビルドのデフォルトチャネルがMaestroで設定されていること |
| YAML設定 | パイプラインのYAMLファイルで公開チャネルが定義されていること |

### 実行可否判定

PromoteToChannelsが空文字列の場合、警告メッセージを出力して正常終了（ExitWithExitCode 0）。チャネルが指定されている場合は検証を実行。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PromoteToChannels | string | Yes | - | Maestroから渡される公開対象チャネルIDのリスト |
| AvailableChannelIds | array | Yes | - | YAMLパイプラインで定義されている利用可能チャネルIDの配列 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Maestro設定 | 文字列（チャネルID一覧） | ビルドの公開対象チャネル |
| YAML設定 | 配列 | パイプラインで対応しているチャネル |
| tools.ps1 | PowerShellスクリプト | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール | テキスト | 検証結果メッセージ |
| Azure Pipelines | テレメトリエラー | CheckChannelConsistencyカテゴリのエラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. パラメータ受け取り
   └─ PromoteToChannels、AvailableChannelIds
2. 環境変数設定
   └─ $ci = $true
   └─ $disableConfigureToolsetImport = $true
   └─ $ErrorActionPreference = 'Stop'
   └─ Set-StrictMode -Version 2.0
3. tools.ps1の読み込み
   └─ 共通ユーティリティ関数のインポート
4. PromoteToChannels空チェック
   └─ 4.1 空の場合：警告メッセージ出力して正常終了
   └─ 4.2 空でない場合：検証続行
5. チャネルIDの抽出
   └─ PromoteToChannelsから数字以外で分割してID一覧を取得
6. 各チャネルIDの検証
   └─ 6.1 ID != 0 かつ AvailableChannelIdsに含まれていないかチェック
   └─ 6.2 未定義チャネル発見時：エラーメッセージ出力、$hasErrors = $true
7. 最終結果判定
   └─ 7.1 $hasErrors == $true：ExitWithExitCode 1
   └─ 7.2 $hasErrors == $false："done."出力して正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ取得]
    B --> C[$ci = $true設定]
    C --> D[tools.ps1読み込み]
    D --> E{PromoteToChannels空?}
    E -->|Yes| F[警告メッセージ出力]
    F --> G[ExitWithExitCode 0]
    E -->|No| H[チャネルID抽出]
    H --> I[チャネルループ]
    I --> J{ID != 0 かつ 未定義?}
    J -->|Yes| K[エラーメッセージ出力]
    K --> L[$hasErrors = $true]
    J -->|No| M[次のチャネル]
    L --> M
    M --> I
    I -->|終了| N{$hasErrors?}
    N -->|Yes| O[ExitWithExitCode 1]
    N -->|No| P["done."出力]
    P --> Q[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | チャネル未定義 | MaestroのチャネルがYAMLで定義されていない | YAMLにチャネル定義を追加するか、@dncengに連絡 |
| 1 | 例外発生 | スクリプト実行中の予期しないエラー | エラーメッセージを確認して対処 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージで問題のチャネルIDを特定
2. azure-pipelines.ymlのチャネル設定を確認
3. Maestroのデフォルトチャネル設定を確認
4. 必要に応じて@dncengチームに連絡

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数個のチャネルID |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用の検証処理であり、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | チャネル未設定時 | "This build won't publish assets as it's not configured to any Maestro channel..." |
| エラーログ | チャネル未定義時 | "Channel {id} is not present in the post-build YAML configuration!" |
| 成功ログ | 検証成功時 | "done." |
| テレメトリ | 例外発生時 | (NETCORE_ENGINEERING_TELEMETRY=CheckChannelConsistency) エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| チャネル整合性エラー | 1件以上 | Azure Pipelines（ビルド失敗） |

## 備考

- Maestroについては https://github.com/dotnet/arcade/blob/main/Documentation/Darc.md を参照
- チャネル未設定の場合の警告メッセージで、darcのadd-default-channelコマンドへの誘導を含む
- チャネルID 0は除外して検証（無効なIDとして扱う）
- PromoteToChannelsは数字以外の文字で分割される（スペース、カンマなど区切り文字に依存しない）
- dotnet/arcadeフレームワークの共通スクリプト群の一部
