# バッチ設計書 7-Test.cmd

## 概要

本ドキュメントは、RoslynプロジェクトのWindows環境向けユニットテスト実行エントリーポイントスクリプト「Test.cmd」の設計仕様を記載する。

### 本バッチの処理概要

Test.cmdは、Windows環境においてRoslynプロジェクトのユニットテストを実行するためのコマンドラインエントリーポイントである。

**業務上の目的・背景**：Roslynコンパイラの開発において、コードの品質を担保するためのユニットテスト実行手段を提供する。開発者がローカル環境で迅速にテストを実行できるようにし、コード変更の影響を即座に検証可能にする。CI/CDパイプラインとの一貫性を保ちながら、開発者フレンドリーなテスト実行を実現する。

**バッチの実行タイミング**：開発者による手動実行（コード変更後の検証時）、CI/CDパイプラインでのテストフェーズ。ビルド完了後に実行されることが多い。

**主要な処理内容**：
1. PowerShellの実行ポリシーをByPassに設定し、プロファイルなしでPowerShellを起動
2. eng/build.ps1スクリプトに-testオプションを付与して呼び出し
3. コマンドライン引数をそのままeng/build.ps1に渡す

**前後の処理との関連**：Build.cmdによるビルド完了後に実行される。eng/build.ps1の-testオプションはTestUsingRunTests関数を通じてRunTests.dllを使用してテストを実行する。

**影響範囲**：テスト結果（artifacts/TestResults）、テストログ（artifacts/log）に影響を与える。ビルド成果物自体は変更しない。

## バッチ種別

テスト処理（ユニットテスト実行）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境でのみ実行可能 |
| PowerShell | PowerShell 5.0以上がインストールされていること |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| ビルド完了 | テスト対象のバイナリがビルド済みであること |

### 実行可否判定

特別な判定ロジックはなく、前提条件が満たされていれば実行可能。RunTests.dllが存在しない場合はeng/build.ps1側でエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | eng/build.ps1に渡される追加パラメータ（-configuration, -testCoreClr等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| artifacts/bin/RunTests | DLL | テストランナー |
| artifacts/bin/*UnitTests | DLL | テストアセンブリ群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/TestResults | trx/html | テスト結果ファイル |
| artifacts/log | txt/log | テストログ |
| 標準出力 | テキスト | テスト進捗・結果サマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各テストプロジェクト名.trx |
| 出力先 | artifacts/TestResults |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンドプロンプトからTest.cmdを実行
   └─ コマンドライン引数を受け取る
2. PowerShellを起動
   └─ ExecutionPolicy: ByPass, NoProfile設定
3. eng/build.ps1を-testオプション付きで呼び出し
   └─ 追加のコマンドライン引数を渡す
4. テスト結果を標準出力に表示
   └─ 終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Test.cmd実行] --> B[PowerShell起動]
    B --> C[eng/build.ps1呼び出し]
    C --> D{-testオプション付与}
    D --> E[追加引数を渡す]
    E --> F[TestUsingRunTests実行]
    F --> G[RunTests.dll実行]
    G --> H[テスト結果出力]
    H --> I[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | RunTests未ビルド | RunTests.dllが存在しない | Build.cmdを先に実行 |
| 非0 | テスト失敗 | 1つ以上のテストが失敗 | テスト結果を確認し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. 標準出力/標準エラー出力のログを確認
3. artifacts/TestResults配下のtrxファイルを確認
4. 失敗したテストを特定し、コードを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万のテストケース |
| 目標処理時間 | 環境依存（通常30-60分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

xUnitテストランナーは複数のテストを並列実行する。--sequentialオプションで順次実行に切り替え可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | テスト中 | テスト進捗 |
| trxファイル | テスト完了時 | 詳細なテスト結果 |
| htmlレポート | テスト完了時 | 視覚的なテスト結果（非CI時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDパイプライン |
| テスト失敗数 | 1以上 | CI/CDパイプライン |

## 備考

- 本バッチはeng/build.ps1への薄いラッパーであり、-testオプションに相当
- 実際には-testDesktopオプションが使用される（eng/build.ps1内でのエイリアス）
- Unix環境ではtest.shを使用すること
- ビルドが完了していない場合は先にBuild.cmdを実行する必要がある
