# バッチ設計書 70-publish-using-darc.ps1

## 概要

本ドキュメントは、Darcツールを使用してビルド成果物をデフォルトチャネルに公開するPowerShellスクリプト `eng/common/post-build/publish-using-darc.ps1` の設計仕様を定義する。

### 本バッチの処理概要

このバッチは、Darc（Dependency Analysis and Release Controller）CLIツールを使用して、ビルド成果物をMaestroで管理されているデフォルトチャネルに公開する。公開処理にはNuGetパッケージ、シンボル、その他の成果物が含まれ、指定されたPublishing Infraバージョンに基づいて処理される。

**業務上の目的・背景**：dotnet/arcadeのビルドシステムでは、ビルド成果物の公開（NuGet.orgへのパッケージ公開、シンボルサーバーへのアップロードなど）をMaestroサービスがオーケストレーションする。本バッチは、Darcコマンドを通じてMaestroに公開を指示し、ビルドをデフォルトチャネルに追加する中心的な処理を担う。

**バッチの実行タイミング**：CIパイプラインのポストビルドステージの最終段階で、すべての検証（nuget-validation、symbols-validation、sourcelink-validation、check-channel-consistency）が完了した後に実行される。

**主要な処理内容**：
1. Darcツールの取得（tools.ps1のGet-Darc関数）
2. オプショナルパラメータの構築
3. darc add-build-to-channelコマンドの実行
4. 公開処理の完了待機（オプション）
5. 結果の報告

**前後の処理との関連**：check-channel-consistency.ps1や各種検証スクリプトの後に実行される。本バッチが成功すると、ビルド成果物がMaestroを通じて各種フィード（nuget.org、シンボルサーバーなど）に公開される。

**影響範囲**：NuGetパッケージの公開、シンボルファイルの公開、Maestroのビルドレコード更新。公開後は外部ユーザーからアクセス可能になる。

## バッチ種別

公開処理 / Maestro経由のビルド成果物公開

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプラインのポストビルドステージ（最終段階） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Darcツールが利用可能 | tools.ps1のGet-Darc関数でDarcが取得できること |
| Azure DevOpsトークン | 有効なAzure DevOps PATが提供されていること |
| Maestro接続 | Maestro APIエンドポイントにアクセス可能であること |
| 検証完了 | 各種検証スクリプトが正常終了していること |

### 実行可否判定

必須パラメータ（BuildId、PublishingInfraVersion、AzdoToken、WaitPublishingFinish）が提供されている場合に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BuildId | int | Yes | - | 公開対象のビルドID |
| PublishingInfraVersion | int | Yes | - | 使用するPublishing Infraのバージョン |
| AzdoToken | string | Yes | - | Azure DevOps Personal Access Token |
| MaestroApiEndPoint | string | No | https://maestro.dot.net | Maestro APIのエンドポイントURL |
| WaitPublishingFinish | string | Yes | - | 公開完了を待機するか（"true"/"false"） |
| ArtifactsPublishingAdditionalParameters | string | No | - | 成果物公開の追加パラメータ |
| SymbolPublishingAdditionalParameters | string | No | - | シンボル公開の追加パラメータ |
| RequireDefaultChannels | string | No | - | デフォルトチャネル必須フラグ（"true"/"false"） |
| SkipAssetsPublishing | string | No | - | 成果物公開をスキップ（"true"/"false"） |
| runtimeSourceFeed | string | No | - | ランタイムソースフィード |
| runtimeSourceFeedKey | string | No | - | ランタイムソースフィードキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドラインパラメータ | PowerShell引数 | 上記パラメータ |
| Darcツール | 実行ファイル | tools.ps1経由で取得 |
| tools.ps1 | PowerShellスクリプト | 共通ユーティリティ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Maestro | API呼び出し | ビルドのチャネル追加 |
| コンソール | テキスト | 処理結果メッセージ |
| Azure Pipelines | テレメトリエラー | PromoteBuildカテゴリのエラー |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 環境変数設定
   └─ $ci = $true
   └─ $disableConfigureToolsetImport = $true
2. tools.ps1の読み込み
   └─ 共通ユーティリティ関数のインポート
3. Darcツールの取得
   └─ Get-Darc関数呼び出し
4. オプショナルパラメータの構築
   └─ 4.1 ArtifactsPublishingAdditionalParameters設定
   └─ 4.2 SymbolPublishingAdditionalParameters設定
   └─ 4.3 WaitPublishingFinish="false"の場合 --no-wait追加
   └─ 4.4 RequireDefaultChannels="true"の場合 --default-channels-required追加
   └─ 4.5 SkipAssetsPublishing="true"の場合 --skip-assets-publishing追加
5. darc add-build-to-channel実行
   └─ --id $BuildId
   └─ --publishing-infra-version $PublishingInfraVersion
   └─ --default-channels
   └─ --source-branch main
   └─ --azdev-pat "$AzdoToken"
   └─ --bar-uri "$MaestroApiEndPoint"
   └─ --ci --verbose
   └─ @optionalParams
6. 終了コード確認
   └─ 6.1 0以外：エラーメッセージ出力してexit 1
   └─ 6.2 0："done."出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[$ci = $true設定]
    B --> C[tools.ps1読み込み]
    C --> D[Get-DarcでDarc取得]
    D --> E[オプションパラメータ構築]
    E --> F{ArtifactsPublishingParams?}
    F -->|Yes| G[--artifact-publishing-parameters追加]
    F -->|No| H{SymbolPublishingParams?}
    G --> H
    H -->|Yes| I[--symbol-publishing-parameters追加]
    H -->|No| J{WaitPublishingFinish == false?}
    I --> J
    J -->|Yes| K[--no-wait追加]
    J -->|No| L{RequireDefaultChannels == true?}
    K --> L
    L -->|Yes| M[--default-channels-required追加]
    L -->|No| N{SkipAssetsPublishing == true?}
    M --> N
    N -->|Yes| O[--skip-assets-publishing追加]
    N -->|No| P[darc add-build-to-channel実行]
    O --> P
    P --> Q{LastExitCode == 0?}
    Q -->|No| R[エラー出力 exit 1]
    Q -->|Yes| S["done."出力]
    S --> T[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチは直接的なデータベース操作を行わない。MaestroのAPIを通じてビルドレコードが更新される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Darcコマンド失敗 | darc add-build-to-channelが非0で終了 | Darcのログを確認、パラメータを検証 |
| 1 | 例外発生 | スクリプト実行中の予期しないエラー | エラーメッセージを確認して対処 |
| 1 | Maestro接続失敗 | Maestro APIへのアクセスが失敗 | ネットワーク接続とトークンを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（スクリプトレベルではリトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. Darcコマンドのログを確認
2. Azure DevOpsトークンの有効期限と権限を確認
3. Maestro APIの状態を確認
4. 必要に応じて手動でdarcコマンドを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Darc/Maestro側で管理 |
| コミットタイミング | 公開処理完了時 |
| ロールバック条件 | 公開処理失敗時（Maestro側で管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | WaitPublishingFinishに依存（数分〜数時間） |
| メモリ使用量上限 | 特になし |

## 排他制御

同一ビルドIDに対する重複公開はMaestro側で制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | Darc実行中 | --verboseオプションによる詳細ログ |
| 成功ログ | 成功時 | "done." |
| エラーログ | Darc失敗時 | "Problems using Darc to promote build ${buildId} to default channels. Stopping execution..." |
| テレメトリ | 例外発生時 | (NETCORE_ENGINEERING_TELEMETRY=PromoteBuild) エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 公開失敗 | 発生時 | Azure Pipelines（ビルド失敗） |

## 備考

- Darcについては https://github.com/dotnet/arcade/blob/main/Documentation/Darc.md を参照
- --source-branch mainがハードコードされている
- --ciフラグによりCI環境向けの動作（非対話モード）
- --verboseフラグにより詳細なログ出力
- WaitPublishingFinish="false"の場合、公開処理の完了を待たずに終了（非同期公開）
- 公開処理自体はMaestroサービスが非同期で実行
- dotnet/arcadeフレームワークの共通スクリプト群の一部
