# バッチ設計書 71-redact-logs

## 概要

本ドキュメントは、`eng/common/post-build/redact-logs.ps1`スクリプトのバッチ設計書です。このスクリプトは、ビルドログから機密情報を編集・削除するためのPowerShellスクリプトです。

### 本バッチの処理概要

本バッチは、ビルドプロセスで生成されるバイナリログ（binlog）ファイルから、認証トークンやAPIキーなどの機密情報を自動的に検出し、編集（redaction）する処理を実行します。

**業務上の目的・背景**：CIパイプラインにおいて、ビルドログは公開されたり、長期保存されたりすることがあります。これらのログには、Azure DevOpsの変数やNuGetフィードの認証情報など、機密性の高い情報が含まれている可能性があります。本バッチは、これらの機密情報がログに残ることを防ぎ、セキュリティリスクを軽減するために必要です。

**バッチの実行タイミング**：ビルド完了後のポストビルドフェーズで実行されます。通常はCIパイプラインの一部として自動的に呼び出されます。

**主要な処理内容**：
1. dotnet CLIの初期化とBinlog redactorツールのインストール
2. 編集対象トークンの収集（コマンドラインパラメータおよびファイルから）
3. Azure DevOps変数形式のトークンの除外（未展開の変数を無視）
4. binlogtoolを使用したログファイルの編集処理

**前後の処理との関連**：ビルド処理（eng/build.ps1等）の完了後に実行されます。公開処理（publish-assets.ps1等）の前に実行することで、公開前にログから機密情報を除去します。

**影響範囲**：指定されたパス配下のすべてのbinlogファイルに影響します。編集は元のファイルを直接変更します（--in-placeオプション）。

## バッチ種別

データクレンジング / セキュリティ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド完了後） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン（ポストビルドフェーズ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| dotnet CLI | .NET SDKがインストールされているか、DotnetPathパラメータで指定されていること |
| ネットワーク接続 | binlogtoolをNuGetフィードからダウンロードするため |
| binlogファイル | 編集対象のbinlogファイルが存在すること |

### 実行可否判定

InputPathで指定されたパスにbinlogファイルが存在する場合に処理を実行します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | - | 編集対象のbinlogファイルまたはディレクトリのパス |
| BinlogToolVersion | string | Yes | - | binlogtoolのバージョン |
| DotnetPath | string | No | - | dotnet CLIの実行パス |
| PackageFeed | string | No | https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-public/nuget/v3/index.json | binlogtoolを取得するNuGetフィードURL |
| TokensFilePath | string | No | - | 編集対象トークンを含むファイルのパス |
| TokensToRedact | String[] | No | - | 編集対象のトークン配列 |
| runtimeSourceFeed | string | No | - | ランタイムソースフィードURL |
| runtimeSourceFeedKey | string | No | - | ランタイムソースフィードの認証キー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| binlogファイル | バイナリ | MSBuildバイナリログファイル |
| TokensFilePath | テキスト | 改行区切りのトークンファイル（#で始まる行はコメント） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| binlogファイル（上書き） | バイナリ | 機密情報が編集されたログファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ（元ファイルを上書き） |
| 出力先 | InputPathで指定された場所 |
| 文字コード | バイナリ形式 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ tools.ps1の読み込み、CI環境変数の設定
2. dotnet CLIの準備
   └─ DotnetPathが指定されていない場合はInitializeDotNetCliを使用
3. 既存ツールのアンインストール
   └─ グローバルにインストールされているbinlogtoolを削除
4. ツールのインストール
   └─ ローカルにbinlogtoolをインストール
5. トークンの収集
   └─ TokensFilePathからトークンを読み込み、TokensToRedactと結合
6. AzDO変数のフィルタリング
   └─ $(...)形式の未展開変数を除外
7. ログ編集の実行
   └─ binlogtool redactコマンドで編集処理
8. 完了処理
   └─ エラー処理とクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C{DotnetPath指定?}
    C -->|Yes| D[指定パス使用]
    C -->|No| E[InitializeDotNetCli]
    D --> F[既存ツールアンインストール]
    E --> F
    F --> G[binlogtoolインストール]
    G --> H{TokensFilePath存在?}
    H -->|Yes| I[ファイルからトークン読み込み]
    H -->|No| J[パラメータトークンのみ使用]
    I --> K[AzDO変数フィルタリング]
    J --> K
    K --> L[binlogtool redact実行]
    L --> M{成功?}
    M -->|Yes| N[正常終了]
    M -->|No| O[警告出力]
    O --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Redactor | binlogtool redact実行失敗 | 警告として出力し処理継続 |
| 1 | Redactor | 致命的エラー | エラーメッセージを出力して終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

binlogtool実行失敗時は警告として記録されますが、パイプラインは継続されます。ログから機密情報が完全に除去されていない可能性があるため、手動での確認が推奨されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ビルド成果物に応じた複数binlogファイル |
| 目標処理時間 | ファイルサイズに依存 |
| メモリ使用量上限 | 制限なし |

## 排他制御

同時実行は想定されていません。同一binlogファイルへの同時アクセスは避けてください。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ツールインストール時 | "Installing Binlog redactor CLI..." |
| 進捗ログ | トークンフィルタリング時 | 無視されたAzDO変数 |
| 終了ログ | 処理完了時 | "done." |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによるエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | Azure DevOps Pipeline |

## 備考

- binlogtoolはMicrosoftが提供するバイナリログ操作ツールです
- トークンファイル内の「# 」で始まる行はコメントとして無視されます
- 未展開のAzure DevOps変数（$(...）形式）は自動的にスキップされます
