# バッチ設計書 72-build-rootfs

## 概要

本ドキュメントは、`eng/common/cross/build-rootfs.sh`スクリプトのバッチ設計書です。このスクリプトは、クロスコンパイル用のLinux rootfs（ルートファイルシステム）を構築するためのBashスクリプトです。

### 本バッチの処理概要

本バッチは、異なるCPUアーキテクチャやLinuxディストリビューション向けのクロスコンパイル環境を構築するために、必要なシステムライブラリとヘッダファイルを含むrootfsを生成します。

**業務上の目的・背景**：.NETランタイムやRoslynコンパイラは、複数のプラットフォーム（arm、arm64、x64など）とOS（Ubuntu、Alpine、FreeBSD、Tizenなど）をサポートする必要があります。開発マシンとは異なるアーキテクチャ向けにビルドするためには、ターゲットプラットフォームのシステムライブラリを含むrootfsが必要です。本バッチは、この環境を自動的に構築することで、クロスコンパイルワークフローを効率化します。

**バッチの実行タイミング**：新しいターゲットプラットフォーム向けのビルド環境を構築する際に手動で実行されます。通常は開発環境のセットアップ時やCI環境の初期化時に実行されます。

**主要な処理内容**：
1. ターゲットアーキテクチャとディストリビューションの解析
2. 必要なパッケージリストの構成
3. rootfsディレクトリの作成と初期化
4. パッケージのダウンロードとインストール
5. シンボリックリンクの修正とクリーンアップ

**前後の処理との関連**：本バッチで生成されたrootfsは、クロスコンパイルビルド（build.sh --cross）で使用されます。ROOTFS_DIR環境変数を通じてビルドシステムに参照されます。

**影響範囲**：.tools/rootfs/配下に新しいrootfsディレクトリを作成します。既存のrootfsがある場合は削除されて再作成されます。

## バッチ種別

環境構築 / クロスコンパイル準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（環境構築時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| root権限 | debootstrap使用時はroot権限が必要（--skipemulationオプション使用時は不要） |
| ネットワーク接続 | パッケージリポジトリへのアクセス |
| 必要ツール | wget または curl、debootstrap（Debian系）、qemu-user-static（エミュレーション使用時） |

### 実行可否判定

指定されたターゲットアーキテクチャとディストリビューションがサポートされている場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BuildArch | string | No | arm | ターゲットアーキテクチャ（arm, arm64, armel, armv6, loongarch64, ppc64le, riscv64, s390x, x64, x86） |
| CodeName | string | No | xenial | Linuxディストリビューションコード名（xenial, bionic, focal, jammy, noble, alpine, freebsd13/14, illumos, haiku） |
| lldb | string | No | lldb3.9 | LLDBバージョン（lldb3.9, lldb4.0, lldb5.0, lldb6.0, no-lldb） |
| llvm | string | No | - | LLVMバージョン |
| --skipunmount | flag | No | false | rootfsフォルダのアンマウントをスキップ |
| --skipsigcheck | flag | No | false | パッケージ署名チェックをスキップ |
| --skipemulation | flag | No | false | qemuエミュレーションをスキップ（Python/install-debs.pyを使用） |
| --rootfsdir | string | No | 自動生成 | rootfsの出力ディレクトリ |
| --use-mirror | flag | No | false | ミラーURLを使用 |
| --use-jobs | number | No | 自動 | 並列ジョブ数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| パッケージリポジトリ | HTTP | Ubuntu/Debian/Alpine等のパッケージリポジトリ |
| GPGキー | テキスト | パッケージ署名検証用の公開鍵（スクリプト内に埋め込み） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| rootfsディレクトリ | ディレクトリ | クロスコンパイル用のシステムルート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | ${BuildArch}（例：arm64） |
| 出力先 | .tools/rootfs/${BuildArch} または ROOTFS_DIR |
| 内容 | /usr/include, /usr/lib, /lib 等のシステムディレクトリ |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ アーキテクチャ、ディストリビューション、オプションの解析
2. パッケージリスト構成
   └─ ターゲットに応じた必要パッケージの決定
3. 既存rootfsの削除
   └─ 既存ディレクトリのアンマウントと削除
4. rootfsディレクトリ作成
   └─ 新規ディレクトリの作成
5. ディストリビューション別処理
   ├─ Alpine: apk-tools使用
   ├─ FreeBSD: pkg使用
   ├─ illumos: binutils/gcc構築
   ├─ Haiku: hpkg使用
   ├─ Tizen: tizen-build-rootfs.sh呼び出し
   └─ Debian/Ubuntu: debootstrapまたはinstall-debs.py使用
6. 後処理
   └─ シンボリックリンク修正、クリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[パッケージリスト構成]
    C --> D{既存rootfs存在?}
    D -->|Yes| E[アンマウント・削除]
    D -->|No| F[rootfsディレクトリ作成]
    E --> F
    F --> G{CodeName判定}
    G -->|alpine| H[apk-tools処理]
    G -->|freebsd| I[FreeBSD pkg処理]
    G -->|illumos| J[illumos sysroot構築]
    G -->|haiku| K[Haiku hpkg処理]
    G -->|tizen| L[tizen-build-rootfs.sh]
    G -->|debian/ubuntu| M{skipemulation?}
    M -->|Yes| N[install-debs.py]
    M -->|No| O[debootstrap]
    H --> P[完了]
    I --> P
    J --> P
    K --> P
    L --> P
    N --> P
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | wgetもcurlも利用不可 | ツールのインストール |
| 1 | ダウンロードエラー | パッケージのダウンロード失敗 | ネットワーク確認、ミラー使用 |
| 1 | debootstrapエラー | debootstrap実行失敗 | debootstrap.logを確認 |
| 1 | 引数エラー | 未サポートのアーキテクチャ/ディストリビューション | 使用方法を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

失敗時はrootfsディレクトリが不完全な状態で残る可能性があります。再実行前に該当ディレクトリを手動で削除することを推奨します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 rootfs |
| 目標処理時間 | 数分〜数十分（ネットワーク速度とターゲットに依存） |
| メモリ使用量上限 | 制限なし |
| ディスク使用量 | 数百MB〜数GB（ターゲットに依存） |

## 排他制御

同一rootfsディレクトリへの同時実行は想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | パッケージインストール時 | ダウンロード・インストール状況 |
| エラーログ | エラー発生時 | エラーメッセージ、debootstrap.log |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- Alpine Linux用のGPGキーがスクリプト内にハードコードされています
- FreeBSD向けにはpkgパッケージマネージャをソースからビルドします
- illumos向けにはgccとbinutilsをソースからビルドするため、処理時間が長くなります
- --skipemulationオプションを使用すると、Python/install-debs.pyによる高速なインストールが可能です
- サポートされるアーキテクチャ：arm, arm64, armel, armv6, loongarch64, ppc64le, riscv64, s390x, x64, x86
