# バッチ設計書 73-build-android-rootfs

## 概要

本ドキュメントは、`eng/common/cross/build-android-rootfs.sh`スクリプトのバッチ設計書です。このスクリプトは、Android向けクロスコンパイル用のツールチェーンとsysrootを構築するためのBashスクリプトです。

### 本バッチの処理概要

本バッチは、Android NDKをダウンロードし、Termuxリポジトリから必要なパッケージを取得して、Android向けの.NETランタイムをクロスコンパイルするための環境を構築します。

**業務上の目的・背景**：.NETランタイムをAndroidデバイス上で動作させるためには、Android NDK（Native Development Kit）を使用したクロスコンパイルが必要です。本バッチは、必要なNDK、LLDB、および依存ライブラリ（ICU、OpenSSL、Kerberos等）を自動的にダウンロード・設定することで、Android向けビルド環境の構築を自動化します。

**バッチの実行タイミング**：Android向けビルドを行う前の環境構築時に手動で実行されます。通常は開発環境のセットアップ時やCI環境の初期化時に一度実行されます。

**主要な処理内容**：
1. Android NDKのダウンロードと展開
2. LLDBデバッガのダウンロードと展開
3. Termuxリポジトリからの依存パッケージ取得
4. sysrootへのパッケージ配置
5. プラットフォーム識別ファイルの生成

**前後の処理との関連**：本バッチで生成されたsysrootは、ROOTFS_DIR環境変数を通じてbuild.shスクリプトのクロスコンパイルオプション（--cross --arch arm64）で使用されます。

**影響範囲**：.tools/android-rootfs/配下にNDK、LLDB、sysrootを配置します。環境変数TOOLCHAIN_DIRおよびNDK_DIRで既存のインストールを使用することも可能です。

## バッチ種別

環境構築 / クロスコンパイル準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（環境構築時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | NDK、LLDB、Termuxパッケージのダウンロード |
| 必要ツール | wget、unzip、dpkg |
| ディスク空き容量 | 数GB（NDK展開に必要） |
| Linux環境 | Linux x86_64環境が必要 |

### 実行可否判定

ターゲットアーキテクチャがarm64またはarmの場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BuildArch | string | No | arm64 | ターゲットアーキテクチャ（arm64, arm） |
| ApiLevel | number | No | 28 | ターゲットAndroid APIレベル |
| --ndk | string | No | r21 | NDKバージョン（r21, r22等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Android NDK | ZIP | dl.google.com からダウンロード |
| LLDB | ZIP | dl.google.com からダウンロード |
| Termuxパッケージ | deb | packages.termux.dev からダウンロード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| android-ndk-{version}/ | ディレクトリ | Android NDK |
| lldb/ | ディレクトリ | LLDBデバッガ |
| sysroot/usr/ | ディレクトリ | 依存ライブラリ |
| android_platform | テキスト | RID識別ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | android-rootfs |
| 出力先 | .tools/android-rootfs/ |
| android_platformファイル形式 | RID=android.{ApiLevel}-{BuildArch} |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ アーキテクチャ、APIレベル、NDKバージョンの解析
2. ディレクトリ準備
   └─ .tools/android-rootfsディレクトリの作成
3. NDKダウンロード（未存在時）
   └─ dl.google.comからNDK ZIPをダウンロード・展開
4. LLDBダウンロード（未存在時）
   └─ dl.google.comからLLDB ZIPをダウンロード・展開
5. Termuxパッケージ取得
   └─ libicu, libandroid-glob, liblzma, krb5, opensslをダウンロード
6. パッケージ展開
   └─ dpkgでパッケージを展開しsysrootにコピー
7. プラットフォームファイル生成
   └─ android_platformファイルにRIDを書き込み
8. 完了メッセージ
   └─ ビルドコマンドの表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[ディレクトリ準備]
    C --> D{NDK存在?}
    D -->|No| E[NDKダウンロード・展開]
    D -->|Yes| F{LLDB存在?}
    E --> F
    F -->|No| G[LLDBダウンロード・展開]
    F -->|Yes| H[Termuxパッケージ取得]
    G --> H
    H --> I[パッケージ展開・配置]
    I --> J[android_platformファイル生成]
    J --> K[ビルドコマンド表示]
    K --> L[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ダウンロードエラー | NDK/LLDB/パッケージのダウンロード失敗 | ネットワーク確認 |
| 非0 | 展開エラー | ZIPファイルの展開失敗 | unzipのインストール確認 |
| 非0 | パッケージエラー | dpkgによる展開失敗 | dpkgのインストール確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

失敗時は該当するディレクトリを削除して再実行してください。NDK_DIRまたはTOOLCHAIN_DIR環境変数で既存インストールを指定することも可能です。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 sysroot |
| 目標処理時間 | 数分〜10分程度（ネットワーク速度に依存） |
| メモリ使用量上限 | 制限なし |
| ディスク使用量 | 約3-5GB（NDK展開後） |

## 排他制御

同一ディレクトリへの同時実行は想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 開始時 | Target API level, architecture, NDK version, location |
| 進捗ログ | ダウンロード時 | Downloading the NDK/LLDB, Download dependencies |
| 進捗ログ | パッケージ処理時 | Working on: {package} |
| 完了ログ | 完了時 | ビルドコマンド例の表示 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- 最小APIレベルはarm64で21ですが、glob(3)サポートのため28以上が推奨されます
- NDKバージョンr21およびr22ではファイル構造が異なります（NDK_File_Arch_Spec）
- TOOLCHAIN_DIR環境変数でカスタムツールチェーンパスを指定可能
- NDK_DIR環境変数で既存NDKインストールを再利用可能
- 依存パッケージはTermux-21リポジトリから取得されます
- 生成されるandroid_platformファイルは/etc/os-releaseの代替として使用されます
