# バッチ設計書 74-tizen-build-rootfs

## 概要

本ドキュメントは、`eng/common/cross/tizen-build-rootfs.sh`スクリプトのバッチ設計書です。このスクリプトは、Tizen OS向けクロスコンパイル用のrootfsを構築するためのBashスクリプトです。

### 本バッチの処理概要

本バッチは、Samsung Tizen OS向けの.NETランタイムをクロスコンパイルするために必要なrootfs（ルートファイルシステム）を構築します。Tizenパッケージリポジトリから必要なRPMパッケージをダウンロードし、展開・設定します。

**業務上の目的・背景**：Tizen OSはSamsungが開発するLinuxベースのOSで、スマートウォッチやIoTデバイスなどに搭載されています。.NETランタイムをTizenデバイス上で動作させるためには、Tizenの開発ライブラリを含むrootfsが必要です。本バッチは、このrootfsの構築を自動化し、Tizen向けクロスコンパイル環境のセットアップを効率化します。

**バッチの実行タイミング**：Tizen向けビルドを行う前の環境構築時に実行されます。通常はbuild-rootfs.shスクリプトから「tizen」オプション指定時に呼び出されます。

**主要な処理内容**：
1. アーキテクチャに応じたTizenアーキテクチャ名の決定
2. tizen-fetch.shによるRPMパッケージのダウンロード
3. RPMパッケージの展開（rpm2cpio + cpio）
4. シンボリックリンクとパッチの適用

**前後の処理との関連**：build-rootfs.shから呼び出されるか、ROOTFS_DIR環境変数を設定して直接実行されます。生成されたrootfsはクロスコンパイルビルドで使用されます。

**影響範囲**：ROOTFS_DIR環境変数で指定されたディレクトリにTizen rootfsを構築します。

## バッチ種別

環境構築 / クロスコンパイル準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（環境構築時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行またはbuild-rootfs.shから呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ROOTFS_DIR環境変数 | 出力先ディレクトリを指定する環境変数が必要 |
| ネットワーク接続 | download.tizen.orgへのアクセス |
| 必要ツール | curl, xmllint, sha256sum, rpm2cpio, cpio, patch |

### 実行可否判定

ROOTFS_DIR環境変数が設定されており、サポートされるアーキテクチャが指定された場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ARCH | string | Yes | - | ターゲットアーキテクチャ（arm, armel, arm64, x86, x64, riscv64） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Tizenリポジトリ | RPM | download.tizen.orgからダウンロード |
| tizen.patch | パッチファイル | アーキテクチャ固有の修正パッチ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ROOTFS_DIR | ディレクトリ | Tizen rootfs |
| usr/include/ | ディレクトリ | ヘッダファイル |
| usr/lib/ または lib64/ | ディレクトリ | ライブラリファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | ROOTFS_DIRで指定 |
| シンボリックリンク | usr/include/asm -> asm-{LINK_ARCH} |

## 処理フロー

### 処理シーケンス

```
1. アーキテクチャ変換
   └─ 入力アーキテクチャをTizenアーキテクチャ名に変換
2. 環境変数チェック
   └─ ROOTFS_DIRが設定されているか確認
3. 一時ディレクトリ作成
   └─ $ROOTFS_DIR/tizen_tmpを作成
4. パッケージダウンロード
   └─ tizen-fetch.shを呼び出してRPMをダウンロード
5. RPM展開
   └─ rpm2cpioとcpioでパッケージを展開
6. 一時ディレクトリ削除
   └─ tizen_tmpを削除
7. rootfs設定
   ├─ asmシンボリックリンク作成
   ├─ tizen.patchの適用
   └─ riscv64の場合は追加のシンボリックリンク修正
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[アーキテクチャ変換]
    B --> C{ROOTFS_DIR設定?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[一時ディレクトリ作成]
    E --> F[tizen-fetch.sh実行]
    F --> G[RPMパッケージ展開]
    G --> H[一時ディレクトリ削除]
    H --> I[asmシンボリックリンク作成]
    I --> J[tizen.patch適用]
    J --> K{riscv64?}
    K -->|Yes| L[追加シンボリックリンク修正]
    K -->|No| M[完了]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | ROOTFS_DIRが未設定 | ROOTFS_DIR環境変数を設定 |
| 1 | 引数エラー | 未サポートのアーキテクチャ | サポートされるアーキテクチャを使用 |
| 非0 | ダウンロードエラー | tizen-fetch.sh失敗 | ネットワーク確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

失敗時はROOTFS_DIRの内容を確認し、不完全なファイルを削除してから再実行してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 rootfs |
| 目標処理時間 | 数分（ネットワーク速度に依存） |
| メモリ使用量上限 | 制限なし |
| ディスク使用量 | 数百MB |

## 排他制御

同一ROOTFS_DIRへの同時実行は想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ダウンロード開始時 | ">>Start downloading files" |
| 終了ログ | ダウンロード完了時 | "<<Finish downloading files" |
| 開始ログ | rootfs構築開始時 | ">>Start constructing Tizen rootfs" |
| 終了ログ | rootfs構築完了時 | "<<Finish constructing Tizen rootfs" |
| 開始ログ | 設定開始時 | ">>Start configuring Tizen rootfs" |
| 終了ログ | 設定完了時 | "<<Finish configuring Tizen rootfs" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- サポートされるアーキテクチャとTizenアーキテクチャの対応：
  - arm -> armv7hl
  - armel -> armv7l
  - arm64 -> aarch64
  - x86 -> i686
  - x64 -> x86_64
  - riscv64 -> riscv64
- riscv64アーキテクチャでは壊れたシンボリックリンクの修正が必要です
- tizen.patchファイルはアーキテクチャ別ディレクトリに配置されています
- VERBOSE=1環境変数でtizen-fetch.shの詳細ログが有効になります
