# バッチ設計書 75-tizen-fetch

## 概要

本ドキュメントは、`eng/common/cross/tizen-fetch.sh`スクリプトのバッチ設計書です。このスクリプトは、TizenリポジトリからRPMパッケージをダウンロードするためのBashスクリプトです。

### 本バッチの処理概要

本バッチは、Tizenパッケージリポジトリにアクセスし、クロスコンパイルに必要なRPMパッケージをダウンロードします。パッケージメタデータ（repomd.xml、primary.xml）を解析し、指定されたパッケージとその依存関係を取得します。

**業務上の目的・背景**：Tizen向けクロスコンパイル環境を構築するためには、Tizenのシステムライブラリと開発ヘッダが必要です。本バッチは、Tizenの公式リポジトリからこれらのパッケージを自動的にダウンロードし、チェックサム検証を行うことで、信頼性の高い環境構築を支援します。

**バッチの実行タイミング**：tizen-build-rootfs.shから呼び出されます。直接実行することも可能です。

**主要な処理内容**：
1. Tizenリポジトリのbuild.xmlからビルドターゲットパスを取得
2. repomd.xmlからprimary.xmlの場所を取得
3. primary.xmlからパッケージのダウンロードURLとチェックサムを取得
4. 各パッケージをダウンロードしてチェックサム検証

**前後の処理との関連**：tizen-build-rootfs.shから呼び出され、ダウンロードしたRPMファイルはtizen-build-rootfs.shで展開されます。

**影響範囲**：指定された一時ディレクトリ（TMPDIR）にRPMパッケージをダウンロードします。

## バッチ種別

データ取得 / パッケージダウンロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（tizen-build-rootfs.shから呼び出し） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | tizen-build-rootfs.shまたは手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | download.tizen.orgへのアクセス |
| 必要ツール | curl, xmllint, sha256sum, gunzip |

### 実行可否判定

必要なツール（curl, xmllint, sha256sum）がインストールされている場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TMPDIR | string | No | ./tizen_tmp | ダウンロード先ディレクトリ |
| TIZEN_ARCH | string | Yes | - | Tizenアーキテクチャ名（armv7hl, armv7l, aarch64, i686, x86_64, riscv64） |
| VERBOSE | number | No | 0 | ログ詳細度（0: 最小, 1: 情報, 2: デバッグ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| build.xml | XML | ビルドターゲット情報 |
| repomd.xml | XML | リポジトリメタデータ |
| primary.xml.gz | gzip XML | パッケージ一覧と情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| TMPDIR/*.rpm | RPM | ダウンロードしたパッケージファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | RPMパッケージ |
| 出力先 | TMPDIR（第1引数で指定） |
| チェックサム検証 | SHA256 |

## 処理フロー

### 処理シーケンス

```
1. 事前チェック
   └─ curl, xmllint, sha256sumの存在確認
2. ディレクトリ準備
   └─ TMPDIRの作成（未存在時）
3. Tizen-Baseパッケージ取得
   ├─ fetch_tizen_pkgs_init("standard", "Tizen-Base")
   ├─ 共通パッケージ取得（gcc, glibc, libicu等）
   ├─ CoreCLRパッケージ取得（libgcc, libstdc++, libunwind等）
   └─ CoreFXパッケージ取得（zlib, openssl, krb5等）
4. Tizen-Unifiedパッケージ取得
   ├─ fetch_tizen_pkgs_init("standard", "Tizen-Unified")
   └─ 追加パッケージ取得（gssdp, tizen-release）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{curl/xmllint/sha256sum存在?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[TMPDIRディレクトリ準備]
    D --> E[Tizen-Baseリポジトリ初期化]
    E --> F[build.xml取得・解析]
    F --> G[repomd.xml取得・解析]
    G --> H[primary.xml取得・展開]
    H --> I[共通パッケージダウンロード]
    I --> J[CoreCLRパッケージダウンロード]
    J --> K[CoreFXパッケージダウンロード]
    K --> L[Tizen-Unifiedリポジトリ初期化]
    L --> M[追加パッケージダウンロード]
    M --> N[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 環境エラー | curl/xmllint/sha256sumが未インストール | 必要ツールをインストール |
| 1 | XMLエラー | XPathでターゲットが見つからない | リポジトリ構造の変更確認 |
| 1 | チェックサムエラー | ダウンロードファイルのチェックサム不一致 | 再ダウンロード |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

失敗時は一時ディレクトリを削除して再実行してください。チェックサムエラーの場合はネットワーク接続を確認してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約20-30パッケージ |
| 目標処理時間 | 数分（ネットワーク速度に依存） |
| メモリ使用量上限 | 制限なし |
| ディスク使用量 | 数十MB〜数百MB |

## 排他制御

同一TMPDIRへの同時実行は想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | リポジトリ初期化時 | "Initialize {TIZEN_ARCH} base" |
| 情報ログ | パッケージ取得時 | "fetch common packages", "Fetching... {pkg}" |
| デバッグログ | 詳細処理時 | ダウンロードURL、チェックサム等（VERBOSE>=2時） |
| エラーログ | エラー発生時 | "Require 'curl' Aborting.", チェックサムエラー等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- ダウンロード対象パッケージ一覧：
  - **共通**：gcc, gcc-devel-static, glibc, glibc-devel, libicu, libicu-devel, libatomic, linux-glibc-devel, keyutils, keyutils-devel, libkeyutils
  - **CoreCLR**：libgcc, libstdc++, libstdc++-devel, libunwind, libunwind-devel, lttng-ust-devel, lttng-ust, userspace-rcu-devel, userspace-rcu, lldb, lldb-devel（riscv64除く）
  - **CoreFX**：libcom_err, libcom_err-devel, zlib, zlib-devel, libopenssl11, libopenssl1.1-devel, krb5, krb5-devel, gssdp, gssdp-devel, tizen-release
- VERBOSE環境変数でログ詳細度を制御可能（0: 最小, 1: 情報出力, 2: デバッグ出力）
- XPathを使用してXMLからパッケージ情報を抽出します
- SHA256チェックサムによるダウンロードファイルの整合性検証を実行します
