# バッチ設計書 76-common-library

## 概要

本ドキュメントは、`eng/common/native/common-library.sh`スクリプトのバッチ設計書です。このスクリプトは、ネイティブビルド用の共通シェル関数を提供するBashライブラリです。

### 本バッチの処理概要

本バッチは、ネイティブツールのダウンロード、展開、シム（shim）スクリプト生成などの共通処理を提供する関数ライブラリです。他のシェルスクリプトからsource（ドット読み込み）されて使用されます。

**業務上の目的・背景**：.NETのビルドプロセスでは、CMakeやClangなどのネイティブツールをダウンロードして使用することがあります。本ライブラリは、これらのツールの取得・セットアップに必要な共通処理を一元化し、コードの重複を排除して保守性を向上させます。

**バッチの実行タイミング**：直接実行されるものではなく、install-cmake.shなど他のスクリプトからsourceされて使用されます。

**主要な処理内容**：
1. ネイティブツールのインストールディレクトリ管理
2. ファイルのダウンロード（curlまたはwget使用）
3. ZIPアーカイブの展開
4. シムスクリプトの生成

**前後の処理との関連**：install-cmake.sh等のツールインストールスクリプトから呼び出されます。

**影響範囲**：NETCOREENG_INSTALL_DIRECTORY環境変数で指定されたディレクトリ（デフォルト：$HOME/.netcoreeng/native/）配下にツールをインストールします。

## バッチ種別

ユーティリティライブラリ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | N/A（ライブラリのため直接実行されない） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 他スクリプトからのsource |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Bashシェルが必要 |
| ダウンロードツール | curlまたはwgetが必要（GetFile関数使用時） |

### 実行可否判定

Bash環境であれば使用可能です。

## 入力仕様

### 入力パラメータ

各関数の入力パラメータは以下の通りです。

#### GetNativeInstallDirectory
パラメータなし。

#### GetTempDirectory
パラメータなし。

#### ExpandZip
| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| zip_path | string | Yes | - | 展開するZIPファイルのパス |
| output_directory | string | Yes | - | 展開先ディレクトリ |
| force | boolean | No | false | 既存ディレクトリを上書きするか |

#### GetCurrentOS
パラメータなし。

#### GetFile
| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| uri | string | Yes | - | ダウンロードURL |
| path | string | Yes | - | 保存先パス |
| force | boolean | No | false | 既存ファイルを上書きするか |
| download_retries | number | No | 5 | リトライ回数 |
| retry_wait_time_seconds | number | No | 30 | リトライ間隔（秒） |

#### DownloadAndExtract
| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| uri | string | Yes | - | ダウンロードURL |
| installDir | string | Yes | - | インストール先ディレクトリ |
| force | boolean | No | false | 強制再インストール |
| download_retries | number | No | 5 | リトライ回数 |
| retry_wait_time_seconds | number | No | 30 | リトライ間隔（秒） |

#### NewScriptShim
| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| shimpath | string | Yes | - | シムスクリプトの出力パス |
| tool_file_path | string | Yes | - | ラップするツールの実行ファイルパス |
| force | boolean | No | false | 既存シムを上書きするか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NETCOREENG_INSTALL_DIRECTORY | 環境変数 | インストールベースディレクトリ |
| リモートURL | HTTP/HTTPS | ダウンロード対象のアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| インストールディレクトリ | ディレクトリ | 展開されたツール |
| シムスクリプト | シェルスクリプト | ツールのラッパースクリプト |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| インストールディレクトリ | $HOME/.netcoreeng/native/ または NETCOREENG_INSTALL_DIRECTORY |
| 一時ディレクトリ | {インストールディレクトリ}/temp/ |
| シムスクリプト形式 | #!/usr/bin/env bash + 引数転送 |

## 処理フロー

### 処理シーケンス（DownloadAndExtract関数）

```
1. 一時ファイルパス生成
   └─ GetTempPathFileNameでパス決定
2. ファイルダウンロード
   └─ GetFileでダウンロード（リトライ付き）
3. アーカイブ展開
   └─ ExpandZipで展開
4. 完了
   └─ 成功時は0、失敗時は1を返却
```

### フローチャート

```mermaid
flowchart TD
    A[DownloadAndExtract開始] --> B[一時ファイルパス生成]
    B --> C[GetFile実行]
    C --> D{ダウンロード成功?}
    D -->|No| E[エラー返却]
    D -->|Yes| F[ExpandZip実行]
    F --> G{展開成功?}
    G -->|No| E
    G -->|Yes| H[成功返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ダウンロードエラー | URLからのファイル取得失敗 | ネットワーク確認、リトライ |
| 1 | 展開エラー | アーカイブの展開失敗 | ファイル破損確認 |
| 1 | ファイルエラー | ツールファイルパスが存在しない | パス確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（GetFile関数デフォルト） |
| リトライ間隔 | 30秒（GetFile関数デフォルト） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

Write-PipelineTelemetryError関数でAzure Pipelinesにエラーを報告します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ツールごとに1回 |
| 目標処理時間 | ダウンロードサイズとネットワーク速度に依存 |
| メモリ使用量上限 | 制限なし |

## 排他制御

同一ツールへの同時インストールは想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ダウンロード時 | "Downloading $uri" |
| 情報ログ | 展開時 | "Extracting $zip_path to $output_directory" |
| 情報ログ | シム生成時 | "Generating '$shimpath' shim" |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによるエラー報告 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | Azure Pipelines（Write-PipelineTelemetryError） |

## 備考

- **提供される関数一覧**：
  - `GetNativeInstallDirectory`: ネイティブツールのインストールディレクトリを取得
  - `GetTempDirectory`: 一時ディレクトリパスを取得
  - `ExpandZip`: ZIPアーカイブを展開
  - `GetCurrentOS`: 現在のOS名を取得（Linux/MacOS）
  - `GetFile`: ファイルをダウンロード
  - `GetTempPathFileName`: 一時ファイルパスを生成
  - `DownloadAndExtract`: ダウンロードして展開
  - `NewScriptShim`: シムスクリプトを生成

- GetCurrentOS関数はLinuxとDarwin（MacOS）を検出します
- GetFile関数はcurlを優先し、なければwgetを使用します
- ExpandZip関数はtarコマンドで展開するため、.tar.gzや.tar.xzにも対応可能です
- シムスクリプトは実行権限（chmod +x）が付与されます
