# バッチ設計書 77-init-os-and-arch

## 概要

本ドキュメントは、`eng/common/native/init-os-and-arch.sh`スクリプトのバッチ設計書です。このスクリプトは、現在の実行環境のOSとCPUアーキテクチャを検出して変数に設定するシェルスクリプトです。

### 本バッチの処理概要

本バッチは、unameコマンドとその他のシステム情報を使用して、現在のOS名とCPUアーキテクチャを検出し、.NETビルドシステムで使用される標準的な名前に変換します。

**業務上の目的・背景**：.NETのビルドシステムでは、異なるOSとCPUアーキテクチャに対応する必要があります。本バッチは、実行環境を自動検出し、ビルドスクリプトが適切なビルド設定を選択できるようにします。これにより、開発者は手動で環境を指定する必要がなくなり、ビルドプロセスの自動化が促進されます。

**バッチの実行タイミング**：ビルドスクリプトの初期化時にsourceされて使用されます。

**主要な処理内容**：
1. unameコマンドによるOS名の検出
2. Android環境の特別検出（getpropコマンド）
3. CPUアーキテクチャの検出と変換
4. 32ビット/64ビット環境の判定

**前後の処理との関連**：ビルドスクリプト（build.sh等）の初期段階で呼び出され、`os`と`arch`変数を設定します。これらの変数は後続の処理で使用されます。

**影響範囲**：`os`と`arch`のシェル変数を設定します。

## バッチ種別

環境検出 / 初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドスクリプト実行時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ビルドスクリプトからのsource |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | POSIX準拠シェル（sh/bash） |
| unameコマンド | OS/アーキテクチャ検出に必要 |

### 実行可否判定

シェル環境であれば実行可能です。

## 入力仕様

### 入力パラメータ

本スクリプトはパラメータを受け取りません。システム情報を自動検出します。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| uname -s | コマンド出力 | OS名 |
| uname -m | コマンド出力 | マシンアーキテクチャ |
| uname -o | コマンド出力 | OS種別（illumos判定用） |
| isainfo -n | コマンド出力 | Solaris/illumosでのCPU情報 |
| getprop | コマンド出力 | Android環境の検出 |
| getconf LONG_BIT | コマンド出力 | ビット幅（32/64ビット判定） |
| /etc/os-release | ファイル | Tizen判定用 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| os | シェル変数 | 検出されたOS名 |
| arch | シェル変数 | 検出されたアーキテクチャ名 |

### 出力値一覧

#### OS名（os変数）
| 検出値 | 出力値 |
|-------|-------|
| Linux | linux |
| Darwin | osx |
| FreeBSD | freebsd |
| NetBSD | netbsd |
| OpenBSD | openbsd |
| SunOS (illumos) | illumos |
| SunOS (Solaris) | solaris |
| Android | android |
| Haiku | haiku |

#### アーキテクチャ名（arch変数）
| 検出値 | 出力値 |
|-------|-------|
| arm64, aarch64 | arm64 |
| arm64 (32bit OS) | arm |
| loongarch64 | loongarch64 |
| riscv64 | riscv64 |
| amd64, x86_64 | x64 |
| armv7l, armv8l | arm または armel（Tizen） |
| armv6l | armv6 |
| i386-i686 | x86 |
| s390x | s390x |
| ppc64le | ppc64le |

## 処理フロー

### 処理シーケンス

```
1. OS検出
   ├─ uname -sでOS名取得
   ├─ getpropでAndroid判定
   └─ uname -oでillumos/Solaris判定
2. OS名変換
   └─ Linux/Darwin/FreeBSD等を標準名に変換
3. CPU検出
   ├─ Solaris/illumosの場合はisainfo -n使用
   └─ その他はuname -m使用
4. アーキテクチャ変換
   ├─ 64ビットCPU上の32ビットOS判定
   ├─ Tizen固有のarmel判定
   └─ 標準アーキテクチャ名に変換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[uname -s実行]
    B --> C{Android?}
    C -->|Yes| D[os=android]
    C -->|No| E{OS判定}
    E -->|Linux| F[os=linux]
    E -->|Darwin| G[os=osx]
    E -->|FreeBSD| H[os=freebsd]
    E -->|SunOS| I{illumos?}
    I -->|Yes| J[os=illumos]
    I -->|No| K[os=solaris]
    E -->|Other| L[エラー終了]
    D --> M[CPU検出]
    F --> M
    G --> M
    H --> M
    J --> M
    K --> M
    M --> N{Solaris?}
    N -->|Yes| O[isainfo -n]
    N -->|No| P[uname -m]
    O --> Q[アーキテクチャ変換]
    P --> Q
    Q --> R[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検出エラー | 未サポートのOSが検出された場合 | サポートされるOSで実行 |
| 1 | 検出エラー | 未知のCPUが検出された場合 | サポートされるCPUで実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

未サポートの環境で実行した場合はエラーメッセージが表示されて終了します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（初期化時） |
| 目標処理時間 | ミリ秒単位 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 未サポートOS検出時 | "Unsupported OS $OSName detected!" |
| エラーログ | 未サポートCPU検出時 | "Unknown CPU $CPUName detected!" |
| 警告ログ | x86検出時 | "Unsupported CPU $CPUName detected, build might not succeed!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- 64ビットCPU上で32ビットOSが動作している場合（例：Raspberry Pi OS）、archはarmに設定されます
- Tizenの場合、armv7l/armv8lはarmelに変換されます（/etc/os-releaseのNAME判定）
- Solaris/illumosではunameではなくisainfoコマンドでCPU情報を取得します
- i386-i686は「サポートされていないが動作する可能性がある」として警告付きでx86に設定されます
- スクリプトは#!/bin/shで始まり、POSIX互換シェルで動作します
