# バッチ設計書 78-init-distro-rid

## 概要

本ドキュメントは、`eng/common/native/init-distro-rid.sh`スクリプトのバッチ設計書です。このスクリプトは、Linuxディストリビューションに基づくRID（Runtime Identifier）を初期化するシェルスクリプトです。

### 本バッチの処理概要

本バッチは、ターゲットプラットフォームの情報（OS、アーキテクチャ、rootfsディレクトリ）からNon-portable RIDとPortable Target OSを検出・設定します。RIDは.NETランタイムの識別子で、特定のプラットフォーム向けのネイティブアセットを特定するために使用されます。

**業務上の目的・背景**：.NETアプリケーションは、プラットフォーム固有のネイティブライブラリを使用することがあります。RIDは、どのプラットフォーム向けのアセットを使用するかを決定するための識別子です。本バッチは、ビルド時に正しいRIDを自動検出し、適切なネイティブアセットがパッケージ化されるようにします。

**バッチの実行タイミング**：ビルドスクリプトの初期化時にsourceされて使用されます。

**主要な処理内容**：
1. /etc/os-releaseからディストリビューション情報を取得
2. Non-portable RIDの生成（例：ubuntu.22.04-x64）
3. musl libc環境（Alpine Linux等）の検出
4. Portable Target OSの設定

**前後の処理との関連**：ビルドスクリプトから呼び出され、`__DistroRid`と`__PortableTargetOS`変数を設定します。

**影響範囲**：`__DistroRid`と`__PortableTargetOS`のシェル変数をエクスポートします。

## バッチ種別

環境検出 / RID初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドスクリプト実行時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ビルドスクリプトからのsource |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | POSIX準拠シェル（sh/bash） |
| /etc/os-release | Linuxディストリビューション情報（Linux環境） |

### 実行可否判定

シェル環境であれば実行可能です。

## 入力仕様

### 入力パラメータ

#### getNonPortableDistroRid関数
| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| targetOs | string | Yes | - | ターゲットOS名 |
| targetArch | string | Yes | - | ターゲットアーキテクチャ |
| rootfsDir | string | Yes | - | rootfsディレクトリパス |

#### initDistroRidGlobal関数
| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| targetOs | string | Yes | - | ターゲットOS名 |
| targetArch | string | Yes | - | ターゲットアーキテクチャ |
| rootfsDir | string | No | "" | rootfsディレクトリパス（クロスビルド時） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/os-release | シェル変数形式 | ディストリビューション情報（ID, VERSION_ID） |
| android_platform | シェル変数形式 | Android RID情報 |
| /bin/freebsd-version | コマンド | FreeBSDバージョン |
| getprop | コマンド | Android SDK情報 |
| uname -v | コマンド | Solaris/illumosバージョン |
| uname -r | コマンド | Haikuリリース情報 |
| /usr/bin/ldd --version | コマンド | musl libc検出 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| __DistroRid | シェル変数（export） | Non-portable RID |
| __PortableTargetOS | シェル変数（export） | Portable Target OS |

### 出力値例

| プラットフォーム | __DistroRid | __PortableTargetOS |
|-----------------|-------------|-------------------|
| Ubuntu 22.04 x64 | ubuntu.22.04-x64 | linux |
| Alpine Linux 3.17 x64 | alpine.3.17-x64 | linux-musl |
| FreeBSD 13 amd64 | freebsd.13-x64 | freebsd |
| Android 28 arm64 | android.28-arm64 | android |
| illumos x64 | illumos-x64 | illumos |
| Haiku r1 x64 | haiku.r1-x64 | haiku |

## 処理フロー

### 処理シーケンス

```
1. getNonPortableDistroRid関数
   ├─ Linux: /etc/os-releaseからID.VERSION_ID-archを生成
   ├─ Android: android_platformまたはgetpropからRIDを取得
   ├─ FreeBSD: freebsd-versionからメジャーバージョンを取得
   ├─ illumos: illumos-archを生成
   ├─ Solaris: solaris.version-archを生成
   └─ Haiku: haiku.r{release}-archを生成
2. initDistroRidGlobal関数
   ├─ rootfsDirの存在確認
   ├─ getNonPortableDistroRidでRID取得
   └─ musl libc検出でPortable Target OS決定
```

### フローチャート

```mermaid
flowchart TD
    A[initDistroRidGlobal開始] --> B{rootfsDir指定?}
    B -->|Yes| C{rootfsDir存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[getNonPortableDistroRid呼び出し]
    B -->|No| E
    E --> F{targetOs判定}
    F -->|linux| G[/etc/os-release読み込み]
    F -->|freebsd| H[freebsd-version実行]
    F -->|android| I[getprop実行]
    F -->|illumos| J[illumos-arch生成]
    F -->|solaris| K[solaris.ver-arch生成]
    F -->|haiku| L[haiku.r{rel}-arch生成]
    G --> M[__DistroRid設定]
    H --> M
    I --> M
    J --> M
    K --> M
    L --> M
    M --> N{musl libc?}
    N -->|Yes| O[__PortableTargetOS=linux-musl]
    N -->|No| P[__PortableTargetOS=targetOs]
    O --> Q[変数エクスポート]
    P --> Q
    Q --> R[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検出エラー | rootfsDirが指定されたが存在しない | 正しいパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

rootfsDirが不正な場合はエラーメッセージが表示されて終了します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（初期化時） |
| 目標処理時間 | ミリ秒単位 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | rootfsDir検証失敗時 | "Error: rootfsDir has been passed, but the location is not valid." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- **musl libc検出方法**：
  - /usr/bin/ldd --version 2>&1 | grep -q musl
  - または、stringsコマンドで/usr/bin/lddを解析
- ローリングリリースディストリビューション（Arch Linux等）ではVERSION_IDが設定されていない場合があり、その場合はID-archのみが使用されます
- Android環境はgetpropコマンドで検出され、ro.build.version.sdkからAPIレベルが取得されます
- Solarisのバージョンはuname -vから取得され、メジャーバージョンのみが使用されます
- __PortableTargetOS変数が既に設定されている場合は上書きされません
- stringsコマンドが利用可能な場合はllvm-stringsも代替として検索されます
