# バッチ設計書 79-init-compiler

## 概要

本ドキュメントは、`eng/common/native/init-compiler.sh`スクリプトのバッチ設計書です。このスクリプトは、C/C++コンパイラ（Clang/GCC）を検出し、CC/CXX環境変数を設定するシェルスクリプトです。

### 本バッチの処理概要

本バッチは、ネイティブコードのビルドに使用するC/C++コンパイラを自動検出し、適切な環境変数（CC, CXX, LDFLAGS）を設定します。ClangまたはGCCから指定されたバージョンまたは利用可能な最新バージョンを選択します。

**業務上の目的・背景**：.NETランタイムにはネイティブコードコンポーネントが含まれており、これらをビルドするためにはC/C++コンパイラが必要です。本バッチは、開発者の環境に応じて適切なコンパイラを自動選択し、ビルドプロセスを簡素化します。また、特定のバージョンを指定することも可能です。

**バッチの実行タイミング**：ビルドスクリプトの初期化時にsourceされて使用されます。

**主要な処理内容**：
1. コンパイラ名（clang/gcc）とバージョンの解析
2. 指定バージョンまたは最新バージョンのコンパイラ検出
3. CC/CXX/LDFLAGS環境変数の設定
4. scan-buildコマンドの検出

**前後の処理との関連**：ビルドスクリプトから呼び出され、ネイティブコンポーネントのビルドに使用するコンパイラを設定します。

**影響範囲**：CC, CXX, LDFLAGS, SCAN_BUILD_COMMAND環境変数をエクスポートします。

## バッチ種別

環境検出 / コンパイラ初期化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドスクリプト実行時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ビルドスクリプトからのsource |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | POSIX準拠シェル（sh/bash） |
| build_arch変数 | ターゲットアーキテクチャが設定されていること |
| compiler変数 | コンパイラ名（clang/gcc）が設定されていること |

### 実行可否判定

build_archとcompiler変数が設定されている場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| build_arch | 環境変数 | Yes | - | ターゲットアーキテクチャ |
| compiler | 環境変数 | Yes | - | コンパイラ名とオプションでバージョン（clang, clang-15, gcc-12等） |
| CLR_CC | 環境変数 | No | - | 明示的なCコンパイラパス |
| CLR_CXX | 環境変数 | No | - | 明示的なC++コンパイラパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| command -v | コマンド | コンパイラの存在確認 |
| $CC -dumpversion | コマンド | コンパイラバージョン取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| CC | 環境変数（export） | Cコンパイラのパス |
| CXX | 環境変数（export） | C++コンパイラのパス |
| LDFLAGS | 環境変数（export） | リンカフラグ（-fuse-ld=lld等） |
| SCAN_BUILD_COMMAND | 環境変数（export） | scan-buildコマンドのパス |

### 出力値例

| compiler指定 | CC | CXX | LDFLAGS |
|-------------|-----|-----|---------|
| clang | /usr/bin/clang-15 | /usr/bin/clang++-15 | -fuse-ld=lld |
| clang-14 | /usr/bin/clang-14 | /usr/bin/clang++-14 | -fuse-ld=lld |
| gcc | /usr/bin/gcc-12 | /usr/bin/g++-12 | (空) |
| gcc-11 | /usr/bin/gcc-11 | /usr/bin/g++-11 | (空) |

## 処理フロー

### 処理シーケンス

```
1. 事前チェック
   └─ build_archとcompiler変数の存在確認
2. コンパイラ名解析
   ├─ clang*: version抽出、maxVersion計算
   └─ gcc*: version抽出、maxVersion計算
3. コンパイラ検出
   ├─ CLR_CC指定時: 指定パスを使用
   ├─ majorVersion指定時: 指定バージョンを検索
   └─ 未指定時: 最新バージョンを自動検出（8〜maxVersion）
4. バージョン取得
   └─ $CC -dumpversionでバージョン確認
5. リンカ設定
   └─ Clang 9以上かつ非Darwin: -fuse-ld=lldを設定
6. scan-build検出
   └─ scan-build{version}コマンドを検索
7. 変数エクスポート
   └─ CC, CXX, LDFLAGS, SCAN_BUILD_COMMANDをエクスポート
```

### フローチャート

```mermaid
flowchart TD
    A[init-compiler開始] --> B{build_arch/compiler設定?}
    B -->|No| C[使用方法表示・終了]
    B -->|Yes| D[コンパイラ名解析]
    D --> E{CLR_CC設定?}
    E -->|Yes| F[CLR_CC/CLR_CXXを使用]
    E -->|No| G{majorVersion指定?}
    G -->|Yes| H[指定バージョン検索]
    G -->|No| I[最新バージョン自動検出]
    H --> J{発見?}
    I --> J
    J -->|No| K[エラー終了]
    J -->|Yes| L[CC/CXX設定]
    F --> L
    L --> M[$CC -dumpversion実行]
    M --> N{Darwin以外かつClang 9+?}
    N -->|Yes| O[LDFLAGS=-fuse-ld=lld]
    N -->|No| P[LDFLAGS=空]
    O --> Q[scan-build検索]
    P --> Q
    Q --> R[変数エクスポート]
    R --> S[完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | build_archまたはcompilerが未設定 | 変数を設定 |
| 1 | 検出エラー | 指定バージョンのコンパイラが見つからない | コンパイラをインストール |
| 1 | 検出エラー | 互換性のあるコンパイラが見つからない | 対応バージョンをインストール |
| 1 | パスエラー | CLR_CCで指定したパスが存在しない | 正しいパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

コンパイラが見つからない場合はエラーメッセージが表示されます。CLR_CCとCLR_CXX環境変数で明示的にコンパイラを指定することで回避できます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（初期化時） |
| 目標処理時間 | ミリ秒〜秒単位 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 変数未設定時 | 使用方法メッセージ |
| エラーログ | コンパイラ未発見時 | "Error: No compatible version of $compiler was found..." |
| エラーログ | 指定バージョン未発見時 | "Error: Could not find specific version of $compiler: $majorVersion." |
| エラーログ | CLR_CCパス不正時 | "Error: CLR_CC is set but path '$CLR_CC' does not exist" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | 標準エラー出力 |

## 備考

- **バージョン検索範囲**：
  - 最小バージョン: 8
  - 最大バージョン: 動的計算（Clang: 18 + 年からの経過月/6、GCC: 14 + 年からの経過月/12）
- **LLDリンカ使用条件**：
  - Clangバージョン9以上
  - Darwin（macOS）以外
  - s390xの場合はバージョン18以上が必要
  - -fuse-ld=lldがサポートされていること
- Darwinでは常にAppleリンカを使用します
- コンパイラは「compiler-version」または「compilerversion」形式で検索されます（例：clang-15, clang15）
- バージョンが6以下の場合はマイナーバージョンも考慮されます
- scan-buildは静的解析ツールで、コンパイラと同じバージョンサフィックスで検索されます
