# バッチ設計書 8-test.sh

## 概要

本ドキュメントは、RoslynプロジェクトのUnix環境向けユニットテスト実行エントリーポイントスクリプト「test.sh」の設計仕様を記載する。

### 本バッチの処理概要

test.shは、Unix環境（Linux/macOS）においてRoslynプロジェクトのユニットテストを実行するためのシェルスクリプトエントリーポイントである。

**業務上の目的・背景**：Roslynコンパイラの開発において、Unix環境でのテスト実行手段を提供する。クロスプラットフォーム開発を支援し、Linux/macOS環境での開発者やCI/CDパイプラインがテストを実行できるようにする。Windows環境のTest.cmdと同等の機能をUnix環境で提供することで、開発環境の選択肢を広げる。

**バッチの実行タイミング**：開発者による手動実行（コード変更後の検証時）、CI/CDパイプラインでのテストフェーズ。ビルド完了後に実行されることが多い。

**主要な処理内容**：
1. シンボリックリンクを解決してスクリプトの実際のパスを取得
2. スクリプトのルートディレクトリを特定
3. eng/build.shに--testオプションを指定して呼び出し
4. コマンドライン引数をそのままeng/build.shに渡す

**前後の処理との関連**：build.shによるビルド完了後に実行される。eng/build.shの--testオプション（--testCoreClrのエイリアス）を使用してテストを実行する。

**影響範囲**：テスト結果、テストログに影響を与える。ビルド成果物自体は変更しない。

## バッチ種別

テスト処理（ユニットテスト実行）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix環境 | Linux または macOS で実行可能 |
| Bash | Bashシェルが利用可能であること |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| 実行権限 | スクリプトに実行権限が付与されていること |
| ビルド完了 | テスト対象のバイナリがビルド済みであること |

### 実行可否判定

特別な判定ロジックはなく、前提条件が満たされていれば実行可能。eng/build.sh側で詳細な条件チェックが行われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string | No | なし | eng/build.shに渡される追加パラメータ（--configuration等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| artifacts/bin/RunTests | DLL | テストランナー |
| artifacts/bin/*UnitTests | DLL | テストアセンブリ群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/log | txt | テストログ |
| 標準出力 | テキスト | テスト進捗・結果サマリー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種ログファイル |
| 出力先 | artifacts/log |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. シェルからtest.shを実行
   └─ コマンドライン引数を受け取る
2. シンボリックリンクを解決
   └─ BASH_SOURCE[0]から実際のパスを取得
3. スクリプトルートディレクトリを特定
   └─ cd -P と dirname を使用
4. eng/build.shを呼び出し
   └─ --test と追加引数を渡す
5. テスト結果を標準出力に表示
   └─ 終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[test.sh実行] --> B[シンボリックリンク解決]
    B --> C[scriptrootディレクトリ特定]
    C --> D[eng/build.sh呼び出し]
    D --> E{--testオプション付与}
    E --> F[追加引数を渡す]
    F --> G[テスト実行]
    G --> H[終了コード返却]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルド未完了 | テストバイナリが存在しない | build.shを先に実行 |
| 非0 | テスト失敗 | 1つ以上のテストが失敗 | テスト結果を確認し修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. 標準出力/標準エラー出力を確認
3. artifacts/log配下のログファイルを確認
4. 失敗したテストを特定し、コードを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万のテストケース |
| 目標処理時間 | 環境依存（通常30-60分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

テストランナーは複数のテストを並列実行する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | テスト中 | テスト進捗 |
| ログファイル | テスト完了時 | テスト結果詳細 |
| htmlレポート | テスト完了時 | 視覚的なテスト結果（非CI時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDパイプライン |
| テスト失敗数 | 1以上 | CI/CDパイプライン |

## 備考

- 本スクリプトはeng/build.shへの薄いラッパーであり、--testオプションに相当
- --testは--testCoreClrのエイリアス（eng/build.sh内）
- Windows環境ではTest.cmdを使用すること
- シンボリックリンク解決により、リンク経由での実行も正しく動作する
- ビルドが完了していない場合は先にbuild.shを実行する必要がある
