# バッチ設計書 80-install-cmake

## 概要

本ドキュメントは、`eng/common/native/install-cmake.sh`スクリプトのバッチ設計書です。このスクリプトは、CMakeビルドツールをダウンロードしてインストールするBashスクリプトです。

### 本バッチの処理概要

本バッチは、指定されたバージョンのCMakeをリモートからダウンロードし、ローカル環境にインストールします。また、CMakeコマンドを簡単に呼び出せるようにシムスクリプトを生成します。

**業務上の目的・背景**：.NETランタイムのネイティブコンポーネントはCMakeを使用してビルドされます。本バッチは、ビルドに必要な特定バージョンのCMakeを自動的にインストールすることで、開発者やCI環境でのビルド環境の統一を図ります。システムにインストールされているCMakeのバージョンに依存せず、常に期待されるバージョンでビルドを実行できます。

**バッチの実行タイミング**：ビルドスクリプトのツール初期化フェーズで実行されます。通常はinit-tools-native.shから呼び出されます。

**主要な処理内容**：
1. CMakeアーカイブのダウンロード
2. アーカイブの展開
3. シムスクリプトの生成
4. クリーンアップ（--cleanオプション時）

**前後の処理との関連**：init-tools-native.shから呼び出されます。インストールされたCMakeはネイティブビルドプロセスで使用されます。

**影響範囲**：指定されたインストールディレクトリにCMakeをインストールし、シムスクリプトを生成します。

## バッチ種別

ツールインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド環境初期化時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | init-tools-native.shまたは手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Bashシェルが必要 |
| ネットワーク接続 | CMakeアーカイブのダウンロード |
| 必要ツール | curl または wget、tar |

### 実行可否判定

ネットワーク接続があり、インストールディレクトリに書き込み権限がある場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --baseuri | string | Yes | - | CMakeアーカイブのベースURL |
| --installpath | string | Yes | - | インストール先ベースディレクトリ |
| --version | string | Yes | - | CMakeバージョン |
| --clean | flag | No | false | インストール済みCMakeを削除 |
| --force | flag | No | false | 既存インストールを強制上書き |
| --downloadretries | number | No | 5 | ダウンロードリトライ回数 |
| --retrywaittimeseconds | number | No | 30 | リトライ間隔（秒） |
| --help | flag | No | - | ヘルプメッセージを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リモートURL | tar.gz | CMakeアーカイブ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| インストールディレクトリ | ディレクトリ | CMakeバイナリと関連ファイル |
| シムスクリプト | シェルスクリプト | CMake呼び出し用ラッパー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| CMakeパス | {installpath}/cmake/{version}/cmake-{version}-{OS}-x86_64/bin/cmake |
| シムパス | {installpath}/cmake.sh |
| アーカイブURL形式 | {baseuri}/{os}/cmake/cmake-{version}-{OS}-x86_64.tar.gz |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ オプションの解析とデフォルト値設定
2. パス計算
   ├─ OS検出（Linux/MacOS）
   ├─ ダウンロードURL生成
   ├─ インストールディレクトリパス生成
   └─ シムスクリプトパス生成
3. クリーン処理（--clean時）
   ├─ インストールディレクトリ削除
   ├─ シムスクリプト削除
   └─ 一時ファイル削除
4. インストール処理（通常時）
   ├─ 既存インストール確認
   ├─ DownloadAndExtractでダウンロード・展開
   └─ NewScriptShimでシム生成
```

### フローチャート

```mermaid
flowchart TD
    A[install-cmake開始] --> B[引数解析]
    B --> C[パス計算]
    C --> D{--clean?}
    D -->|Yes| E[ディレクトリ削除]
    E --> F[シム削除]
    F --> G[一時ファイル削除]
    G --> H[終了]
    D -->|No| I{既存インストールあり?}
    I -->|Yes かつ force=false| J[スキップ]
    I -->|No または force=true| K[DownloadAndExtract実行]
    K --> L{成功?}
    L -->|No| M[エラー終了]
    L -->|Yes| N[NewScriptShim実行]
    N --> O{成功?}
    O -->|No| M
    O -->|Yes| P[正常終了]
    J --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ダウンロードエラー | CMakeアーカイブのダウンロード失敗 | ネットワーク確認、URL確認 |
| 1 | 展開エラー | アーカイブの展開失敗 | ディスク容量確認 |
| 1 | シム生成エラー | シムスクリプトの生成失敗 | 権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（デフォルト） |
| リトライ間隔 | 30秒（デフォルト） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

Write-PipelineTelemetryError関数でAzure Pipelinesにエラーを報告します。--cleanオプションで既存インストールを削除してから再実行できます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回（ツール初期化時） |
| 目標処理時間 | 数秒〜数分（ネットワーク速度に依存） |
| メモリ使用量上限 | 制限なし |
| ディスク使用量 | 約100MB |

## 排他制御

同一ディレクトリへの同時インストールは想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | スキップ時 | "$tool_name ($version) already exists, skipping install" |
| 情報ログ | クリーン時 | "Cleaning $tool_install_directory" |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによるエラー報告 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理結果 | 失敗時 | Azure Pipelines（Write-PipelineTelemetryError） |

## 備考

- common-library.shの関数（GetCurrentOS, DownloadAndExtract, NewScriptShim等）を使用します
- サポートされるOS：Linux, MacOS（GetCurrentOS関数で検出）
- アーキテクチャ：x86_64のみ
- シムスクリプトは常に最新バージョンを参照するように上書きされます（force=true）
- ダウンロードURLの形式例：
  - Linux: {baseuri}/linux/cmake/cmake-3.25.1-Linux-x86_64.tar.gz
  - MacOS: {baseuri}/macos/cmake/cmake-3.25.1-MacOS-x86_64.tar.gz
- --forceオプションを使用しない限り、既存インストールはスキップされます
- 一時ファイルは{installpath}のtempサブディレクトリに保存されます
