# バッチ設計書 81-install-cmake-test.sh

## 概要

本ドキュメントは、CMakeインストールテスト用スクリプト `eng/common/native/install-cmake-test.sh` の設計仕様を定義するものです。このスクリプトはネイティブビルドツールのインストール検証機能を提供します。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynプロジェクトのネイティブビルドでは、CMakeが重要なビルドツールとして使用されます。本スクリプトは、CMakeのインストールが正しく行われたことを検証するためのテストツールとして機能します。CI/CDパイプラインにおいて、ビルド環境が正しく構成されていることを確認することで、ビルドの安定性と再現性を保証します。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド前検証時、またはネイティブツールのセットアップ後の検証時に実行されます。手動でのツールインストール検証にも使用可能です。

**主要な処理内容**：
1. コマンドライン引数のパース（baseuri、installpath、version、clean、force等）
2. ツールの存在確認と既存インストールのスキップ判定
3. クリーンモードでの既存インストールの削除
4. ツールアーカイブのダウンロードと展開
5. シムスクリプトの生成

**前後の処理との関連**：`eng/common/native/install-cmake.sh` でCMakeがインストールされた後、このスクリプトでインストールが正しく行われたことを検証します。共通ライブラリ `common-library.sh` の関数に依存しています。

**影響範囲**：ローカルのネイティブツールインストールディレクトリ、およびシムファイルに影響を与えます。

## バッチ種別

ツール検証 / インストール検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動/CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| common-library.sh | 共通ライブラリスクリプトが存在すること |
| baseuri | ツールアーカイブのダウンロード元URIが指定されていること |
| installpath | インストール先パスが指定されていること |
| version | インストールするバージョンが指定されていること |

### 実行可否判定

- `--clean`オプション指定時：クリーンアップ処理のみ実行し終了
- ツールが既にインストール済みかつ`--force`未指定の場合：スキップ
- それ以外：ダウンロード・インストール処理を実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --baseuri | string | No | 空 | ツールアーカイブのベースURL |
| --installpath | string | No | 空 | インストール先ディレクトリ |
| --version | string | No | 空 | インストールするバージョン |
| --clean | flag | No | false | クリーンアップモード |
| --force | flag | No | false | 強制インストール |
| --downloadretries | int | No | 5 | ダウンロードリトライ回数 |
| --retrywaittimeseconds | int | No | 30 | リトライ間隔（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ツールアーカイブ | tar.gz | リモートサーバーからダウンロードするCMakeテストツール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $install_path/$tool_name/$version/ | ディレクトリ | ツールのインストール先 |
| $install_path/$tool_name.sh | シェルスクリプト | ツール実行用シムスクリプト |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | cmake-test.sh（シム） |
| 出力先 | $install_path/ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ 共通ライブラリのロード
2. コマンドライン引数パース
   └─ 各オプションの解析と変数設定
3. ツールパス構築
   └─ OS/アーキテクチャに基づくパス生成
4. クリーンモード判定
   └─ --clean指定時は削除処理を実行
5. 既存インストール確認
   └─ 既存かつ--force未指定時はスキップ
6. ダウンロードと展開
   └─ DownloadAndExtract関数でアーカイブ取得
7. シム生成
   └─ NewScriptShim関数でシムスクリプト作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[共通ライブラリロード]
    B --> C[引数パース]
    C --> D{クリーンモード?}
    D -->|Yes| E[既存ファイル削除]
    E --> F[終了 exit 0]
    D -->|No| G{既存インストールあり?}
    G -->|Yes & !force| H[スキップ終了 exit 0]
    G -->|No or force| I[DownloadAndExtract]
    I --> J{成功?}
    J -->|No| K[エラー終了 exit 1]
    J -->|Yes| L[NewScriptShim]
    L --> M{成功?}
    M -->|No| K
    M -->|Yes| N[正常終了 exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | インストール失敗 | DownloadAndExtract関数が失敗 | ネットワーク接続・URLを確認 |
| 1 | シム生成失敗 | NewScriptShim関数が失敗 | 権限・パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（デフォルト） |
| リトライ間隔 | 30秒（デフォルト） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

1. ネットワーク接続を確認
2. base_uriの妥当性を確認
3. install_pathへの書き込み権限を確認
4. --forceオプションで再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ツール |
| 目標処理時間 | 数分以内（ネットワーク状況に依存） |
| メモリ使用量上限 | 特になし |

## 排他制御

同時実行は推奨されません。同一インストールパスへの並列インストールは競合の原因となります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | クリーン時 | "Cleaning $tool_install_directory" |
| スキップログ | 既存インストール時 | "$tool_name ($version) already exists, skipping install" |
| エラーログ | 失敗時 | Write-PipelineTelemetryError による出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | Azure Pipelines |

## 備考

- このスクリプトはdotnet/arcadeフレームワークの共通インフラストラクチャの一部です
- OSはGetCurrentOS関数により自動検出されます
- アーキテクチャはx86_64固定です
