# バッチ設計書 82-install-dependencies.sh

## 概要

本ドキュメントは、依存パッケージインストールスクリプト `eng/common/native/install-dependencies.sh` の設計仕様を定義するものです。このスクリプトはCI環境およびローカル開発環境において、ネイティブビルドに必要な依存パッケージを自動インストールします。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynプロジェクトのビルドには、cmake、llvm、clang、lld、lldb等の多くのネイティブツールが必要です。これらの依存関係を各開発者やCIマシンで手動インストールすることは非効率であり、環境差異によるビルド失敗の原因となります。本スクリプトは、OS/ディストリビューションを自動検出し、適切なパッケージマネージャを使用して必要なパッケージを一括インストールすることで、ビルド環境の標準化と構築効率化を実現します。

**バッチの実行タイミング**：CI/CDパイプラインのビルド準備フェーズ、または新規開発環境のセットアップ時に実行されます。通常はビルドの前提条件として最初に実行されます。

**主要な処理内容**：
1. 引数またはinit-os-and-arch.shからOS情報を取得
2. OSに応じた処理分岐（Linux/macOS等）
3. Linuxの場合、ディストリビューション（Debian/Fedora/Alpine等）を検出
4. 適切なパッケージマネージャ（apt/dnf/apk/brew）でビルドツールをインストール
5. Debian系の場合、ロケール設定も実行

**前後の処理との関連**：本スクリプトはビルドの最初に実行される前提条件スクリプトです。`init-os-and-arch.sh`を使用してOS情報を取得します。インストール完了後、cmake等のビルドツールが使用可能になります。

**影響範囲**：システムのパッケージデータベース、インストール済みパッケージ、ロケール設定に影響します。管理者権限が必要な操作を含みます。

## バッチ種別

環境構築 / 依存パッケージインストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（環境構築時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動/CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 管理者権限 | apt/dnf/apk等のパッケージインストールに必要 |
| ネットワーク接続 | パッケージのダウンロードに必要 |
| サポートOS | Linux (Debian/Fedora/RHEL/Alpine/Amazon Linux) または macOS |

### 実行可否判定

- OSが認識できない場合は "Unsupported platform" または "Unsupported distro" でexit 1
- サポートされているOS/ディストリビューションの場合のみ実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (OS) | string | No | 自動検出 | 対象OS（linux/osx/maccatalyst/ios等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/os-release | 設定ファイル | Linuxディストリビューション情報 |
| init-os-and-arch.sh | シェルスクリプト | OS自動検出用スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| システムパッケージ | バイナリ | インストールされたビルドツール |
| /usr/share/locale | ロケール | en_US.UTF-8ロケール（Debian系） |

### 出力ファイル仕様

本バッチはシステムパッケージをインストールするため、特定のファイル出力仕様はありません。

## 処理フロー

### 処理シーケンス

```
1. OS情報取得
   └─ 引数から取得、または init-os-and-arch.sh で自動検出
2. OS判定
   └─ linux/osx/maccatalyst/ios等に分岐
3. [Linux] ディストリビューション検出
   └─ /etc/os-release から ID/ID_LIKE を読み取り
4. [Linux] パッケージインストール
   └─ Debian系: apt install
   └─ Fedora/RHEL系: dnf install
   └─ Alpine: apk add
5. [Linux/Debian] ロケール設定
   └─ en_US.UTF-8 ロケールを定義
6. [macOS] Homebrew でパッケージインストール
   └─ brew bundle で必要パッケージをインストール
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{OS引数あり?}
    B -->|Yes| C[引数からOS取得]
    B -->|No| D[init-os-and-arch.sh実行]
    C --> E{OS判定}
    D --> E
    E -->|linux| F[/etc/os-release読込]
    E -->|osx/mac*| G[Homebrew install]
    E -->|その他| H[Unsupported platform exit 1]
    F --> I{ディストリビューション}
    I -->|debian系| J[apt update && apt install]
    I -->|fedora/rhel系| K[dnf install]
    I -->|alpine| L[apk add]
    I -->|その他| M[Unsupported distro exit 1]
    J --> N[localedef設定]
    K --> O[正常終了]
    L --> O
    N --> O
    G --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 未サポートプラットフォーム | OSが認識できない場合 | サポートOSで実行 |
| 1 | 未サポートディストリビューション | Linuxでディストリビューションが未対応 | 手動でパッケージをインストール |
| (任意) | パッケージインストール失敗 | ネットワーク障害/パッケージ不存在 | ネットワーク確認/リポジトリ設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（パッケージマネージャに依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ネットワーク接続を確認
2. パッケージリポジトリの設定を確認
3. 管理者権限で実行しているか確認
4. 手動で個別パッケージをインストール

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | パッケージマネージャ依存 |
| コミットタイミング | 各パッケージインストール完了時 |
| ロールバック条件 | パッケージマネージャ依存 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 10-20パッケージ |
| 目標処理時間 | 数分〜十数分（ネットワーク・キャッシュ状況に依存） |
| メモリ使用量上限 | パッケージマネージャ依存 |

## 排他制御

パッケージマネージャのロック機構により、同一システムでの並列実行は制御されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | macOS時 | "Installed xcode version: ..." |
| エラーログ | 未サポートOS | "Unsupported platform. OS: $os" |
| エラーログ | 未サポートdistro | "Unsupported distro. distro: $ID" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | CI/CDパイプライン |

## 備考

- Debian系でインストールされるパッケージ: build-essential, gettext, locales, cmake, llvm, clang, lld, lldb, liblldb-dev, libunwind8-dev, libicu-dev, liblttng-ust-dev, libssl-dev, libkrb5-dev, pigz, cpio
- Fedora/RHEL系でインストールされるパッケージ: cmake, llvm, lld, lldb, clang, python, curl, libicu-devel, openssl-devel, krb5-devel, lttng-ust-devel, pigz, cpio
- Alpine でインストールされるパッケージ: build-base, cmake, bash, curl, clang, llvm-dev, lld, lldb, krb5-dev, lttng-ust-dev, icu-dev, openssl-dev, pigz, cpio
- macOS でインストールされるパッケージ: cmake, icu4c, openssl@3, pkgconf, python3, pigz
- `set -e` により、コマンド失敗時は即座にスクリプトが終了します
