# バッチ設計書 83-install-tool.ps1

## 概要

本ドキュメントは、ネイティブツールインストールスクリプト `eng/common/native/install-tool.ps1` の設計仕様を定義するものです。このPowerShellスクリプトは、Azure Blob Storageからネイティブビルドツール（主にCMake）をダウンロードしてインストールします。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynプロジェクトのネイティブビルドでは、特定バージョンのビルドツールが必要です。開発者やCIマシンで異なるバージョンのツールが使用されると、ビルドの再現性が損なわれます。本スクリプトは、Azure Blob Storageから指定バージョンのツールをダウンロードし、統一されたインストール先に配置することで、ビルド環境の一貫性を確保します。

**バッチの実行タイミング**：CI/CDパイプラインのビルド準備フェーズ、またはローカル開発環境でネイティブツールが必要な際に実行されます。

**主要な処理内容**：
1. コマンドライン引数の解析（ToolName、InstallPath、BaseUri、Version等）
2. マシンアーキテクチャの検出（x32/x64）
3. クリーンモードでの既存インストール削除
4. ツールアーカイブのダウンロードと展開
5. ツール実行ファイルの検索と検証
6. シム実行ファイルの生成

**前後の処理との関連**：`CommonLibrary.psm1`モジュールの関数に依存します。`pipeline-logging-functions.ps1`を使用してAzure Pipelinesへのテレメトリを出力します。インストール後のツールは、ビルドスクリプトから参照されます。

**影響範囲**：指定されたインストールディレクトリ、シムファイル、一時ダウンロードファイルに影響します。

## バッチ種別

ツールインストール / 環境構築

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動/CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CommonLibrary.psm1 | 共通ライブラリモジュールが存在すること |
| pipeline-logging-functions.ps1 | パイプラインログ関数が存在すること |
| ネットワーク接続 | BaseUriへのアクセスが可能であること |
| PowerShell | Windows PowerShell環境 |

### 実行可否判定

- `-Clean`スイッチ指定時：クリーンアップ処理のみ実行してexit 0
- ツールが既にインストール済みかつ`-Force`未指定の場合：スキップ
- それ以外：ダウンロード・インストール処理を実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -ToolName | string | Yes | - | インストールするツール名 |
| -InstallPath | string | Yes | - | インストール先ベースディレクトリ |
| -BaseUri | string | Yes | - | ツールアーカイブのベースURL |
| -Version | string | Yes | - | インストールするバージョン |
| -CommonLibraryDirectory | string | No | $PSScriptRoot | 共通ライブラリのディレクトリ |
| -Force | switch | No | $False | 強制インストール |
| -Clean | switch | No | $False | クリーンアップモード |
| -DownloadRetries | int | No | 5 | ダウンロードリトライ回数 |
| -RetryWaitTimeInSeconds | int | No | 30 | リトライ間隔（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure Blob Storage | ZIP | ツールのアーカイブファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $InstallPath\$ToolName\$Version\ | ディレクトリ | ツールのインストール先 |
| $InstallPath\$ToolName.exe | 実行ファイル | シム実行ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | $ToolName.exe |
| 出力先 | $InstallPath |
| 形式 | Windows実行ファイル（シム） |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ モジュールのインポート、変数設定
2. アーキテクチャ検出
   └─ Get-MachineArchitecture関数でx32/x64判定
3. パス構築
   └─ ツールモニカー、インストールディレクトリ、URI生成
4. クリーンモード判定
   └─ -Clean指定時は削除処理を実行
5. 既存インストール確認
   └─ 既存かつ-Force未指定時はスキップ
6. ダウンロードと展開
   └─ DownloadAndExtract関数でアーカイブ取得
7. ツール実行ファイル検索
   └─ インストールディレクトリ内を再帰検索
8. シム生成
   └─ New-ScriptShim関数でシム作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[モジュールインポート]
    B --> C[アーキテクチャ検出]
    C --> D[パス構築]
    D --> E{クリーンモード?}
    E -->|Yes| F[既存ファイル削除]
    F --> G[exit 0]
    E -->|No| H{既存インストールあり?}
    H -->|Yes & !Force| I[Verbose出力しスキップ]
    H -->|No or Force| J[DownloadAndExtract]
    I --> K[ツール検索]
    J --> L{成功?}
    L -->|No| M[エラー exit 1]
    L -->|Yes| K
    K --> N{1つのexe発見?}
    N -->|複数| O[エラー exit 1]
    N -->|0個| P[エラー exit 1]
    N -->|1個| Q[New-ScriptShim]
    Q --> R{成功?}
    R -->|No| S[エラー return 1]
    R -->|Yes| T[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | インストール失敗 | DownloadAndExtract関数が失敗 | ネットワーク・URLを確認 |
| 1 | ツール未検出 | インストール後にexeが見つからない | アーカイブ内容を確認 |
| 1 | 複数ツール検出 | 同名exeが複数存在 | アーカイブ構造を確認 |
| 1 | シム生成失敗 | New-ScriptShim関数が失敗 | 権限・パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（デフォルト） |
| リトライ間隔 | 30秒（デフォルト） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

1. ネットワーク接続を確認
2. BaseUriの妥当性を確認
3. 指定バージョンのアーカイブが存在するか確認
4. InstallPathへの書き込み権限を確認
5. -Forceオプションで再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ツール |
| 目標処理時間 | 数分以内（ネットワーク状況に依存） |
| メモリ使用量上限 | 特になし |

## 排他制御

同時実行は推奨されません。同一インストールパスへの並列インストールは競合の原因となります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | クリーン時 | "Cleaning $ToolInstallDirectory" |
| Verbose | 既存インストール時 | "$ToolName ($Version) already exists, skipping install" |
| エラーログ | 失敗時 | Write-PipelineTelemetryError出力 |
| エラーログ | 複数exe検出時 | "There are multiple copies of $ToolName..." |
| 情報ログ | exe未検出時 | "$ToolName was not found in $ToolInstallDirectory." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | Azure Pipelines |
| テレメトリ | NativeToolsetBootstrapping カテゴリ | Azure DevOps |

## 備考

- Windows環境専用（win32/win64）
- アーキテクチャに応じてwin32またはwin64のアーカイブを使用
- アーカイブ形式はZIP
- URI形式: `$BaseUri/windows/$ToolName/$ToolName-$Version-$ToolOs-$Arch.zip`
- catchブロックでスタックトレースを出力してデバッグを支援
