# バッチ設計書 84-generate-locproject.ps1

## 概要

本ドキュメントは、ローカリゼーションプロジェクト生成スクリプト `eng/common/generate-locproject.ps1` の設計仕様を定義するものです。このスクリプトは、OneLocBuildタスク用の `LocProject.json` ファイルを自動生成します。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynプロジェクトは多言語対応が必要であり、ローカリゼーション（翻訳）プロセスにはOneLocBuildタスクが使用されます。OneLocBuildはLocProject.jsonファイルに基づいてローカライズ対象ファイルを特定し、翻訳処理を実行します。本スクリプトは、プロジェクト内のローカライズ対象ファイル（.xlf、.json、.wxl、.html等）を自動検出し、適切な形式のLocProject.jsonを生成することで、ローカリゼーションプロセスを自動化・標準化します。

**バッチの実行タイミング**：CI/CDパイプラインでのローカリゼーションビルド前、またはローカリゼーション対象ファイルの変更時に実行されます。

**主要な処理内容**：
1. ソースディレクトリ内のローカライズ対象ファイルを検索
2. .NETテンプレートパターンのJSONファイル検出と処理
3. WinFormsパターンのJSONファイル検出
4. WiX Localization (.wxl) ファイルの検出とスキーマ別分類
5. macOS HTMLファイルの検出
6. XLFファイルの検出と処理
7. 除外リストに基づくファイルフィルタリング
8. LocProject.jsonの生成または既存ファイルとの比較

**前後の処理との関連**：生成されたLocProject.jsonはOneLocBuildタスクによって使用されます。除外設定は`eng/Localize/LocExclusions.json`から読み込まれます。

**影響範囲**：`eng/Localize/LocProject.json`またはLocProject-generated.jsonの生成・更新、中間ファイルの一時作成に影響します。

## バッチ種別

コード生成 / ローカリゼーション支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ローカリゼーションビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ソースディレクトリ | 有効なソースディレクトリが指定されていること |
| pipeline-logging-functions.ps1 | パイプラインログ関数が存在すること |

### 実行可否判定

- ローカライズ対象ファイルが存在しない場合でも、空のLocProject.jsonを生成
- `-UseCheckedInLocProjectJson`指定時、生成ファイルと既存ファイルが異なる場合はexit 1

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -SourcesDirectory | string | Yes | - | ソースファイルのルートディレクトリ |
| -LanguageSet | string | No | 'VS_Main_Languages' | 使用する言語セット |
| -UseCheckedInLocProjectJson | switch | No | $false | 既存のLocProject.jsonと比較モード |
| -CreateNeutralXlfs | switch | No | $true | 中立XLFファイルを作成するか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .template.config/localize/*.en.json | JSON | .NETテンプレートローカライズファイル |
| en/strings.json | JSON | WinFormsローカライズファイル |
| *.xlf | XLF | XLIFFローカライズファイル |
| *.wxl | WXL | WiX Localizationファイル |
| en.lproj/*.html | HTML | macOSインストーラHTMLファイル |
| eng/Localize/LocExclusions.json | JSON | 除外設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| eng/Localize/LocProject.json | JSON | ローカリゼーションプロジェクト定義 |
| eng/Localize/LocProject-generated.json | JSON | 比較モード時の生成ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | LocProject.json または LocProject-generated.json |
| 出力先 | $SourcesDirectory/eng/Localize/ |
| 文字コード | UTF-8 |
| 形式 | JSON（深さ5のネスト） |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ 除外設定ファイルの読み込み
2. .NETテンプレートJSONファイル検索
   └─ .template.config/localize/*.en.json パターンでマッチ
3. WinForms JSONファイル検索
   └─ en/strings.json パターンでマッチ
4. WXLファイル検索と分類
   └─ スキーマに基づきV3/V5に分類
5. macOS HTMLファイル検索
   └─ en.lproj/*.html パターンでマッチ
6. XLFファイル検索
   └─ *.[langcode].xlf パターンでマッチ
7. LocProject構造生成
   └─ 4つのプロジェクトセクションを構築
8. JSON出力
   └─ LocProject.jsonまたは比較処理
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[除外設定読み込み]
    B --> C[.NETテンプレートJSON検索]
    C --> D[WinForms JSON検索]
    D --> E[WXLファイル検索・分類]
    E --> F[macOS HTML検索]
    F --> G[XLFファイル検索]
    G --> H[LocProject構造生成]
    H --> I{UseCheckedIn?}
    I -->|No| J[LocProject.json出力]
    I -->|Yes| K[LocProject-generated.json出力]
    K --> L{ハッシュ比較}
    L -->|一致| M[正常終了]
    L -->|不一致| N[エラー exit 1]
    J --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | LocProject不一致 | 生成ファイルと既存ファイルのハッシュが異なる | 生成ファイルを確認し、必要に応じて更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. LocProject-generated.jsonをダウンロードして内容を確認
2. 意図した変更であればLocProject.jsonを更新
3. 意図しない変更であれば原因を調査

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイル数に依存 |
| 目標処理時間 | 数秒〜数分 |
| メモリ使用量上限 | 特になし |

## 排他制御

特に排他制御は必要ありません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | JSON生成時 | "LocProject.json generated:\n\n$json" |
| 情報ログ | 一致時 | "Generated LocProject.json and current LocProject.json are identical." |
| エラーログ | 不一致時 | Write-PipelineTelemetryError出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | Azure Pipelines (OneLocBuildカテゴリ) |

## 備考

- サポートするファイル形式：
  - .NETテンプレート JSON (.template.config/localize/*.en.json)
  - WinForms JSON (en/strings.json)
  - XLIFF (.xlf)
  - WiX Localization V3 (http://schemas.microsoft.com/wix/2006/localization)
  - WiX Localization V5 (http://wixtoolset.org/schemas/v4/wxl)
  - macOS HTML (en.lproj/*.html)
- 言語セットはOneLocBuildの設定に対応
- CloneLanguageSetはWiXおよびmacOS用に別途設定
- LssFilesはパーサー設定ファイルを指定
