# バッチ設計書 85-enable-cross-org-publishing.ps1

## 概要

本ドキュメントは、クロス組織公開有効化スクリプト `eng/common/enable-cross-org-publishing.ps1` の設計仕様を定義するものです。このスクリプトは、Azure DevOps環境でNuGetパッケージの組織間公開を有効化するための環境変数を設定します。

### 本バッチの処理概要

**業務上の目的・背景**：.NETエコシステムでは、複数のAzure DevOps組織（dnceng、devdiv等）間でNuGetパッケージを共有する必要があります。各組織のNuGetフィードにアクセスするには、適切な認証トークンとURIプレフィックス設定が必要です。本スクリプトは、これらの設定をAzure Pipelinesのパイプライン変数として設定することで、ビルドパイプラインから複数組織のNuGetフィードへアクセスできるようにします。

**バッチの実行タイミング**：Azure DevOps CIパイプラインの初期段階で、NuGetパッケージのリストアまたは公開の前に実行されます。

**主要な処理内容**：
1. パイプラインログ関数のロード
2. CI環境変数の設定（$ci = $true）
3. VSS_NUGET_ACCESSTOKENパイプライン変数の設定
4. VSS_NUGET_URI_PREFIXESパイプライン変数の設定

**前後の処理との関連**：`pipeline-logging-functions.ps1`に定義された`Write-PipelineSetVariable`関数を使用します。設定された変数は後続のNuGetリストア・公開タスクで使用されます。

**影響範囲**：Azure Pipelinesのパイプライン変数（VSS_NUGET_ACCESSTOKEN、VSS_NUGET_URI_PREFIXES）に影響します。

## バッチ種別

環境設定 / パイプライン構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Azure DevOps環境 | Azure Pipelinesで実行されること |
| pipeline-logging-functions.ps1 | パイプラインログ関数が存在すること |
| 認証トークン | 有効なNuGetアクセストークンが引数で提供されること |

### 実行可否判定

- 常に実行可能（引数で提供されたトークンを設定）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -token | string | No | 空文字 | NuGetアクセストークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure DevOps System Access Token | 文字列 | パイプラインから提供されるアクセストークン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VSS_NUGET_ACCESSTOKEN | パイプライン変数 | NuGetフィードアクセス用トークン |
| VSS_NUGET_URI_PREFIXES | パイプライン変数 | 対象NuGetフィードのURIプレフィックス |

### 出力ファイル仕様

本バッチはファイルを出力しません。パイプライン変数のみを設定します。

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ pipeline-logging-functions.ps1をドットソース
2. CI環境設定
   └─ $ci変数を$trueに設定
3. アクセストークン設定
   └─ VSS_NUGET_ACCESSTOKENにトークンを設定
4. URIプレフィックス設定
   └─ VSS_NUGET_URI_PREFIXESに複数組織のURIを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[pipeline-logging-functions.ps1ロード]
    B --> C[$ci = $true設定]
    C --> D[VSS_NUGET_ACCESSTOKEN設定]
    D --> E[VSS_NUGET_URI_PREFIXES設定]
    E --> F[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

本スクリプトは明示的なエラー処理を実装していません。Write-PipelineSetVariable関数内でのエラー処理に依存します。

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 変数設定失敗 | Write-PipelineSetVariableが失敗 | パイプラインログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. パイプラインログでエラーメッセージを確認
2. トークンの有効性を確認
3. パイプライン権限設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2変数設定 |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特に排他制御は必要ありません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| パイプライン変数 | 設定時 | Azure Pipelinesのログコマンド形式 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 変数設定成功 | - | Azure Pipelines |

## 備考

- 設定されるNuGetフィードURIプレフィックス：
  - https://dnceng.pkgs.visualstudio.com/
  - https://pkgs.dev.azure.com/dnceng/
  - https://devdiv.pkgs.visualstudio.com/
  - https://pkgs.dev.azure.com/devdiv/
- IsMultiJobVariableは$falseに設定（現在のジョブのみ）
- $ci変数はWrite-PipelineSetVariableの動作に必要
- トークンはシークレットとして扱われるべき
