# バッチ設計書 86-enable-preview-sdks.ps1

## 概要

本ドキュメントは、プレビューSDK有効化スクリプト `eng/enable-preview-sdks.ps1` の設計仕様を定義するものです。このスクリプトは、Visual Studioで.NETプレビューSDKの使用を有効化します。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynプロジェクトは.NETの最新機能を活用するため、プレビュー版の.NET SDKを使用することがあります。しかし、Visual StudioはデフォルトでプレビューSDKを無効化しています。本スクリプトは、Visual Studioのインスタンス設定を更新してプレビューSDKの使用を有効化することで、開発者が最新の.NET機能を使用してRoslynを開発できるようにします。

**バッチの実行タイミング**：ローカル開発環境のセットアップ時、または新しいプレビューSDKを使用する必要が生じた際に手動で実行されます。

**主要な処理内容**：
1. build-utils.ps1ユーティリティスクリプトのロード
2. EnablePreviewSdks関数の呼び出し
3. Visual Studioインスタンスの検出
4. インスタンス設定ディレクトリへのsdk.txtファイル作成
5. "UsePreviews=True"設定の書き込み

**前後の処理との関連**：`eng/build-utils.ps1`の`EnablePreviewSdks`関数と`LocateVisualStudio`関数に依存します。実行後、Visual Studioはプレビュー.NET SDKを認識して使用できるようになります。

**影響範囲**：現在インストールされているVisual Studioインスタンスのローカル設定ディレクトリに影響します。

## バッチ種別

環境設定 / IDE構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発環境セットアップ時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio | Visual Studioがインストールされていること |
| build-utils.ps1 | ユーティリティスクリプトが存在すること |
| Windows環境 | Windows上で実行されること |

### 実行可否判定

- Visual Studioがインストールされていない場合：メッセージを出力してスキップ
- Visual Studioが検出された場合：設定を更新

## 入力仕様

### 入力パラメータ

本スクリプトは入力パラメータを受け取りません。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Visual Studio インストール情報 | vswhere出力 | インストール済みVSインスタンス情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| %USERPROFILE%\AppData\Local\Microsoft\VisualStudio\{version}_{id}\sdk.txt | テキスト | プレビューSDK有効化設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sdk.txt |
| 出力先 | %USERPROFILE%\AppData\Local\Microsoft\VisualStudio\{version}_{id}\ |
| 文字コード | デフォルト（ASCII） |
| 内容 | UsePreviews=True |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ StrictModeとErrorActionPreferenceの設定
2. ユーティリティスクリプトロード
   └─ build-utils.ps1をドットソース
3. EnablePreviewSdks関数呼び出し
   └─ LocateVisualStudioでVSインスタンス検出
   └─ インスタンスIDとバージョン取得
   └─ 設定ディレクトリパス構築
   └─ sdk.txtファイル作成・書き込み
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[StrictMode設定]
    B --> C[build-utils.ps1ロード]
    C --> D[EnablePreviewSdks呼び出し]
    D --> E[LocateVisualStudio]
    E --> F{VS検出?}
    F -->|No| G[スキップメッセージ出力]
    F -->|Yes| H[インスタンス情報取得]
    H --> I[設定ディレクトリ作成]
    I --> J[sdk.txt書き込み]
    J --> K[正常終了]
    G --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | VSなし | Visual Studioがインストールされていない | VSをインストール |
| - | 書き込み失敗 | 設定ディレクトリへのアクセス権限なし | 権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. Visual Studioのインストール状態を確認
2. ユーザープロファイルディレクトリへのアクセス権限を確認
3. 手動でsdk.txtを作成

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 VSインスタンス |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

Visual Studioが実行中でも設定は適用されますが、反映にはVSの再起動が必要な場合があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | VS未検出時 | "No Visual Studio installation found; skipping enabling preview SDKs" |
| 情報ログ | 設定時 | "Enabling preview SDKs by writing to $sdkFile" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

- sdk.txtファイルのパス形式: `%USERPROFILE%\AppData\Local\Microsoft\VisualStudio\{majorVersion}.0_{instanceId}\sdk.txt`
- Visual Studioのメジャーバージョン（17.0等）とインスタンスIDが使用される
- この設定はVisual Studio全体に影響し、全てのプロジェクトでプレビューSDKが使用可能になる
- プレビューSDKの使用には潜在的なリスクがあるため、開発環境のみで使用すること
- Set-StrictMode -version 2.0で厳格モードを有効化
- ErrorActionPreference="Stop"でエラー時に即座に停止
