# バッチ設計書 87-findibc.ps1

## 概要

本ドキュメントは、IBCデータ検索スクリプト `eng/findibc.ps1` の設計仕様を定義するものです。このスクリプトは、ビルド最適化のためのIBC（Instrumentation-Based Code）プロファイルデータを検索します。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynコンパイラのパフォーマンス最適化には、プロファイルに基づく最適化（PGO: Profile-Guided Optimization）が使用されます。IBCファイルは、実行時の動作パターンを記録したプロファイルデータであり、これを使用することでコンパイラのスタートアップ時間や実行時パフォーマンスを改善できます。本スクリプトは、特定のアセンブリに対応するIBCファイルを検索し、ビルドプロセスで使用できるようにします。

**バッチの実行タイミング**：MSBuildプロセスから呼び出され、各アセンブリのビルド時にIBCファイルを検索します。

**主要な処理内容**：
1. 入力パラメータ（中間アセンブリパス、IBCルートフォルダ）の取得
2. アセンブリ名の抽出
3. IBCルートフォルダの存在確認
4. 対象アセンブリのDLLファイル検索
5. 同じディレクトリ内のIBCファイル列挙
6. IBCファイルパスの結合・出力

**前後の処理との関連**：MSBuildから呼び出され、出力されたIBCファイルパスはビルドの最適化フェーズで使用されます。

**影響範囲**：ビルドプロセスに情報を提供するのみで、ファイルシステムへの変更はありません。

## バッチ種別

データ検索 / ビルド支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | MSBuildタスク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| IBCルートフォルダ | プロダクトデータディレクトリが存在すること（オプション） |
| 中間アセンブリ | ビルド対象アセンブリのパスが指定されること |

### 実行可否判定

- IBCルートフォルダが存在しない場合：空文字を返して終了
- 対象アセンブリのDLLが見つからない場合：空文字を返して終了
- IBCファイルが見つからない場合：空文字を返して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -intermediateAssembly | string | No | - | ビルド対象の中間アセンブリパス |
| -ibcRootFolder | string | No | - | IBCファイルのルートディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| IBCルートフォルダ | ディレクトリ | IBCプロファイルデータを含むディレクトリ構造 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | 文字列 | スペース区切りのIBCファイルパスリスト |

### 出力ファイル仕様

本バッチはファイルを出力しません。標準出力でIBCファイルパスを返します。

| 項目 | 内容 |
|-----|------|
| 形式 | スペース区切りの絶対パス |
| 例 | "C:\ibc\asm1.ibc C:\ibc\asm2.ibc" |

## 処理フロー

### 処理シーケンス

```
1. パラメータ取得
   └─ intermediateAssembly、ibcRootFolderを取得
2. アセンブリ名抽出
   └─ Path.GetFileNameでファイル名を取得
3. ルートフォルダ確認
   └─ Directory.Existsで存在確認
   └─ 存在しない場合は空文字を返す
4. DLLファイル検索
   └─ EnumerateFilesで再帰検索
   └─ SingleOrDefaultで単一ファイル取得
5. IBCファイル列挙
   └─ DLLと同じディレクトリで*.ibcを検索
6. パスリスト生成
   └─ スペース区切りで結合
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[アセンブリ名抽出]
    B --> C[IBCルートフォルダパス正規化]
    C --> D{フォルダ存在?}
    D -->|No| E[空文字を返す]
    D -->|Yes| F[DirectoryInfo作成]
    F --> G[アセンブリDLL検索]
    G --> H{DLL見つかった?}
    H -->|No| E
    H -->|Yes| I[同ディレクトリのIBCファイル列挙]
    I --> J[パスリスト結合]
    J --> K[結果を返す]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 例外発生 | 予期しないエラー | スタックトレースを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージとスタックトレースを確認
2. 入力パラメータの妥当性を確認
3. IBCルートフォルダのアクセス権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1アセンブリ |
| 目標処理時間 | 100ms以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

読み取り専用操作のため、排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 例外発生時 | $_（エラーメッセージ） |
| エラーログ | 例外発生時 | $_.Exception |
| エラーログ | 例外発生時 | $_.ScriptStackTrace |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | ビルドプロセス |

## 備考

- IBCファイルはProfile-Guided Optimization (PGO) に使用される
- EnumerateFilesにAllDirectoriesオプションを使用して再帰検索
- SingleOrDefaultで複数マッチした場合の動作は.NETの標準動作に従う
- finallyブロックでPop-Locationを呼び出しているが、対応するPush-Locationがないため注意が必要
- 空のIBCファイルリストは正常な動作（IBCデータなしでビルド続行）
