# バッチ設計書 88-setup-pr-validation.ps1

## 概要

本ドキュメントは、PR検証セットアップスクリプト `eng/setup-pr-validation.ps1` の設計仕様を定義するものです。このスクリプトは、Pull Request（PR）の挿入検証ビルドのためのGit環境をセットアップします。

### 本バッチの処理概要

**業務上の目的・背景**：RoslynはVisual Studioに統合されており、Visual Studioへの挿入（insertion）プロセスがあります。PRの変更がVisual Studioとの統合に問題を起こさないことを検証するため、挿入検証ビルドが実行されます。本スクリプトは、PRのマージコミットを取得し、指定されたコミットSHAでビルド環境を構成することで、安全で信頼性の高いPR検証を実現します。

**バッチの実行タイミング**：Azure DevOpsのPR検証パイプラインの初期段階で実行されます。

**主要な処理内容**：
1. Gitユーザー設定（マージコミット用）
2. ベースブランチがvs-depsブランチかの確認
3. コミットSHAの長さ検証
4. GitHubリモートの追加
5. PRヘッドと指定コミットSHAの一致確認（オプション）
6. PRのマージrefをプル
7. 指定コミットSHAへのチェックアウト（enforceLatestCommit無効時）

**前後の処理との関連**：このスクリプトの実行後、ビルドプロセスが開始されます。ベースブランチ名、PR番号、コミットSHAはパイプラインから提供されます。

**影響範囲**：ローカルGitリポジトリの状態（ブランチ、コミット、リモート設定）に影響します。

## バッチ種別

環境セットアップ / Git操作

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR検証時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | PR検証パイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | Roslynリポジトリのクローンであること |
| ネットワーク接続 | GitHubへのアクセスが可能であること |
| Git設定権限 | git configコマンドが実行可能であること |

### 実行可否判定

- コミットSHAが7文字未満の場合：エラー終了
- PRマージrefのプルに失敗した場合：エラー終了
- enforceLatestCommit時にPRヘッドと指定SHAが一致しない場合：エラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -sourceBranchName | string | No | - | ベースブランチ名 |
| -prNumber | string | No | - | Pull Request番号 |
| -commitSHA | string | No | - | 検証対象のコミットSHA |
| -enforceLatestCommit | boolean | No | $false | PRヘッドとの一致を強制 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub API | Git ref | PRのマージrefとヘッドref |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Gitリポジトリ | コミット状態 | 指定されたPRマージ状態 |
| Azure Pipelines | ログ | 警告・エラーメッセージ |

### 出力ファイル仕様

本バッチはファイルを出力しません。Gitリポジトリの状態を更新します。

## 処理フロー

### 処理シーケンス

```
1. Gitユーザー設定
   └─ user.name = "RoslynValidation"
   └─ user.email = "validation@roslyn.net"
2. ブランチ名検証
   └─ vs-depsブランチでない場合は警告
3. コミットSHA検証
   └─ 7文字未満の場合はエラー終了
4. GitHubリモート追加
   └─ ghリモートとしてdotnet/roslyn.gitを追加
5. [enforceLatestCommit時] PRヘッド検証
   └─ ls-remoteでPRヘッドSHAを取得
   └─ 指定SHAと先頭一致しない場合はエラー
6. PRマージrefプル
   └─ refs/pull/{prNumber}/mergeをプル
7. [!enforceLatestCommit時] コミットチェックアウト
   └─ 指定commitSHAにチェックアウト
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[git config設定]
    B --> C{vs-depsブランチ?}
    C -->|No| D[警告出力]
    C -->|Yes| E[SHA長検証]
    D --> E
    E --> F{SHA >= 7文字?}
    F -->|No| G[エラー exit 1]
    F -->|Yes| H[ghリモート追加]
    H --> I{enforceLatestCommit?}
    I -->|Yes| J[PRヘッドSHA取得]
    J --> K{SHA一致?}
    K -->|No| L[エラー exit 1]
    K -->|Yes| M[git pull merge ref]
    I -->|No| M
    M --> N{成功?}
    N -->|No| O[エラー exit 1]
    N -->|Yes| P{enforceLatestCommit?}
    P -->|Yes| Q[正常終了]
    P -->|No| R[git checkout SHA]
    R --> S{成功?}
    S -->|No| T[エラー exit 1]
    S -->|Yes| Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | SHA長不足 | commitSHAが7文字未満 | 正しいSHAを指定 |
| 1 | PRヘッド不一致 | PRにレビュー外の変更が追加された | PRを確認し再実行 |
| 1 | プル失敗 | refs/pull/{n}/mergeのプル失敗 | ネットワーク・PR状態を確認 |
| 1 | チェックアウト失敗 | 指定SHAへのチェックアウト失敗 | SHAの存在を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. パイプラインログでエラーメッセージを確認
2. PR番号とコミットSHAの正確性を確認
3. GitHubの一時的な問題の場合は再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（Gitの通常動作） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 PR |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | Gitプロセスに依存 |

## 排他制御

同一ワークスペースでの並列実行は避けるべきです。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | 非vs-depsブランチ時 | "The base branch for insertion validation is {branch}..." |
| エラーログ | SHA長不足時 | "The PR Commit SHA must be at least 7 characters long." |
| エラーログ | PRヘッド不一致時 | "The PR's Head SHA does not begin with the specified commit SHA..." |
| エラーログ | プル失敗時 | "Pulling branch refs/pull/{n}/merge failed." |
| 情報ログ | 各ステップ | 処理内容の説明 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | Azure DevOps パイプライン |
| PRヘッド不一致 | - | セキュリティアラート（レビュー外変更検出） |

## 備考

- Azure DevOpsのログコマンド形式（##vso[task.LogIssue]）を使用
- マージコミット用のGitユーザー名/メールは固定値
- ghリモートはhttps://github.com/dotnet/roslyn.gitを指す
- enforceLatestCommitはセキュリティ機能：レビュー後の不正な変更を検出
- vs-depsブランチはVisual Studio依存関係ブランチ
- refs/pull/{n}/mergeはGitHubが提供するPRマージプレビューref
